/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.nekohtml;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.ParsedHtmlAttribute;
import org.apache.shindig.gadgets.parse.ParsedHtmlNode;
import org.cyberneko.html.parsers.DOMFragmentParser;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLDocument;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NekoHtmlParser
extends GadgetHtmlParser {
    Provider<HTMLDocument> documentProvider;

    @Inject
    public NekoHtmlParser(Provider<HTMLDocument> documentProvider) {
        this.documentProvider = documentProvider;
    }

    @Override
    public List<ParsedHtmlNode> parse(String source) throws GadgetException {
        try {
            Document doc = this.parseFragment(source);
            return NekoHtmlParser.unwrapNodeList(doc.getFirstChild().getChildNodes());
        }
        catch (Exception e) {
            throw new GadgetException(GadgetException.Code.HTML_PARSE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Document parseDom(String source) throws GadgetException {
        try {
            return this.parseFragment(source);
        }
        catch (Exception e) {
            throw new GadgetException(GadgetException.Code.HTML_PARSE_ERROR, (Throwable)e);
        }
    }

    private Document parseFragment(String source) throws SAXException, IOException {
        InputSource input = new InputSource(new StringReader(source));
        DOMFragmentParser parser = new DOMFragmentParser();
        HTMLDocument htmlDoc = (HTMLDocument)this.documentProvider.get();
        DocumentFragment fragment = htmlDoc.createDocumentFragment();
        parser.parse(input, fragment);
        Node htmlNode = XmlUtil.getFirstNamedChildNode((Node)fragment, (String)"HTML");
        if (htmlNode != null) {
            htmlDoc.appendChild(htmlNode);
        } else {
            Node root = htmlDoc.appendChild(htmlDoc.createElement("HTML"));
            root.appendChild(fragment);
        }
        return htmlDoc;
    }

    private static List<ParsedHtmlNode> unwrapNodeList(NodeList nodeList) {
        if (nodeList == null) {
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayListWithExpectedSize((int)nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            list.add(new NodeWrapper(nodeList.item(i)));
        }
        return list;
    }

    private static List<ParsedHtmlAttribute> unwrapAttributeList(NamedNodeMap attrList) {
        if (attrList == null) {
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayListWithExpectedSize((int)attrList.getLength());
        for (int i = 0; i < attrList.getLength(); ++i) {
            list.add(new AttributeWrapper(attrList.item(i)));
        }
        return list;
    }

    static class AttributeWrapper
    implements ParsedHtmlAttribute {
        private Node wrapped;

        AttributeWrapper(Node wrapped) {
            this.wrapped = wrapped;
        }

        public String getName() {
            return this.wrapped.getNodeName();
        }

        public String getValue() {
            return this.wrapped.getNodeValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NodeWrapper
    implements ParsedHtmlNode {
        private Node wrapped;
        private List<ParsedHtmlAttribute> attributes;
        private List<ParsedHtmlNode> children;

        NodeWrapper(Node wrapped) {
            this.wrapped = wrapped;
            this.getChildren();
            this.getAttributes();
        }

        @Override
        public String getTagName() {
            if (this.wrapped.getNodeType() == 3) {
                return null;
            }
            return this.wrapped.getNodeName();
        }

        @Override
        public List<ParsedHtmlAttribute> getAttributes() {
            if (this.wrapped.getNodeType() == 3) {
                return null;
            }
            if (this.attributes == null) {
                this.attributes = NekoHtmlParser.unwrapAttributeList(this.wrapped.getAttributes());
            }
            return this.attributes;
        }

        @Override
        public List<ParsedHtmlNode> getChildren() {
            if (this.wrapped.getNodeType() == 3) {
                return null;
            }
            if (this.children == null) {
                this.children = NekoHtmlParser.unwrapNodeList(this.wrapped.getChildNodes());
            }
            if (this.children.isEmpty()) {
                return null;
            }
            return this.children;
        }

        @Override
        public String getText() {
            if (this.wrapped.getNodeType() == 3) {
                return this.wrapped.getTextContent();
            }
            return null;
        }
    }
}

