/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.preload;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.FetchResponseUtils;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.http.ContentFetcherFactory;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.oauth.OAuthArguments;
import org.apache.shindig.gadgets.preload.PreloadedData;
import org.apache.shindig.gadgets.preload.Preloader;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.Preload;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpPreloader
implements Preloader {
    private final ContentFetcherFactory fetcher;

    @Inject
    public HttpPreloader(ContentFetcherFactory fetcherFactory) {
        this.fetcher = fetcherFactory;
    }

    @Override
    public Map<String, Callable<PreloadedData>> createPreloadTasks(GadgetContext context, GadgetSpec gadget) {
        HashMap preloads = Maps.newHashMap();
        for (Preload preload : gadget.getModulePrefs().getPreloads()) {
            preloads.put(preload.getHref().toString(), new PreloadTask(context, preload));
        }
        return preloads;
    }

    private static class HttpPreloadData
    implements PreloadedData {
        private final JSONObject data;

        public HttpPreloadData(HttpResponse response) {
            JSONObject data = null;
            try {
                data = FetchResponseUtils.getResponseAsJson(response, response.getResponseAsString());
            }
            catch (JSONException e) {
                data = new JSONObject();
            }
            this.data = data;
        }

        public Object toJson() {
            return this.data;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PreloadTask
    implements Callable<PreloadedData> {
        private final GadgetContext context;
        private final Preload preload;

        public PreloadTask(GadgetContext context, Preload preload) {
            this.context = context;
            this.preload = preload;
        }

        @Override
        public PreloadedData call() throws Exception {
            HttpRequest request = new HttpRequest(this.preload.getHref()).setSecurityToken(this.context.getToken()).setOAuthArguments(new OAuthArguments(this.preload)).setAuthType(this.preload.getAuthType()).setContainer(this.context.getContainer()).setGadget(Uri.fromJavaUri((URI)this.context.getUrl()));
            return new HttpPreloadData(HttpPreloader.this.fetcher.fetch(request));
        }
    }
}

