/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.Check;

public class RenderingResults {
    private final Status status;
    private final String content;
    private final String errorMessage;
    private final Uri redirect;

    private RenderingResults(Status status, String content, String errorMessage, Uri redirect) {
        this.status = status;
        this.content = content;
        this.errorMessage = errorMessage;
        this.redirect = redirect;
    }

    public static RenderingResults ok(String content) {
        return new RenderingResults(Status.OK, content, null, null);
    }

    public static RenderingResults error(String errorMessage) {
        return new RenderingResults(Status.ERROR, null, errorMessage, null);
    }

    public static RenderingResults mustRedirect(Uri redirect) {
        return new RenderingResults(Status.MUST_REDIRECT, null, null, redirect);
    }

    public Status getStatus() {
        return this.status;
    }

    public String getContent() {
        Check.eq((Object)((Object)this.status), (Object)((Object)Status.OK), (String)"Only available when status is OK.");
        return this.content;
    }

    public String getErrorMessage() {
        Check.eq((Object)((Object)this.status), (Object)((Object)Status.ERROR), (String)"Only available when status is ERROR.");
        return this.errorMessage;
    }

    public Uri getRedirect() {
        Check.eq((Object)((Object)this.status), (Object)((Object)Status.MUST_REDIRECT), (String)"Only available when status is MUST_REDIRECT.");
        return this.redirect;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        OK,
        MUST_REDIRECT,
        ERROR;

    }
}

