/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.inject.Inject;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.common.servlet.InjectedServlet;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.render.Renderer;
import org.apache.shindig.gadgets.render.RenderingResults;
import org.apache.shindig.gadgets.servlet.HttpGadgetContext;
import org.apache.shindig.gadgets.servlet.HttpUtil;

public class GadgetRenderingServlet
extends InjectedServlet {
    private static final int DEFAULT_CACHE_TTL = 300;
    private Renderer renderer;

    @Inject
    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    private void render(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getHeader("X-shindig-dos") != null) {
            resp.sendError(403);
            return;
        }
        resp.setContentType("text/html");
        resp.setCharacterEncoding("UTF-8");
        HttpGadgetContext context = new HttpGadgetContext(req);
        RenderingResults results = this.renderer.render(context);
        switch (results.getStatus()) {
            case OK: {
                if (((GadgetContext)context).getIgnoreCache()) {
                    HttpUtil.setCachingHeaders(resp, 0);
                } else if (req.getParameter("v") != null) {
                    HttpUtil.setCachingHeaders(resp, true);
                } else {
                    HttpUtil.setCachingHeaders(resp, 300, true);
                }
                resp.getWriter().print(results.getContent());
                break;
            }
            case ERROR: {
                resp.sendError(502, results.getErrorMessage());
                break;
            }
            case MUST_REDIRECT: {
                resp.sendRedirect(results.getRedirect().toString());
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getHeader("If-Modified-Since") != null && !"1".equals(req.getParameter("nocache")) && req.getParameter("v") != null) {
            resp.setStatus(304);
            return;
        }
        this.render(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.render(req, resp);
    }
}

