/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.shindig.common.util.ResourceLoader;
import org.apache.shindig.common.xml.DomUtil;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.JsLibrary;
import org.apache.shindig.gadgets.rewrite.GadgetRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OpenSocialI18NGadgetRewriter
implements GadgetRewriter {
    private static final String I18N_FEATURE_NAME = "opensocial-i18n";
    private static final String DATA_PATH = "features/i18n/data/";
    private Map<Locale, String> i18nConstantsCache = new HashMap<Locale, String>();

    public void rewrite(Gadget gadget, MutableContent mutableContent) {
        if (gadget.sanitizeOutput()) {
            return;
        }
        if (!gadget.getAllFeatures().contains(I18N_FEATURE_NAME)) {
            return;
        }
        try {
            Document document = mutableContent.getDocument();
            Element head = (Element)DomUtil.getFirstNamedChildNode((Node)document.getDocumentElement(), (String)"head");
            this.injectI18NConstants(gadget, head);
            mutableContent.documentChanged();
        }
        catch (GadgetException e) {
            throw new RuntimeException(e);
        }
    }

    private void injectI18NConstants(Gadget gadget, Node headTag) throws GadgetException {
        StringBuilder inlineJs = new StringBuilder();
        Locale locale = gadget.getContext().getLocale();
        if (this.i18nConstantsCache.containsKey(locale)) {
            inlineJs.append(this.i18nConstantsCache.get(locale));
        } else {
            String localeName = this.getLocaleNameForLoadingI18NConstants(locale);
            JsLibrary dateTimeConstants = JsLibrary.create(JsLibrary.Type.RESOURCE, "features/i18n/data/DateTimeConstants__" + localeName + ".js", I18N_FEATURE_NAME, null);
            JsLibrary numberConstants = JsLibrary.create(JsLibrary.Type.RESOURCE, "features/i18n/data/NumberFormatConstants__" + localeName + ".js", I18N_FEATURE_NAME, null);
            inlineJs.append(dateTimeConstants.getContent()).append("\n").append(numberConstants.getContent());
            this.i18nConstantsCache.put(locale, inlineJs.toString());
        }
        Element inlineTag = headTag.getOwnerDocument().createElement("script");
        headTag.appendChild(inlineTag);
        inlineTag.appendChild(headTag.getOwnerDocument().createTextNode(inlineJs.toString()));
    }

    String getLocaleNameForLoadingI18NConstants(Locale locale) {
        String content;
        String localeName = "en";
        String language = locale.getLanguage();
        String country = locale.getCountry();
        if (!language.equalsIgnoreCase("ALL")) {
            try {
                content = this.attemptToLoadResource(language);
                localeName = language;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (!country.equalsIgnoreCase("ALL")) {
            try {
                content = this.attemptToLoadResource(localeName + "_" + country);
                localeName = localeName + "_" + country;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return localeName;
    }

    protected String attemptToLoadResource(String localeName) throws IOException {
        return ResourceLoader.getContent((String)("features/i18n/data/DateTimeConstants__" + localeName + ".js"));
    }
}

