/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetFeature;
import org.apache.shindig.gadgets.JsFeatureLoader;
import org.apache.shindig.gadgets.http.HttpFetcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class GadgetFeatureRegistry {
    private final Map<String, GadgetFeature> features;
    private final Map<String, GadgetFeature> core;
    private final Map<Collection<String>, Collection<GadgetFeature>> cache = Maps.newConcurrentHashMap();
    private boolean graphComplete = false;
    private static final Logger logger = Logger.getLogger("org.apache.shindig.gadgets");

    @Inject
    public GadgetFeatureRegistry(@Named(value="shindig.features.default") String featureFiles, HttpFetcher httpFetcher) throws GadgetException {
        this.features = new HashMap<String, GadgetFeature>();
        this.core = new HashMap<String, GadgetFeature>();
        if (featureFiles != null) {
            JsFeatureLoader loader = new JsFeatureLoader(httpFetcher);
            loader.loadFeatures(featureFiles, this);
        }
    }

    public void register(GadgetFeature feature) {
        if (this.graphComplete) {
            throw new IllegalStateException("register should never be invoked after calling getLibraries");
        }
        logger.info("Registering feature: " + feature.getName());
        if (this.isCore(feature)) {
            this.core.put(feature.getName(), feature);
            for (GadgetFeature feat : this.features.values()) {
                feat.addDependency(feature.getName());
            }
        } else {
            feature.addDependencies(this.core.keySet());
        }
        this.features.put(feature.getName(), feature);
    }

    private boolean isCore(GadgetFeature feature) {
        return feature.getName().startsWith("core");
    }

    public Collection<GadgetFeature> getAllFeatures() {
        return Collections.unmodifiableCollection(this.features.values());
    }

    public Collection<GadgetFeature> getFeatures(Collection<String> needed) {
        return this.getFeatures(needed, null);
    }

    public Collection<GadgetFeature> getFeatures(Collection<String> needed, Collection<String> unsupported) {
        Collection<GadgetFeature> libCache;
        this.graphComplete = true;
        if (needed.isEmpty()) {
            needed = this.core.keySet();
        }
        if ((libCache = this.cache.get(needed)) != null) {
            return libCache;
        }
        LinkedList<GadgetFeature> ret = new LinkedList<GadgetFeature>();
        this.populateDependencies(needed, ret);
        if (unsupported != null) {
            for (String feature : needed) {
                if (this.features.containsKey(feature)) continue;
                unsupported.add(feature);
            }
        }
        if (unsupported == null || unsupported.isEmpty()) {
            this.cache.put(needed, Collections.unmodifiableList(ret));
        }
        return ret;
    }

    private void populateDependencies(Collection<String> needed, List<GadgetFeature> deps) {
        for (String feature : needed) {
            GadgetFeature feat = this.features.get(feature);
            if (feat == null || deps.contains(feat)) continue;
            this.populateDependencies(feat.getDependencies(), deps);
            deps.add(feat);
        }
    }
}

