/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.nekohtml.NekoSimplifiedHtmlParser;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;

public class ParseModule
extends AbstractModule {
    protected void configure() {
        this.bind(GadgetHtmlParser.class).to(NekoSimplifiedHtmlParser.class);
        this.bind(DOMImplementation.class).toProvider(DOMImplementationProvider.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DOMImplementationProvider
    implements Provider<DOMImplementation> {
        DOMImplementation domImpl;

        public DOMImplementationProvider() {
            try {
                DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
                this.domImpl = registry.getDOMImplementation("XML 1.0 Traversal 2.0");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.domImpl == null) {
                    this.domImpl = (DOMImplementation)Class.forName("org.apache.xerces.internal.dom.DOMImplementationImpl").getMethod("getDOMImplementation", new Class[0]).invoke(null, new Object[0]);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                if (this.domImpl == null) {
                    this.domImpl = (DOMImplementation)Class.forName("com.sun.org.apache.xerces.internal.dom.DOMImplementationImpl").getMethod("getDOMImplementation", new Class[0]).invoke(null, new Object[0]);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not find HTML DOM implementation", ex);
            }
        }

        public DOMImplementation get() {
            return this.domImpl;
        }
    }
}

