/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.util.xstream;

import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shindig.social.core.util.xstream.InterfaceFieldAliasMapping;
import org.apache.shindig.social.core.util.xstream.WriterStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceFieldAliasingMapper
extends MapperWrapper {
    private Map<String, List<InterfaceFieldAliasMapping>> serializedMap = new HashMap<String, List<InterfaceFieldAliasMapping>>();
    private Map<String, List<InterfaceFieldAliasMapping>> membersMap = new HashMap<String, List<InterfaceFieldAliasMapping>>();
    private WriterStack writerStack;

    public InterfaceFieldAliasingMapper(Mapper wrapped, WriterStack writerStack, List<InterfaceFieldAliasMapping> ifaList) {
        super(wrapped);
        this.writerStack = writerStack;
        for (InterfaceFieldAliasMapping ifa : ifaList) {
            List<InterfaceFieldAliasMapping> serializedMatches = this.serializedMap.get(ifa.getFieldName());
            if (serializedMatches == null) {
                serializedMatches = new ArrayList<InterfaceFieldAliasMapping>();
                this.serializedMap.put(ifa.getFieldName(), serializedMatches);
            }
            serializedMatches.add(ifa);
            List<InterfaceFieldAliasMapping> memberMatches = this.membersMap.get(ifa.getAlias());
            if (memberMatches == null) {
                memberMatches = new ArrayList<InterfaceFieldAliasMapping>();
                this.membersMap.put(ifa.getAlias(), memberMatches);
            }
            memberMatches.add(ifa);
        }
    }

    public String realMember(Class type, String serialized) {
        List<InterfaceFieldAliasMapping> serializedMatches = this.membersMap.get(serialized);
        if (serializedMatches != null) {
            for (InterfaceFieldAliasMapping ifa : serializedMatches) {
                if (!ifa.getType().isAssignableFrom(type)) continue;
                return ifa.getFieldName();
            }
        }
        return super.realMember(type, serialized);
    }

    public String serializedMember(Class type, String memberName) {
        List<InterfaceFieldAliasMapping> memberMatches = this.serializedMap.get(memberName);
        if (memberMatches != null) {
            for (InterfaceFieldAliasMapping ifa : memberMatches) {
                if (!(ifa.getParent() == null ? ifa.getType().isAssignableFrom(type) : ifa.getType().isAssignableFrom(type) && ifa.getParent().equals(this.writerStack.peek()))) continue;
                return ifa.getAlias();
            }
        }
        return super.serializedMember(type, memberName);
    }
}

