/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.dataservice.integration;

import com.google.common.collect.Maps;
import java.util.HashMap;
import org.apache.shindig.social.dataservice.integration.AbstractLargeRestfulTests;
import org.json.JSONObject;
import org.junit.Test;

public class RestfulJsonDataTest
extends AbstractLargeRestfulTests {
    @Test
    public void testGetFriendsAppDataJson() throws Exception {
        HashMap extraParams = Maps.newHashMap();
        extraParams.put("fields", "count");
        String resp = this.getResponse("/appdata/john.doe/@friends/app", "GET", extraParams, null, "application/json");
        JSONObject data = this.getJson(resp).getJSONObject("entry");
        RestfulJsonDataTest.assertEquals((int)3, (int)data.length());
        JSONObject janesEntries = data.getJSONObject("jane.doe");
        RestfulJsonDataTest.assertEquals((int)1, (int)janesEntries.length());
        RestfulJsonDataTest.assertEquals((String)"7", (String)janesEntries.getString("count"));
        JSONObject georgesEntries = data.getJSONObject("george.doe");
        RestfulJsonDataTest.assertEquals((int)1, (int)georgesEntries.length());
        RestfulJsonDataTest.assertEquals((String)"2", (String)georgesEntries.getString("count"));
    }

    @Test
    public void testGetSelfAppDataJson() throws Exception {
        HashMap extraParams = Maps.newHashMap();
        extraParams.put("fields", null);
        String resp = this.getResponse("/appdata/john.doe/@self/app", "GET", extraParams, null, "application/json");
        JSONObject data = this.getJson(resp).getJSONObject("entry");
        RestfulJsonDataTest.assertEquals((int)1, (int)data.length());
        JSONObject johnsEntries = data.getJSONObject("john.doe");
        RestfulJsonDataTest.assertEquals((int)1, (int)johnsEntries.length());
        RestfulJsonDataTest.assertEquals((String)"0", (String)johnsEntries.getString("count"));
    }

    @Test
    public void testGetSelfAppDataJsonWithKey() throws Exception {
        HashMap extraParams = Maps.newHashMap();
        extraParams.put("fields", "count");
        String resp = this.getResponse("/appdata/john.doe/@self/app", "GET", extraParams, null, "application/json");
        JSONObject data = this.getJson(resp).getJSONObject("entry");
        RestfulJsonDataTest.assertEquals((int)1, (int)data.length());
        JSONObject johnsEntries = data.getJSONObject("john.doe");
        RestfulJsonDataTest.assertEquals((int)1, (int)johnsEntries.length());
        RestfulJsonDataTest.assertEquals((String)"0", (String)johnsEntries.getString("count"));
    }

    @Test
    public void testGetSelfAppDataJsonWithInvalidKeys() throws Exception {
        HashMap extraParams = Maps.newHashMap();
        extraParams.put("fields", "peabody");
        String resp = this.getResponse("/appdata/john.doe/@self/app", "GET", extraParams, null, "application/json");
        JSONObject data = this.getJson(resp).getJSONObject("entry");
        RestfulJsonDataTest.assertEquals((int)1, (int)data.length());
        JSONObject johnsEntries = data.getJSONObject("john.doe");
        RestfulJsonDataTest.assertEquals((int)0, (int)johnsEntries.length());
    }

    @Test
    public void testDeleteAppData() throws Exception {
        this.assertCount("0");
        HashMap extraParams = Maps.newHashMap();
        extraParams.put("fields", "peabody");
        this.getResponse("/appdata/john.doe/@self/app", "DELETE", extraParams, null, "application/json");
        this.assertCount("0");
        extraParams.put("fields", "count");
        this.getResponse("/appdata/john.doe/@self/app", "DELETE", extraParams, null, "application/json");
        this.assertCount(null);
    }

    @Test
    public void testUpdateAppData() throws Exception {
        this.assertCount("0");
        HashMap extraParams = Maps.newHashMap();
        extraParams.put("fields", "count");
        String postData = "{count : 5}";
        this.getResponse("/appdata/john.doe/@self/app", "POST", extraParams, postData, null, "application/json");
        this.assertCount("5");
    }

    private void assertCount(String expectedCount) throws Exception {
        String resp = this.getResponse("/appdata/john.doe/@self/app", "GET", null, "application/json");
        JSONObject data = this.getJson(resp).getJSONObject("entry");
        RestfulJsonDataTest.assertEquals((int)1, (int)data.length());
        JSONObject johnsEntries = data.getJSONObject("john.doe");
        if (expectedCount != null) {
            RestfulJsonDataTest.assertEquals((int)1, (int)johnsEntries.length());
            RestfulJsonDataTest.assertEquals((String)expectedCount, (String)johnsEntries.getString("count"));
        } else {
            RestfulJsonDataTest.assertEquals((int)0, (int)johnsEntries.length());
        }
    }
}

