/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.dataservice.integration;

import com.google.common.collect.Maps;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.shindig.social.dataservice.integration.AbstractLargeRestfulTests;
import org.apache.shindig.social.opensocial.util.XSDValidator;
import org.junit.Test;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class RestfulXmlDataTest
extends AbstractLargeRestfulTests {
    private XPathFactory xpathFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.xpathFactory = XPathFactory.newInstance();
    }

    @Test
    public void testGetFriendsAppDataJson() throws Exception {
        HashMap extraParams = Maps.newHashMap();
        extraParams.put("fields", "count");
        String resp = this.getResponse("/appdata/john.doe/@friends/app", "GET", extraParams, "xml", "application/xml");
        XSDValidator.validate(resp, " xmlns=\"http://ns.opensocial.org/2008/opensocial\" \n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n xsi:schemaLocation=\"http://ns.opensocial.org/2008/opensocial classpath:opensocial.xsd\" ", "opensocial.xsd", false);
        XPath xp = this.xpathFactory.newXPath();
        NodeList result = (NodeList)xp.evaluate("/appdata/entry", new InputSource(new StringReader(resp)), XPathConstants.NODESET);
        RestfulXmlDataTest.assertEquals((int)3, (int)result.getLength());
        Map<String, Map<String, List<String>>> v = this.childNodesToMapofMap(result);
        RestfulXmlDataTest.assertEquals((int)3, (int)v.size());
        RestfulXmlDataTest.assertTrue((boolean)v.containsKey("jane.doe"));
        RestfulXmlDataTest.assertTrue((boolean)v.containsKey("george.doe"));
        RestfulXmlDataTest.assertTrue((boolean)v.containsKey("maija.m"));
        RestfulXmlDataTest.assertEquals((int)1, (int)v.get("jane.doe").size());
        RestfulXmlDataTest.assertEquals((int)1, (int)v.get("george.doe").size());
        RestfulXmlDataTest.assertEquals((int)0, (int)v.get("maija.m").size());
        RestfulXmlDataTest.assertEquals((String)"7", (String)v.get("jane.doe").get("count").get(0));
        RestfulXmlDataTest.assertEquals((String)"2", (String)v.get("george.doe").get("count").get(0));
    }

    @Test
    public void testGetSelfAppDataJson() throws Exception {
        HashMap extraParams = Maps.newHashMap();
        extraParams.put("fields", null);
        String resp = this.getResponse("/appdata/john.doe/@self/app", "GET", extraParams, "xml", "application/xml");
        XSDValidator.validate(resp, " xmlns=\"http://ns.opensocial.org/2008/opensocial\" \n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n xsi:schemaLocation=\"http://ns.opensocial.org/2008/opensocial classpath:opensocial.xsd\" ", "opensocial.xsd", false);
        XPath xp = this.xpathFactory.newXPath();
        NodeList result = (NodeList)xp.evaluate("/appdata/entry", new InputSource(new StringReader(resp)), XPathConstants.NODESET);
        Map<String, Map<String, List<String>>> v = this.childNodesToMapofMap(result);
        RestfulXmlDataTest.assertEquals((int)1, (int)v.size());
        RestfulXmlDataTest.assertTrue((boolean)v.containsKey("john.doe"));
        RestfulXmlDataTest.assertEquals((int)1, (int)v.get("john.doe").size());
        RestfulXmlDataTest.assertEquals((String)"0", (String)v.get("john.doe").get("count").get(0));
    }

    @Test
    public void testGetSelfAppDataJsonWithKey() throws Exception {
        HashMap extraParams = Maps.newHashMap();
        extraParams.put("fields", "count");
        String resp = this.getResponse("/appdata/john.doe/@self/app", "GET", extraParams, "xml", "application/xml");
        XSDValidator.validate(resp, " xmlns=\"http://ns.opensocial.org/2008/opensocial\" \n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n xsi:schemaLocation=\"http://ns.opensocial.org/2008/opensocial classpath:opensocial.xsd\" ", "opensocial.xsd", false);
        XPath xp = this.xpathFactory.newXPath();
        NodeList result = (NodeList)xp.evaluate("/appdata/entry", new InputSource(new StringReader(resp)), XPathConstants.NODESET);
        Map<String, Map<String, List<String>>> v = this.childNodesToMapofMap(result);
        RestfulXmlDataTest.assertEquals((int)1, (int)v.size());
        RestfulXmlDataTest.assertTrue((boolean)v.containsKey("john.doe"));
        RestfulXmlDataTest.assertEquals((int)1, (int)v.get("john.doe").size());
        RestfulXmlDataTest.assertEquals((String)"0", (String)v.get("john.doe").get("count").get(0));
    }

    @Test
    public void testGetSelfAppDataJsonWithInvalidKeys() throws Exception {
        HashMap extraParams = Maps.newHashMap();
        extraParams.put("fields", "peabody");
        String resp = this.getResponse("/appdata/john.doe/@self/app", "GET", extraParams, "xml", "application/xml");
        XSDValidator.validate(resp, " xmlns=\"http://ns.opensocial.org/2008/opensocial\" \n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n xsi:schemaLocation=\"http://ns.opensocial.org/2008/opensocial classpath:opensocial.xsd\" ", "opensocial.xsd", false);
        XPath xp = this.xpathFactory.newXPath();
        NodeList result = (NodeList)xp.evaluate("/appdata/entry", new InputSource(new StringReader(resp)), XPathConstants.NODESET);
        Map<String, Map<String, List<String>>> v = this.childNodesToMapofMap(result);
        RestfulXmlDataTest.assertEquals((int)1, (int)v.size());
        RestfulXmlDataTest.assertTrue((boolean)v.containsKey("john.doe"));
        RestfulXmlDataTest.assertEquals((int)0, (int)v.get("john.doe").size());
    }

    @Test
    public void testDeleteAppData() throws Exception {
        this.assertCount("0");
        HashMap extraParams = Maps.newHashMap();
        extraParams.put("fields", "peabody");
        String resp = this.getResponse("/appdata/john.doe/@self/app", "DELETE", extraParams, "xml", "application/xml");
        XSDValidator.validate(resp, " xmlns=\"http://ns.opensocial.org/2008/opensocial\" \n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n xsi:schemaLocation=\"http://ns.opensocial.org/2008/opensocial classpath:opensocial.xsd\" ", "opensocial.xsd", false);
        this.assertCount("0");
        extraParams.put("fields", "count");
        this.getResponse("/appdata/john.doe/@self/app", "DELETE", extraParams, "xml", "application/xml");
        XSDValidator.validate(resp, " xmlns=\"http://ns.opensocial.org/2008/opensocial\" \n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n xsi:schemaLocation=\"http://ns.opensocial.org/2008/opensocial classpath:opensocial.xsd\" ", "opensocial.xsd", false);
        this.assertCount(null);
    }

    @Test
    public void testUpdateAppData() throws Exception {
        this.assertCount("0");
        HashMap extraParams = Maps.newHashMap();
        extraParams.put("fields", "count");
        String postData = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<map><entry><key>count</key><value>5</value></entry></map>";
        String resp = this.getResponse("/appdata/john.doe/@self/app", "POST", extraParams, postData, "xml", "application/xml");
        XSDValidator.validate(resp, " xmlns=\"http://ns.opensocial.org/2008/opensocial\" \n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n xsi:schemaLocation=\"http://ns.opensocial.org/2008/opensocial classpath:opensocial.xsd\" ", "opensocial.xsd", false);
        this.assertCount("5");
    }

    private void assertCount(String expectedCount) throws Exception {
        String resp = this.getResponse("/appdata/john.doe/@self/app", "GET", "xml", "application/xml");
        XSDValidator.validate(resp, " xmlns=\"http://ns.opensocial.org/2008/opensocial\" \n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n xsi:schemaLocation=\"http://ns.opensocial.org/2008/opensocial classpath:opensocial.xsd\" ", "opensocial.xsd", false);
        XPath xp = this.xpathFactory.newXPath();
        NodeList result = (NodeList)xp.evaluate("/appdata/entry", new InputSource(new StringReader(resp)), XPathConstants.NODESET);
        Map<String, Map<String, List<String>>> v = this.childNodesToMapofMap(result);
        RestfulXmlDataTest.assertEquals((int)1, (int)v.size());
        RestfulXmlDataTest.assertTrue((boolean)v.containsKey("john.doe"));
        if (expectedCount != null) {
            RestfulXmlDataTest.assertEquals((int)1, (int)v.get("john.doe").size());
            RestfulXmlDataTest.assertEquals((String)String.valueOf(expectedCount), (String)v.get("john.doe").get("count").get(0));
        } else {
            RestfulXmlDataTest.assertEquals((int)0, (int)v.get("john.doe").size());
        }
    }
}

