/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.social.EasyMockTestCase;
import org.apache.shindig.social.core.model.ActivityImpl;
import org.apache.shindig.social.core.util.BeanJsonConverter;
import org.apache.shindig.social.core.util.ContainerConf;
import org.apache.shindig.social.core.util.JsonContainerConf;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.service.ActivityHandler;
import org.apache.shindig.social.opensocial.service.BeanConverter;
import org.apache.shindig.social.opensocial.service.RequestItem;
import org.apache.shindig.social.opensocial.service.RestfulRequestItem;
import org.apache.shindig.social.opensocial.spi.ActivityService;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.RestfulCollection;
import org.apache.shindig.social.opensocial.spi.SocialSpiException;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.easymock.classextension.EasyMock;

public class ActivityHandlerTest
extends EasyMockTestCase {
    private BeanJsonConverter converter;
    private ActivityService activityService;
    private ActivityHandler handler;
    private FakeGadgetToken token;
    private RestfulRequestItem request;
    private static final Set<UserId> JOHN_DOE = Sets.newHashSet((Object[])new UserId[]{new UserId(UserId.Type.userId, "john.doe")});

    protected void setUp() throws Exception {
        this.token = new FakeGadgetToken();
        this.token.setAppId("appId");
        this.converter = (BeanJsonConverter)EasyMock.createMock(BeanJsonConverter.class);
        this.activityService = (ActivityService)EasyMock.createMock(ActivityService.class);
        JsonContainerConf containerConf = new JsonContainerConf();
        this.handler = new ActivityHandler(this.activityService, (ContainerConf)containerConf);
    }

    protected void replay() {
        EasyMock.replay((Object[])new Object[]{this.converter});
        EasyMock.replay((Object[])new Object[]{this.activityService});
    }

    protected void verify() {
        EasyMock.verify((Object[])new Object[]{this.converter});
        EasyMock.verify((Object[])new Object[]{this.activityService});
    }

    private void setPath(String path) {
        this.setPathAndPostData(path, null);
    }

    private void setPathAndPostData(String path, String postData) {
        this.request = new RestfulRequestItem(path, "GET", postData, (SecurityToken)this.token, (BeanConverter)this.converter);
    }

    private void assertHandleGetForGroup(GroupId.Type group) throws Exception {
        this.setPath("/activities/john.doe/@" + group.toString());
        ImmutableList activityList = ImmutableList.of();
        RestfulCollection data = new RestfulCollection((List)activityList);
        EasyMock.expect((Object)this.activityService.getActivities(JOHN_DOE, new GroupId(group, null), null, (Set)Sets.newHashSet(), (SecurityToken)this.token)).andReturn((Object)ImmediateFuture.newInstance((Object)data));
        this.replay();
        ActivityHandlerTest.assertEquals((Object)data, this.handler.handleGet((RequestItem)this.request).get());
        this.verify();
    }

    public void testHandleGetAll() throws Exception {
        this.assertHandleGetForGroup(GroupId.Type.all);
    }

    public void testHandleGetFriends() throws Exception {
        this.assertHandleGetForGroup(GroupId.Type.friends);
    }

    public void testHandleGetSelf() throws Exception {
        this.assertHandleGetForGroup(GroupId.Type.self);
    }

    public void testHandleGetPlural() throws Exception {
        this.setPath("/activities/john.doe,jane.doe/@self/@app");
        ImmutableList activities = ImmutableList.of();
        RestfulCollection data = new RestfulCollection((List)activities);
        LinkedHashSet userIdSet = Sets.newLinkedHashSet(JOHN_DOE);
        userIdSet.add(new UserId(UserId.Type.userId, "jane.doe"));
        EasyMock.expect((Object)this.activityService.getActivities((Set)userIdSet, new GroupId(GroupId.Type.self, null), "appId", (Set)Sets.newHashSet(), (SecurityToken)this.token)).andReturn((Object)ImmediateFuture.newInstance((Object)data));
        this.replay();
        ActivityHandlerTest.assertEquals((Object)data, this.handler.handleGet((RequestItem)this.request).get());
        this.verify();
    }

    public void testHandleGetActivityById() throws Exception {
        this.setPath("/people/john.doe/@friends/@app/1");
        ActivityImpl activity = new ActivityImpl();
        EasyMock.expect((Object)this.activityService.getActivity(JOHN_DOE.iterator().next(), new GroupId(GroupId.Type.friends, null), "appId", (Set)Sets.newHashSet(), "1", (SecurityToken)this.token)).andReturn((Object)ImmediateFuture.newInstance((Object)activity));
        this.replay();
        ActivityHandlerTest.assertEquals((Object)activity, this.handler.handleGet((RequestItem)this.request).get());
        this.verify();
    }

    private void setupPostData() throws SocialSpiException {
        String jsonActivity = "{title: hi mom!, etc etc}";
        this.setPathAndPostData("/people/john.doe/@self/@app", jsonActivity);
        ActivityImpl activity = new ActivityImpl();
        EasyMock.expect((Object)this.converter.convertToObject(jsonActivity, Activity.class)).andReturn((Object)activity);
        EasyMock.expect((Object)this.activityService.createActivity(JOHN_DOE.iterator().next(), new GroupId(GroupId.Type.self, null), "appId", (Set)Sets.newHashSet(), (Activity)activity, (SecurityToken)this.token)).andReturn((Object)ImmediateFuture.newInstance((Object)null));
        this.replay();
    }

    public void testHandlePost() throws Exception {
        this.setupPostData();
        ActivityHandlerTest.assertNull(this.handler.handlePost((RequestItem)this.request).get());
        this.verify();
    }

    public void testHandlePut() throws Exception {
        this.setupPostData();
        ActivityHandlerTest.assertNull(this.handler.handlePut((RequestItem)this.request).get());
        this.verify();
    }

    public void testHandleDelete() throws Exception {
        this.setPath("/people/john.doe/@self/@app/1");
        EasyMock.expect((Object)this.activityService.deleteActivities(JOHN_DOE.iterator().next(), new GroupId(GroupId.Type.self, null), "appId", (Set)Sets.newHashSet((Object[])new String[]{"1"}), (SecurityToken)this.token)).andReturn((Object)ImmediateFuture.newInstance((Object)null));
        this.replay();
        ActivityHandlerTest.assertNull(this.handler.handleDelete((RequestItem)this.request).get());
        this.verify();
    }
}

