/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.common.testing.FakeHttpServletRequest;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.social.EasyMockTestCase;
import org.apache.shindig.social.ResponseError;
import org.apache.shindig.social.SocialApiTestsGuiceModule;
import org.apache.shindig.social.core.util.BeanJsonConverter;
import org.apache.shindig.social.core.util.BeanXStreamAtomConverter;
import org.apache.shindig.social.core.util.BeanXStreamConverter;
import org.apache.shindig.social.core.util.xstream.XStream081Configuration;
import org.apache.shindig.social.core.util.xstream.XStreamConfiguration;
import org.apache.shindig.social.opensocial.service.ActivityHandler;
import org.apache.shindig.social.opensocial.service.AppDataHandler;
import org.apache.shindig.social.opensocial.service.BeanConverter;
import org.apache.shindig.social.opensocial.service.DataRequestHandler;
import org.apache.shindig.social.opensocial.service.DataServiceServlet;
import org.apache.shindig.social.opensocial.service.HandlerDispatcher;
import org.apache.shindig.social.opensocial.service.PersonHandler;
import org.apache.shindig.social.opensocial.service.RequestItem;
import org.apache.shindig.social.opensocial.service.RestfulRequestItem;
import org.apache.shindig.social.opensocial.service.StandardHandlerDispatcher;
import org.apache.shindig.social.opensocial.spi.SocialSpiException;
import org.easymock.classextension.EasyMock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataServiceServletTest
extends EasyMockTestCase {
    private static final FakeGadgetToken FAKE_GADGET_TOKEN = new FakeGadgetToken().setOwnerId("john.doe").setViewerId("john.doe");
    private HttpServletRequest req;
    private HttpServletResponse res;
    private DataServiceServlet servlet;
    private PersonHandler peopleHandler;
    private ActivityHandler activityHandler;
    private AppDataHandler appDataHandler;
    private BeanJsonConverter jsonConverter;
    private final ServletInputStream dummyPostData = new ServletInputStream(){

        public int read() {
            return -1;
        }
    };

    protected void setUp() throws Exception {
        this.servlet = new DataServiceServlet();
        this.req = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
        this.res = (HttpServletResponse)EasyMock.createMock(HttpServletResponse.class);
        this.jsonConverter = (BeanJsonConverter)EasyMock.createMock(BeanJsonConverter.class);
        BeanXStreamConverter xmlConverter = (BeanXStreamConverter)EasyMock.createMock(BeanXStreamConverter.class);
        BeanXStreamAtomConverter atomConverter = (BeanXStreamAtomConverter)EasyMock.createMock(BeanXStreamAtomConverter.class);
        this.peopleHandler = (PersonHandler)EasyMock.createMock(PersonHandler.class);
        this.activityHandler = (ActivityHandler)EasyMock.createMock(ActivityHandler.class);
        this.appDataHandler = (AppDataHandler)EasyMock.createMock(AppDataHandler.class);
        EasyMock.expect((Object)this.jsonConverter.getContentType()).andReturn((Object)"application/json");
        EasyMock.expect((Object)xmlConverter.getContentType()).andReturn((Object)"application/xml");
        EasyMock.expect((Object)atomConverter.getContentType()).andReturn((Object)"application/atom+xml");
        StandardHandlerDispatcher dispatcher = new StandardHandlerDispatcher(DataServiceServletTest.constant(this.peopleHandler), DataServiceServletTest.constant(this.activityHandler), DataServiceServletTest.constant(this.appDataHandler));
        this.servlet.setHandlerDispatcher((HandlerDispatcher)dispatcher);
        this.servlet.setBeanConverters((BeanConverter)this.jsonConverter, (BeanConverter)xmlConverter, (BeanConverter)atomConverter);
    }

    private static <T> Provider<T> constant(final T value) {
        return new Provider<T>(){

            public T get() {
                return value;
            }
        };
    }

    public void testPeopleUriRecognition() throws Exception {
        this.verifyHandlerWasFoundForPathInfo("/people/5/@self", (DataRequestHandler)this.peopleHandler);
    }

    public void testActivitiesUriRecognition() throws Exception {
        this.verifyHandlerWasFoundForPathInfo("/activities/5/@self", (DataRequestHandler)this.activityHandler);
    }

    public void testAppDataUriRecognition() throws Exception {
        this.verifyHandlerWasFoundForPathInfo("/appdata/5/@self", (DataRequestHandler)this.appDataHandler);
    }

    public void testMethodOverride() throws Exception {
        String route = "/appdata";
        this.verifyHandlerWasFoundForPathInfo(route, (DataRequestHandler)this.appDataHandler, "POST", "GET", "GET");
        this.verifyHandlerWasFoundForPathInfo(route, (DataRequestHandler)this.appDataHandler, "POST", "", "POST");
        this.verifyHandlerWasFoundForPathInfo(route, (DataRequestHandler)this.appDataHandler, "POST", null, "POST");
        this.verifyHandlerWasFoundForPathInfo(route, (DataRequestHandler)this.appDataHandler, "POST", "POST", "POST");
        this.verifyHandlerWasFoundForPathInfo(route, (DataRequestHandler)this.appDataHandler, "GET", null, "GET");
        this.verifyHandlerWasFoundForPathInfo(route, (DataRequestHandler)this.appDataHandler, "DELETE", null, "DELETE");
        this.verifyHandlerWasFoundForPathInfo(route, (DataRequestHandler)this.appDataHandler, "PUT", null, "PUT");
    }

    public void testFailedRequest() throws Exception {
        String route = "/appdata";
        this.setupRequest(route, "GET", null);
        EasyMock.expect((Object)this.appDataHandler.handleItem((RequestItem)EasyMock.isA(RestfulRequestItem.class)));
        EasyMock.expectLastCall().andReturn((Object)ImmediateFuture.errorInstance((Throwable)new RuntimeException("FAILED")));
        this.res.sendError(500, "FAILED");
        this.res.setCharacterEncoding("UTF-8");
        this.res.setContentType("application/json");
        EasyMock.replay((Object[])new Object[]{this.req, this.res, this.appDataHandler, this.jsonConverter});
        this.servlet.service((ServletRequest)this.req, (ServletResponse)this.res);
        EasyMock.verify((Object[])new Object[]{this.req, this.res, this.appDataHandler, this.jsonConverter});
        EasyMock.reset((Object[])new Object[]{this.req, this.res, this.appDataHandler, this.jsonConverter});
    }

    private void verifyHandlerWasFoundForPathInfo(String peoplePathInfo, DataRequestHandler handler) throws Exception {
        String post = "POST";
        this.verifyHandlerWasFoundForPathInfo(peoplePathInfo, handler, post, post, post);
    }

    private void verifyHandlerWasFoundForPathInfo(String pathInfo, DataRequestHandler handler, String actualMethod, String overrideMethod, String expectedMethod) throws Exception {
        this.setupRequest(pathInfo, actualMethod, overrideMethod);
        String jsonObject = "my lovely json";
        EasyMock.expect((Object)handler.handleItem((RequestItem)EasyMock.isA(RequestItem.class)));
        EasyMock.expectLastCall().andReturn((Object)ImmediateFuture.newInstance((Object)jsonObject));
        EasyMock.expect((Object)this.jsonConverter.convertToString((Object)ImmutableMap.of((Object)"entry", (Object)jsonObject))).andReturn((Object)("{ 'entry' : " + jsonObject + " }"));
        PrintWriter writerMock = (PrintWriter)EasyMock.createMock(PrintWriter.class);
        EasyMock.expect((Object)this.res.getWriter()).andReturn((Object)writerMock);
        writerMock.write(jsonObject);
        this.res.setCharacterEncoding("UTF-8");
        this.res.setContentType("application/json");
        EasyMock.replay((Object[])new Object[]{this.req, this.res, handler, this.jsonConverter});
        this.servlet.service((ServletRequest)this.req, (ServletResponse)this.res);
        EasyMock.verify((Object[])new Object[]{this.req, this.res, handler, this.jsonConverter});
        EasyMock.reset((Object[])new Object[]{this.req, this.res, handler, this.jsonConverter});
        EasyMock.expect((Object)this.jsonConverter.getContentType()).andReturn((Object)"application/json");
    }

    private void setupRequest(String pathInfo, String actualMethod, String overrideMethod) throws IOException {
        EasyMock.expect((Object)this.req.getCharacterEncoding()).andStubReturn((Object)"UTF-8");
        if (!"GET".equals(overrideMethod) && !"HEAD".equals(overrideMethod)) {
            EasyMock.expect((Object)this.req.getInputStream()).andStubReturn((Object)this.dummyPostData);
        }
        EasyMock.expect((Object)this.req.getPathInfo()).andStubReturn((Object)pathInfo);
        EasyMock.expect((Object)this.req.getMethod()).andStubReturn((Object)actualMethod);
        EasyMock.expect((Object)this.req.getParameterNames()).andStubReturn((Object)new StringTokenizer(""));
        EasyMock.expect((Object)this.req.getParameter("X-HTTP-Method-Override")).andReturn((Object)overrideMethod).times(2);
        EasyMock.expect((Object)this.req.getParameter("format")).andReturn(null);
        EasyMock.expect((Object)this.req.getAttribute((String)EasyMock.isA(String.class))).andReturn((Object)FAKE_GADGET_TOKEN);
    }

    public void testInvalidRoute() throws Exception {
        RestfulRequestItem requestItem = new RestfulRequestItem("/ahhh!", "GET", null, (SecurityToken)FAKE_GADGET_TOKEN, (BeanConverter)this.jsonConverter);
        try {
            this.servlet.handleRequestItem((RequestItem)requestItem, (HttpServletRequest)new FakeHttpServletRequest()).get();
            DataServiceServletTest.fail();
        }
        catch (ExecutionException ee) {
            DataServiceServletTest.assertTrue((boolean)(ee.getCause() instanceof SocialSpiException));
            DataServiceServletTest.assertEquals((Object)ResponseError.NOT_IMPLEMENTED, (Object)((SocialSpiException)ee.getCause()).getError());
        }
    }

    public void testGetConverterForRequest() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new SocialApiTestsGuiceModule()});
        BeanJsonConverter json = new BeanJsonConverter(injector);
        BeanXStreamConverter xml = new BeanXStreamConverter((XStreamConfiguration)new XStream081Configuration(injector));
        BeanXStreamAtomConverter atom = new BeanXStreamAtomConverter((XStreamConfiguration)new XStream081Configuration(injector));
        this.servlet.setBeanConverters((BeanConverter)json, (BeanConverter)xml, (BeanConverter)atom);
        this.assertConverter((BeanConverter)atom, "atom");
        this.assertConverter((BeanConverter)xml, "xml");
        this.assertConverter((BeanConverter)json, "");
        this.assertConverter((BeanConverter)json, null);
        this.assertConverter((BeanConverter)json, "ahhhh!");
    }

    public void testGetConverterForRequestContentType() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new SocialApiTestsGuiceModule()});
        BeanJsonConverter json = new BeanJsonConverter(injector);
        BeanXStreamConverter xml = new BeanXStreamConverter((XStreamConfiguration)new XStream081Configuration(injector));
        BeanXStreamAtomConverter atom = new BeanXStreamAtomConverter((XStreamConfiguration)new XStream081Configuration(injector));
        this.servlet.setBeanConverters((BeanConverter)json, (BeanConverter)xml, (BeanConverter)atom);
        this.assertConverterForContentType((BeanConverter)atom, "application/atom+xml");
        this.assertConverterForContentType((BeanConverter)xml, "application/xml");
        this.assertConverterForContentType((BeanConverter)json, "");
        this.assertConverterForContentType((BeanConverter)json, null);
        this.assertConverterForContentType((BeanConverter)json, "abcd!");
    }

    private void assertConverter(BeanConverter converter, String format) {
        EasyMock.expect((Object)this.req.getParameter("format")).andReturn((Object)format);
        EasyMock.replay((Object[])new Object[]{this.req});
        DataServiceServletTest.assertEquals((Object)converter, (Object)this.servlet.getConverterForRequest(this.req));
        EasyMock.verify((Object[])new Object[]{this.req});
        EasyMock.reset((Object[])new Object[]{this.req});
    }

    private void assertConverterForContentType(BeanConverter converter, String contentType) {
        EasyMock.expect((Object)this.req.getHeader("CONTENT_TYPE")).andReturn((Object)contentType);
        EasyMock.replay((Object[])new Object[]{this.req});
        DataServiceServletTest.assertEquals((Object)converter, (Object)this.servlet.getConverterForRequest(this.req));
        EasyMock.verify((Object[])new Object[]{this.req});
        EasyMock.reset((Object[])new Object[]{this.req});
    }
}

