/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Provider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.concurrent.Future;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.social.EasyMockTestCase;
import org.apache.shindig.social.core.util.BeanJsonConverter;
import org.apache.shindig.social.core.util.BeanXStreamAtomConverter;
import org.apache.shindig.social.core.util.BeanXStreamConverter;
import org.apache.shindig.social.opensocial.service.ActivityHandler;
import org.apache.shindig.social.opensocial.service.AppDataHandler;
import org.apache.shindig.social.opensocial.service.BeanConverter;
import org.apache.shindig.social.opensocial.service.DataRequestHandler;
import org.apache.shindig.social.opensocial.service.HandlerDispatcher;
import org.apache.shindig.social.opensocial.service.JsonRpcServlet;
import org.apache.shindig.social.opensocial.service.PersonHandler;
import org.apache.shindig.social.opensocial.service.RequestItem;
import org.apache.shindig.social.opensocial.service.RpcRequestItem;
import org.apache.shindig.social.opensocial.service.StandardHandlerDispatcher;
import org.easymock.classextension.EasyMock;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonRpcServletTest
extends EasyMockTestCase {
    private static final FakeGadgetToken FAKE_GADGET_TOKEN = new FakeGadgetToken().setOwnerId("john.doe").setViewerId("john.doe");
    private HttpServletRequest req;
    private HttpServletResponse res;
    private JsonRpcServlet servlet;
    private PersonHandler peopleHandler;
    private ActivityHandler activityHandler;
    private AppDataHandler appDataHandler;
    private BeanJsonConverter jsonConverter;
    private BeanXStreamConverter xmlConverter;

    protected void setUp() throws Exception {
        this.servlet = new JsonRpcServlet();
        this.req = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
        this.res = (HttpServletResponse)EasyMock.createMock(HttpServletResponse.class);
        this.jsonConverter = (BeanJsonConverter)EasyMock.createMock(BeanJsonConverter.class);
        this.xmlConverter = (BeanXStreamConverter)EasyMock.createMock(BeanXStreamConverter.class);
        BeanXStreamAtomConverter atomConverter = (BeanXStreamAtomConverter)EasyMock.createMock(BeanXStreamAtomConverter.class);
        this.peopleHandler = (PersonHandler)EasyMock.createMock(PersonHandler.class);
        this.activityHandler = (ActivityHandler)EasyMock.createMock(ActivityHandler.class);
        this.appDataHandler = (AppDataHandler)EasyMock.createMock(AppDataHandler.class);
        StandardHandlerDispatcher dispatcher = new StandardHandlerDispatcher(JsonRpcServletTest.constant(this.peopleHandler), JsonRpcServletTest.constant(this.activityHandler), JsonRpcServletTest.constant(this.appDataHandler));
        this.servlet.setHandlerDispatcher((HandlerDispatcher)dispatcher);
        this.servlet.setBeanConverters((BeanConverter)this.jsonConverter, (BeanConverter)this.xmlConverter, (BeanConverter)atomConverter);
    }

    private static <T> Provider<T> constant(final T value) {
        return new Provider<T>(){

            public T get() {
                return value;
            }
        };
    }

    public void testPeopleMethodRecognition() throws Exception {
        this.verifyHandlerWasFoundForMethod("{method:people.get,id:id,params:{userId:5,groupId:@self}}", (DataRequestHandler)this.peopleHandler);
    }

    public void testActivitiesMethodRecognition() throws Exception {
        this.verifyHandlerWasFoundForMethod("{method:activities.get,id:id,params:{userId:5,groupId:@self}}", (DataRequestHandler)this.activityHandler);
    }

    public void testAppDataMethodRecognition() throws Exception {
        this.verifyHandlerWasFoundForMethod("{method:appdata.get,id:id,params:{userId:5,groupId:@self}}", (DataRequestHandler)this.appDataHandler);
    }

    public void testInvalidService() throws Exception {
        String json = "{method:junk.get,id:id,params:{userId:5,groupId:@self}}";
        this.setupRequest(json);
        JSONObject err = new JSONObject("{id:id,error:{message:'notImplemented: The service junk is not implemented',code:501}}");
        PrintWriter writerMock = (PrintWriter)EasyMock.createMock(PrintWriter.class);
        EasyMock.expect((Object)this.res.getWriter()).andReturn((Object)writerMock);
        writerMock.write((String)EasyMock.eq((Object)err.toString()));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.req, this.res, this.jsonConverter, writerMock});
        this.servlet.service((ServletRequest)this.req, (ServletResponse)this.res);
        EasyMock.verify((Object[])new Object[]{this.req, this.res, this.jsonConverter, writerMock});
        EasyMock.reset((Object[])new Object[]{this.req, this.res, this.jsonConverter});
    }

    public void testFailedRequest() throws Exception {
        this.setupRequest("{id:id,method:appdata.get}");
        EasyMock.expect((Object)this.appDataHandler.handleItem((RequestItem)EasyMock.isA(RpcRequestItem.class)));
        EasyMock.expectLastCall().andReturn((Object)ImmediateFuture.errorInstance((Throwable)new RuntimeException("FAILED")));
        JSONObject err = new JSONObject("{id:id,error:{message:'internalError: FAILED',code:500}}");
        PrintWriter writerMock = (PrintWriter)EasyMock.createMock(PrintWriter.class);
        EasyMock.expect((Object)this.res.getWriter()).andReturn((Object)writerMock);
        writerMock.write((String)EasyMock.eq((Object)err.toString()));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.req, this.res, this.appDataHandler, this.jsonConverter, writerMock});
        this.servlet.service((ServletRequest)this.req, (ServletResponse)this.res);
        EasyMock.verify((Object[])new Object[]{this.req, this.res, this.appDataHandler, this.jsonConverter, writerMock});
        EasyMock.reset((Object[])new Object[]{this.req, this.res, this.appDataHandler, this.jsonConverter});
    }

    private void verifyHandlerWasFoundForMethod(String json, DataRequestHandler handler) throws Exception {
        this.setupRequest(json);
        String resultObject = "my lovely json";
        EasyMock.expect((Object)handler.handleItem((RequestItem)EasyMock.isA(RequestItem.class)));
        EasyMock.expectLastCall().andReturn((Object)ImmediateFuture.newInstance((Object)resultObject));
        EasyMock.expect((Object)this.jsonConverter.convertToJson((Object)resultObject)).andReturn((Object)new JSONObject((Map)ImmutableMap.of((Object)"foo", (Object)"bar")));
        JSONObject result = new JSONObject();
        result.put("id", (Object)"id");
        result.put("data", (Map)ImmutableMap.of((Object)"foo", (Object)"bar"));
        PrintWriter writerMock = (PrintWriter)EasyMock.createMock(PrintWriter.class);
        EasyMock.expect((Object)this.res.getWriter()).andReturn((Object)writerMock);
        writerMock.write((String)EasyMock.eq((Object)result.toString()));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.req, this.res, handler, this.jsonConverter, writerMock});
        this.servlet.service((ServletRequest)this.req, (ServletResponse)this.res);
        EasyMock.verify((Object[])new Object[]{this.req, this.res, handler, this.jsonConverter, writerMock});
        EasyMock.reset((Object[])new Object[]{this.req, this.res, handler, this.jsonConverter});
    }

    public void testBasicBatch() throws Exception {
        String batchJson = "[{method:people.get,id:'1'},{method:activities.get,id:'2'}]";
        this.setupRequest(batchJson);
        String resultObject = "my lovely json";
        Future responseItemFuture = ImmediateFuture.newInstance((Object)resultObject);
        EasyMock.expect((Object)this.peopleHandler.handleItem((RequestItem)EasyMock.isA(RequestItem.class)));
        EasyMock.expectLastCall().andReturn((Object)responseItemFuture);
        EasyMock.expect((Object)this.activityHandler.handleItem((RequestItem)EasyMock.isA(RequestItem.class)));
        EasyMock.expectLastCall().andReturn((Object)responseItemFuture);
        EasyMock.expect((Object)this.jsonConverter.convertToJson((Object)resultObject)).andStubReturn((Object)new JSONObject((Map)ImmutableMap.of((Object)"foo", (Object)"bar")));
        JSONArray result = new JSONArray("[{id:'1',data:{foo:'bar'}},{id:'2',data:{foo:'bar'}}]");
        PrintWriter writerMock = (PrintWriter)EasyMock.createMock(PrintWriter.class);
        EasyMock.expect((Object)this.res.getWriter()).andReturn((Object)writerMock);
        writerMock.write((String)EasyMock.eq((Object)result.toString()));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.req, this.res, this.peopleHandler, this.activityHandler, this.jsonConverter, writerMock});
        this.servlet.service((ServletRequest)this.req, (ServletResponse)this.res);
        EasyMock.verify((Object[])new Object[]{this.req, this.res, this.peopleHandler, this.activityHandler, this.jsonConverter, writerMock});
        EasyMock.reset((Object[])new Object[]{this.req, this.res, this.peopleHandler, this.activityHandler, this.jsonConverter});
    }

    public void testGetExecution() throws Exception {
        EasyMock.expect((Object)this.req.getParameterMap()).andStubReturn((Object)ImmutableMap.of((Object)"method", (Object)new String[]{"people.get"}, (Object)"id", (Object)new String[]{"1"}));
        EasyMock.expect((Object)this.req.getMethod()).andStubReturn((Object)"GET");
        EasyMock.expect((Object)this.req.getAttribute((String)EasyMock.isA(String.class))).andReturn((Object)FAKE_GADGET_TOKEN);
        EasyMock.expect((Object)this.req.getCharacterEncoding()).andStubReturn((Object)"UTF-8");
        this.res.setCharacterEncoding("UTF-8");
        String resultObject = "my lovely json";
        Future responseItemFuture = ImmediateFuture.newInstance((Object)resultObject);
        EasyMock.expect((Object)this.peopleHandler.handleItem((RequestItem)EasyMock.isA(RequestItem.class)));
        EasyMock.expectLastCall().andReturn((Object)responseItemFuture);
        EasyMock.expect((Object)this.jsonConverter.convertToJson((Object)resultObject)).andReturn((Object)new JSONObject((Map)ImmutableMap.of((Object)"foo", (Object)"bar")));
        JSONObject result = new JSONObject("{id:'1',data:{foo:'bar'}}");
        PrintWriter writerMock = (PrintWriter)EasyMock.createMock(PrintWriter.class);
        EasyMock.expect((Object)this.res.getWriter()).andReturn((Object)writerMock);
        writerMock.write((String)EasyMock.eq((Object)result.toString()));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.req, this.res, this.peopleHandler, this.activityHandler, this.jsonConverter, writerMock});
        this.servlet.service((ServletRequest)this.req, (ServletResponse)this.res);
        EasyMock.verify((Object[])new Object[]{this.req, this.res, this.peopleHandler, this.activityHandler, this.jsonConverter, writerMock});
        EasyMock.reset((Object[])new Object[]{this.req, this.res, this.peopleHandler, this.activityHandler, this.jsonConverter});
    }

    private void setupRequest(String json) throws IOException {
        final ByteArrayInputStream in = new ByteArrayInputStream(json.getBytes());
        ServletInputStream stream = new ServletInputStream(){

            public int read() throws IOException {
                return in.read();
            }
        };
        EasyMock.expect((Object)this.req.getInputStream()).andStubReturn((Object)stream);
        EasyMock.expect((Object)this.req.getMethod()).andStubReturn((Object)"POST");
        EasyMock.expect((Object)this.req.getAttribute((String)EasyMock.isA(String.class))).andReturn((Object)FAKE_GADGET_TOKEN);
        EasyMock.expect((Object)this.req.getCharacterEncoding()).andStubReturn((Object)"UTF-8");
        this.res.setCharacterEncoding("UTF-8");
        this.res.setContentType("application/json");
    }
}

