/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.shindig.social.SocialApiTestsGuiceModule;
import org.apache.shindig.social.core.model.ActivityImpl;
import org.apache.shindig.social.core.model.AddressImpl;
import org.apache.shindig.social.core.model.ListFieldImpl;
import org.apache.shindig.social.core.model.MediaItemImpl;
import org.apache.shindig.social.core.model.NameImpl;
import org.apache.shindig.social.core.model.PersonImpl;
import org.apache.shindig.social.core.util.BeanJsonConverter;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.model.Address;
import org.apache.shindig.social.opensocial.model.ListField;
import org.apache.shindig.social.opensocial.model.MediaItem;
import org.apache.shindig.social.opensocial.model.Name;
import org.apache.shindig.social.opensocial.model.Person;
import org.json.JSONArray;
import org.json.JSONObject;

public class BeanJsonConverterTest
extends TestCase {
    private Person johnDoe;
    private Activity activity;
    private BeanJsonConverter beanJsonConverter;

    public void setUp() throws Exception {
        super.setUp();
        this.johnDoe = new PersonImpl("johnDoeId", "Johnny", (Name)new NameImpl("John Doe"));
        this.johnDoe.setPhoneNumbers((List)Lists.newArrayList((Object[])new ListField[]{new ListFieldImpl("home", "+33H000000000"), new ListFieldImpl("mobile", "+33M000000000"), new ListFieldImpl("work", "+33W000000000")}));
        this.johnDoe.setAddresses((List)Lists.newArrayList((Object[])new Address[]{new AddressImpl("My home address")}));
        this.johnDoe.setEmails((List)Lists.newArrayList((Object[])new ListField[]{new ListFieldImpl("work", "john.doe@work.bar"), new ListFieldImpl("home", "john.doe@home.bar")}));
        this.activity = new ActivityImpl("activityId", this.johnDoe.getId());
        this.activity.setMediaItems((List)Lists.newArrayList((Object[])new MediaItem[]{new MediaItemImpl("image/jpg", MediaItem.Type.IMAGE, "http://foo.bar")}));
        this.beanJsonConverter = new BeanJsonConverter(Guice.createInjector((Module[])new Module[]{new SocialApiTestsGuiceModule()}));
    }

    public void testToJsonOnInheritedClass() throws Exception {
        SpecialPerson cassie = new SpecialPerson("5", "robot", "nonsense");
        JSONObject result = (JSONObject)this.beanJsonConverter.convertToJson((Object)cassie);
        BeanJsonConverterTest.assertEquals((String)cassie.getId(), (String)result.getString("id"));
        BeanJsonConverterTest.assertEquals((String)cassie.getNewfield(), (String)result.getString("newfield"));
    }

    public void testPersonToJson() throws Exception {
        JSONObject result = (JSONObject)this.beanJsonConverter.convertToJson((Object)this.johnDoe);
        BeanJsonConverterTest.assertEquals((String)this.johnDoe.getId(), (String)result.getString("id"));
        BeanJsonConverterTest.assertEquals((String)this.johnDoe.getName().getFormatted(), (String)result.getJSONObject("name").getString("formatted"));
        BeanJsonConverterTest.assertEquals((String)((Address)this.johnDoe.getAddresses().get(0)).getFormatted(), (String)result.getJSONArray("addresses").getJSONObject(0).getString("formatted"));
        JSONArray phoneArray = result.getJSONArray("phoneNumbers");
        BeanJsonConverterTest.assertEquals((int)3, (int)phoneArray.length());
        for (int i = 0; i < this.johnDoe.getPhoneNumbers().size(); ++i) {
            ListField expectedPhone = (ListField)this.johnDoe.getPhoneNumbers().get(i);
            JSONObject actualPhone = phoneArray.getJSONObject(i);
            BeanJsonConverterTest.assertEquals((String)expectedPhone.getType(), (String)actualPhone.getString("type"));
            BeanJsonConverterTest.assertEquals((String)expectedPhone.getValue(), (String)actualPhone.getString("value"));
        }
        JSONArray emailArray = result.getJSONArray("emails");
        BeanJsonConverterTest.assertEquals((int)2, (int)emailArray.length());
        for (int i = 0; i < this.johnDoe.getEmails().size(); ++i) {
            ListField expectedEmail = (ListField)this.johnDoe.getEmails().get(i);
            JSONObject actualEmail = emailArray.getJSONObject(i);
            BeanJsonConverterTest.assertEquals((String)expectedEmail.getType(), (String)actualEmail.getString("type"));
            BeanJsonConverterTest.assertEquals((String)expectedEmail.getValue(), (String)actualEmail.getString("value"));
        }
    }

    public void testActivityToJson() throws Exception {
        JSONObject result = (JSONObject)this.beanJsonConverter.convertToJson((Object)this.activity);
        BeanJsonConverterTest.assertEquals((String)this.activity.getUserId(), (String)result.getString("userId"));
        BeanJsonConverterTest.assertEquals((String)this.activity.getId(), (String)result.getString("id"));
        JSONArray mediaItemsArray = result.getJSONArray("mediaItems");
        BeanJsonConverterTest.assertEquals((int)1, (int)mediaItemsArray.length());
        MediaItem expectedItem = (MediaItem)this.activity.getMediaItems().get(0);
        JSONObject actualItem = mediaItemsArray.getJSONObject(0);
        BeanJsonConverterTest.assertEquals((String)expectedItem.getUrl(), (String)actualItem.getString("url"));
        BeanJsonConverterTest.assertEquals((String)expectedItem.getMimeType(), (String)actualItem.getString("mimeType"));
        BeanJsonConverterTest.assertEquals((String)expectedItem.getType().toString(), (String)actualItem.getString("type"));
    }

    public void testMapsToJson() throws Exception {
        HashMap map = Maps.newHashMap();
        HashMap item1Map = Maps.newHashMap();
        item1Map.put("value", "1");
        item1Map.put("value2", null);
        map.put("item1", item1Map);
        HashMap item2Map = Maps.newHashMap();
        item2Map.put("value", "2");
        map.put("item2", item2Map);
        JSONObject jsonMap = (JSONObject)this.beanJsonConverter.convertToJson((Object)map);
        BeanJsonConverterTest.assertEquals((String)"1", (String)jsonMap.getJSONObject("item1").getString("value"));
        BeanJsonConverterTest.assertEquals((String)"2", (String)jsonMap.getJSONObject("item2").getString("value"));
    }

    public void testListsToJson() throws Exception {
        HashMap item1Map = Maps.newHashMap();
        item1Map.put("value", "1");
        HashMap item2Map = Maps.newHashMap();
        item2Map.put("value", "2");
        JSONArray jsonArray = (JSONArray)this.beanJsonConverter.convertToJson((Object)Lists.newArrayList((Object[])new Map[]{item1Map, item2Map}));
        BeanJsonConverterTest.assertEquals((String)"1", (String)((JSONObject)jsonArray.get(0)).getString("value"));
        BeanJsonConverterTest.assertEquals((String)"2", (String)((JSONObject)jsonArray.get(1)).getString("value"));
    }

    public void testArrayToJson() throws Exception {
        String[] colors = new String[]{"blue", "green", "aquamarine"};
        JSONArray jsonArray = (JSONArray)this.beanJsonConverter.convertToJson((Object)colors);
        BeanJsonConverterTest.assertEquals((int)colors.length, (int)jsonArray.length());
        BeanJsonConverterTest.assertEquals((Object)colors[0], (Object)jsonArray.get(0));
    }

    public void testJsonToActivity() throws Exception {
        String jsonActivity = "{userId : 5, id : 6, mediaItems : [{url : 'hello', mimeType : 'mimey', type : 'video'}]}";
        Activity result = (Activity)this.beanJsonConverter.convertToObject(jsonActivity, Activity.class);
        BeanJsonConverterTest.assertEquals((String)"5", (String)result.getUserId());
        BeanJsonConverterTest.assertEquals((String)"6", (String)result.getId());
        BeanJsonConverterTest.assertEquals((int)1, (int)result.getMediaItems().size());
        MediaItem actualItem = (MediaItem)result.getMediaItems().get(0);
        BeanJsonConverterTest.assertEquals((String)"hello", (String)actualItem.getUrl());
        BeanJsonConverterTest.assertEquals((String)"mimey", (String)actualItem.getMimeType());
        BeanJsonConverterTest.assertEquals((String)"video", (String)actualItem.getType().toString());
    }

    public void testJsonToMap() throws Exception {
        String jsonActivity = "{count : 0, favoriteColor : 'yellow'}";
        Map data = Maps.newHashMap();
        data = (Map)this.beanJsonConverter.convertToObject(jsonActivity, data.getClass());
        BeanJsonConverterTest.assertEquals((int)2, (int)data.size());
        for (Map.Entry entry : data.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.equals("count")) {
                BeanJsonConverterTest.assertEquals((String)"0", (String)value);
                continue;
            }
            if (!key.equals("favoriteColor")) continue;
            BeanJsonConverterTest.assertEquals((String)"yellow", (String)value);
        }
    }

    public void testJsonToPerson() throws Exception {
        String jsonPerson = "{age : '10', hasApp : 'true', isViewer : 'true'}";
        Person result = (Person)this.beanJsonConverter.convertToObject(jsonPerson, Person.class);
        BeanJsonConverterTest.assertEquals((int)10, (int)result.getAge());
        BeanJsonConverterTest.assertEquals((boolean)true, (boolean)result.getHasApp());
        BeanJsonConverterTest.assertEquals((boolean)true, (boolean)result.getIsViewer());
    }

    public static class SpecialPerson
    extends PersonImpl {
        private String newfield;

        public SpecialPerson(String id, String name, String newfield) {
            super(id, name, (Name)new NameImpl(name));
            this.newfield = newfield;
        }

        public String getNewfield() {
            return this.newfield;
        }
    }
}

