/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.util;

import java.util.List;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.apache.shindig.social.core.util.JsonObjectToMapMorpher;
import org.junit.Assert;
import org.junit.Test;

public class JsonObjectToMapMorpherTest {
    @Test
    public void testMorphsTo() {
        JsonObjectToMapMorpher m = new JsonObjectToMapMorpher();
        Assert.assertEquals(Map.class, (Object)m.morphsTo());
    }

    @Test
    public void testSupports() {
        JsonObjectToMapMorpher m = new JsonObjectToMapMorpher();
        Assert.assertTrue((boolean)m.supports(JSONObject.class));
        Assert.assertFalse((boolean)m.supports(JSON.class));
        Assert.assertFalse((boolean)m.supports(List.class));
    }

    @Test
    public void testMorph() {
        JsonObjectToMapMorpher om = new JsonObjectToMapMorpher();
        JSONObject testObj = new JSONObject();
        testObj.put((Object)"x", (Object)"y");
        testObj.put((Object)"1", (Object)"z");
        Object o = om.morph((Object)testObj);
        Assert.assertNotSame((Object)testObj, (Object)o);
        if (o instanceof Map) {
            Map fm = (Map)o;
            Assert.assertEquals((Object)"y", fm.get("x"));
            Assert.assertEquals((Object)"z", fm.get("1"));
            Assert.assertNull(fm.get("xyz"));
        }
        try {
            om.morph(o);
            Assert.fail();
        }
        catch (ClassCastException cce) {
            Assert.assertTrue((boolean)true);
        }
    }
}

