/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.social.EasyMockTestCase;
import org.apache.shindig.social.core.util.BeanJsonConverter;
import org.apache.shindig.social.core.util.ContainerConf;
import org.apache.shindig.social.core.util.JsonContainerConf;
import org.apache.shindig.social.opensocial.service.AppDataHandler;
import org.apache.shindig.social.opensocial.service.BeanConverter;
import org.apache.shindig.social.opensocial.service.RequestItem;
import org.apache.shindig.social.opensocial.service.RestfulRequestItem;
import org.apache.shindig.social.opensocial.spi.AppDataService;
import org.apache.shindig.social.opensocial.spi.DataCollection;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.SocialSpiException;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.easymock.classextension.EasyMock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppDataHandlerTest
extends EasyMockTestCase {
    private BeanJsonConverter converter;
    private AppDataService appDataService;
    private AppDataHandler handler;
    private FakeGadgetToken token;
    private RestfulRequestItem request;
    private static final Set<UserId> JOHN_DOE = Collections.unmodifiableSet(Sets.newHashSet((Object[])new UserId[]{new UserId(UserId.Type.userId, "john.doe")}));

    protected void setUp() throws Exception {
        this.token = new FakeGadgetToken();
        this.converter = (BeanJsonConverter)EasyMock.createMock(BeanJsonConverter.class);
        this.appDataService = (AppDataService)EasyMock.createMock(AppDataService.class);
        JsonContainerConf containerConf = new JsonContainerConf();
        this.handler = new AppDataHandler(this.appDataService, (ContainerConf)containerConf);
    }

    @Override
    protected void replay() {
        EasyMock.replay((Object[])new Object[]{this.converter});
        EasyMock.replay((Object[])new Object[]{this.appDataService});
    }

    @Override
    protected void verify() {
        EasyMock.verify((Object[])new Object[]{this.converter});
        EasyMock.verify((Object[])new Object[]{this.appDataService});
    }

    private void setPath(String path) {
        HashMap params = Maps.newHashMap();
        params.put("fields", null);
        this.setPathAndParams(path, params);
    }

    private void setPathAndParams(String path, Map<String, String> params) {
        this.setPathAndParams(path, params, null);
    }

    private void setPathAndParams(String path, Map<String, String> params, String postData) {
        this.request = new RestfulRequestItem(path, "GET", postData, (SecurityToken)this.token, (BeanConverter)this.converter);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            this.request.setParameter(entry.getKey(), entry.getValue());
        }
    }

    private void assertHandleGetForGroup(GroupId.Type group) throws Exception {
        this.setPath("/activities/john.doe/@" + group.toString() + "/appId");
        DataCollection data = new DataCollection(null);
        EasyMock.expect((Object)this.appDataService.getPersonData(JOHN_DOE, new GroupId(group, null), "appId", (Set)Sets.newHashSet(), (SecurityToken)this.token)).andReturn((Object)ImmediateFuture.newInstance((Object)data));
        this.replay();
        AppDataHandlerTest.assertEquals((Object)data, this.handler.handleGet((RequestItem)this.request).get());
        this.verify();
    }

    public void testHandleGetAll() throws Exception {
        this.assertHandleGetForGroup(GroupId.Type.all);
    }

    public void testHandleGetFriends() throws Exception {
        this.assertHandleGetForGroup(GroupId.Type.friends);
    }

    public void testHandleGetSelf() throws Exception {
        this.assertHandleGetForGroup(GroupId.Type.self);
    }

    public void testHandleGetPlural() throws Exception {
        this.setPath("/activities/john.doe,jane.doe/@self/appId");
        DataCollection data = new DataCollection(null);
        LinkedHashSet userIdSet = Sets.newLinkedHashSet(JOHN_DOE);
        userIdSet.add(new UserId(UserId.Type.userId, "jane.doe"));
        EasyMock.expect((Object)this.appDataService.getPersonData((Set)userIdSet, new GroupId(GroupId.Type.self, null), "appId", (Set)Sets.newHashSet(), (SecurityToken)this.token)).andReturn((Object)ImmediateFuture.newInstance((Object)data));
        this.replay();
        AppDataHandlerTest.assertEquals((Object)data, this.handler.handleGet((RequestItem)this.request).get());
        this.verify();
    }

    public void testHandleGetWithoutFields() throws Exception {
        HashMap params = Maps.newHashMap();
        params.put("fields", "pandas");
        this.setPathAndParams("/appData/john.doe/@friends/appId", params);
        DataCollection data = new DataCollection(null);
        EasyMock.expect((Object)this.appDataService.getPersonData(JOHN_DOE, new GroupId(GroupId.Type.friends, null), "appId", (Set)Sets.newHashSet((Object[])new String[]{"pandas"}), (SecurityToken)this.token)).andReturn((Object)ImmediateFuture.newInstance((Object)data));
        this.replay();
        AppDataHandlerTest.assertEquals((Object)data, this.handler.handleGet((RequestItem)this.request).get());
        this.verify();
    }

    private void setupPostData() throws SocialSpiException {
        String jsonAppData = "{pandas: 'are fuzzy'}";
        HashMap params = Maps.newHashMap();
        params.put("fields", "pandas");
        this.setPathAndParams("/appData/john.doe/@self/appId", params, jsonAppData);
        HashMap values = Maps.newHashMap();
        EasyMock.expect((Object)this.converter.convertToObject(jsonAppData, HashMap.class)).andReturn((Object)values);
        EasyMock.expect((Object)this.appDataService.updatePersonData(JOHN_DOE.iterator().next(), new GroupId(GroupId.Type.self, null), "appId", (Set)Sets.newHashSet((Object[])new String[]{"pandas"}), (Map)values, (SecurityToken)this.token)).andReturn((Object)ImmediateFuture.newInstance((Object)null));
        this.replay();
    }

    public void testHandlePost() throws Exception {
        this.setupPostData();
        AppDataHandlerTest.assertNull(this.handler.handlePost((RequestItem)this.request).get());
        this.verify();
    }

    public void testHandlePut() throws Exception {
        this.setupPostData();
        AppDataHandlerTest.assertNull(this.handler.handlePut((RequestItem)this.request).get());
        this.verify();
    }

    public void testHandleNullPostDataKeys() throws Exception {
        String jsonAppData = "{pandas: 'are fuzzy'}";
        HashMap params = Maps.newHashMap();
        params.put("fields", "pandas");
        this.setPathAndParams("/appData/john.doe/@self/appId", params, jsonAppData);
        HashMap values = Maps.newHashMap();
        values.put("Aokkey", "an ok key");
        values.put("", "an empty value");
        EasyMock.expect((Object)this.converter.convertToObject(jsonAppData, HashMap.class)).andReturn((Object)values);
        this.replay();
        try {
            this.handler.handlePost((RequestItem)this.request).get();
            AppDataHandlerTest.fail();
        }
        catch (SocialSpiException spi) {
            // empty catch block
        }
        this.verify();
    }

    public void testHandleInvalidPostDataKeys() throws Exception {
        String jsonAppData = "{pandas: 'are fuzzy'}";
        HashMap params = Maps.newHashMap();
        params.put("fields", "pandas");
        this.setPathAndParams("/appData/john.doe/@self/appId", params, jsonAppData);
        HashMap values = Maps.newHashMap();
        values.put("Aokkey", "an ok key");
        values.put("a bad key", "a good value");
        EasyMock.expect((Object)this.converter.convertToObject(jsonAppData, HashMap.class)).andReturn((Object)values);
        this.replay();
        try {
            this.handler.handlePost((RequestItem)this.request).get();
            AppDataHandlerTest.fail();
        }
        catch (SocialSpiException spi) {
            // empty catch block
        }
        this.verify();
    }

    public void testHandleDelete() throws Exception {
        HashMap params = Maps.newHashMap();
        params.put("fields", "pandas");
        this.setPathAndParams("/appData/john.doe/@self/appId", params);
        EasyMock.expect((Object)this.appDataService.deletePersonData(JOHN_DOE.iterator().next(), new GroupId(GroupId.Type.self, null), "appId", (Set)Sets.newHashSet((Object[])new String[]{"pandas"}), (SecurityToken)this.token)).andReturn((Object)ImmediateFuture.newInstance((Object)null));
        this.replay();
        AppDataHandlerTest.assertNull(this.handler.handleDelete((RequestItem)this.request).get());
        this.verify();
    }
}

