/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.social.core.util.BeanJsonConverter;
import org.apache.shindig.social.opensocial.service.BeanConverter;
import org.apache.shindig.social.opensocial.service.RpcRequestItem;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.PersonService;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.json.JSONObject;

public class RpcRequestItemTest
extends TestCase {
    private static final FakeGadgetToken FAKE_TOKEN = new FakeGadgetToken();
    private RpcRequestItem request;
    private JSONObject baseRpc;

    protected void setUp() throws Exception {
        super.setUp();
        this.baseRpc = new JSONObject("{method:people.get,id:id,params:{userId:john.doe,groupId:@self,fields:[huey,dewey,louie]}}");
        this.request = new RpcRequestItem(this.baseRpc, (SecurityToken)FAKE_TOKEN, (BeanConverter)new BeanJsonConverter(Guice.createInjector((Module[])new Module[0])));
    }

    public void testParseMethod() throws Exception {
        RpcRequestItemTest.assertEquals((String)"people", (String)this.request.getService());
        RpcRequestItemTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"huey", "dewey", "louie"}), (Object)this.request.getListParameter("fields"));
        JSONObject noParams = new JSONObject(this.baseRpc.toString());
        noParams.remove("params");
        this.request = new RpcRequestItem(noParams, (SecurityToken)FAKE_TOKEN, null);
        RpcRequestItemTest.assertEquals((String)"people", (String)this.request.getService());
        RpcRequestItemTest.assertEquals(Collections.emptyList(), (Object)this.request.getListParameter("fields"));
    }

    public void testGetAppId() throws Exception {
        this.request.setParameter("appId", "100");
        RpcRequestItemTest.assertEquals((String)"100", (String)this.request.getAppId());
        this.request.setParameter("appId", "@app");
        RpcRequestItemTest.assertEquals((String)FAKE_TOKEN.getAppId(), (String)this.request.getAppId());
    }

    public void testGetUser() throws Exception {
        this.request.setParameter("userId", "@owner");
        RpcRequestItemTest.assertEquals((Object)UserId.Type.owner, (Object)((UserId)this.request.getUsers().iterator().next()).getType());
    }

    public void testGetGroup() throws Exception {
        this.request.setParameter("groupId", "@self");
        RpcRequestItemTest.assertEquals((Object)GroupId.Type.self, (Object)this.request.getGroup().getType());
    }

    public void testStartIndex() throws Exception {
        this.request.setParameter("startIndex", null);
        RpcRequestItemTest.assertEquals((int)0, (int)this.request.getStartIndex());
        this.request.setParameter("startIndex", "5");
        RpcRequestItemTest.assertEquals((int)5, (int)this.request.getStartIndex());
    }

    public void testCount() throws Exception {
        this.request.setParameter("count", null);
        RpcRequestItemTest.assertEquals((int)20, (int)this.request.getCount());
        this.request.setParameter("count", "5");
        RpcRequestItemTest.assertEquals((int)5, (int)this.request.getCount());
    }

    public void testSortBy() throws Exception {
        this.request.setParameter("sortBy", null);
        RpcRequestItemTest.assertEquals((String)"topFriends", (String)this.request.getSortBy());
        this.request.setParameter("sortBy", "name");
        RpcRequestItemTest.assertEquals((String)"name", (String)this.request.getSortBy());
    }

    public void testSortOrder() throws Exception {
        this.request.setParameter("sortOrder", null);
        RpcRequestItemTest.assertEquals((Object)PersonService.SortOrder.ascending, (Object)this.request.getSortOrder());
        this.request.setParameter("sortOrder", "descending");
        RpcRequestItemTest.assertEquals((Object)PersonService.SortOrder.descending, (Object)this.request.getSortOrder());
    }

    public void testFilterBy() throws Exception {
        this.request.setParameter("filterBy", null);
        RpcRequestItemTest.assertEquals(null, (String)this.request.getFilterBy());
        this.request.setParameter("filterBy", "hasApp");
        RpcRequestItemTest.assertEquals((String)"hasApp", (String)this.request.getFilterBy());
    }

    public void testFilterOperation() throws Exception {
        this.request.setParameter("filterOp", null);
        RpcRequestItemTest.assertEquals((Object)PersonService.FilterOperation.contains, (Object)this.request.getFilterOperation());
        this.request.setParameter("filterOp", "equals");
        RpcRequestItemTest.assertEquals((Object)PersonService.FilterOperation.equals, (Object)this.request.getFilterOperation());
    }

    public void testFilterValue() throws Exception {
        this.request.setParameter("filterValue", null);
        RpcRequestItemTest.assertEquals((String)"", (String)this.request.getFilterValue());
        this.request.setParameter("filterValue", "cassie");
        RpcRequestItemTest.assertEquals((String)"cassie", (String)this.request.getFilterValue());
    }

    public void testFields() throws Exception {
        this.request.setListParameter("fields", Collections.emptyList());
        RpcRequestItemTest.assertEquals((Object)Sets.newHashSet(), (Object)this.request.getFields());
        this.request.setListParameter("fields", (List)Lists.newArrayList((Object[])new String[]{"happy", "sad", "grumpy"}));
        RpcRequestItemTest.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"happy", "sad", "grumpy"}), (Object)this.request.getFields());
    }

    public void testGetTypedParameter() throws Exception {
        JSONObject obj = new JSONObject();
        obj.put("name", (Object)"Bob");
        obj.put("id", (Object)"1234");
        this.request.setJsonParameter("tp", obj);
        InputData input = (InputData)this.request.getTypedParameter("tp", InputData.class);
        RpcRequestItemTest.assertEquals((String)"Bob", (String)input.name);
        RpcRequestItemTest.assertEquals((int)1234, (int)input.id);
    }

    public void testGetTypedParameters() throws Exception {
        this.request.setParameter("name", "Bob");
        this.request.setParameter("id", "1234");
        InputData input = (InputData)this.request.getTypedParameters(InputData.class);
        RpcRequestItemTest.assertEquals((String)"Bob", (String)input.name);
        RpcRequestItemTest.assertEquals((int)1234, (int)input.id);
    }

    public static class InputData {
        String name;
        int id;

        public void setName(String name) {
            this.name = name;
        }

        public void setId(int id) {
            this.id = id;
        }
    }
}

