/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.inject.Provider;
import org.apache.shindig.social.EasyMockTestCase;
import org.apache.shindig.social.opensocial.service.ActivityHandler;
import org.apache.shindig.social.opensocial.service.AppDataHandler;
import org.apache.shindig.social.opensocial.service.DataRequestHandler;
import org.apache.shindig.social.opensocial.service.PersonHandler;
import org.apache.shindig.social.opensocial.service.StandardHandlerDispatcher;
import org.easymock.classextension.EasyMock;
import org.easymock.classextension.IMocksControl;

public class StandardHandlerDispatcherTest
extends EasyMockTestCase {
    private Provider<PersonHandler> personHandlerProvider;
    private Provider<AppDataHandler> appDataHandlerProvider;
    private Provider<ActivityHandler> activityHandlerProvider;
    private IMocksControl mockControl;
    private StandardHandlerDispatcher dispatcher;

    protected void setUp() throws Exception {
        super.setUp();
        this.mockControl = EasyMock.createControl();
        this.personHandlerProvider = (Provider)this.mockControl.createMock(Provider.class);
        this.appDataHandlerProvider = (Provider)this.mockControl.createMock(Provider.class);
        this.activityHandlerProvider = (Provider)this.mockControl.createMock(Provider.class);
        this.dispatcher = new StandardHandlerDispatcher(this.personHandlerProvider, this.activityHandlerProvider, this.appDataHandlerProvider);
    }

    public void testGetHandler() {
        PersonHandler handler = (PersonHandler)this.mockControl.createMock(PersonHandler.class);
        EasyMock.expect((Object)this.personHandlerProvider.get()).andReturn((Object)handler);
        this.mockControl.replay();
        StandardHandlerDispatcherTest.assertSame((Object)handler, (Object)this.dispatcher.getHandler("people"));
        this.mockControl.verify();
    }

    public void testGetHandler_serviceDoesntExist() {
        this.mockControl.replay();
        StandardHandlerDispatcherTest.assertNull((Object)this.dispatcher.getHandler("makebelieve"));
        this.mockControl.verify();
    }

    public void testAddHandler() {
        DataRequestHandler mockHandler = (DataRequestHandler)this.mockControl.createMock(DataRequestHandler.class);
        Provider mockProvider = (Provider)this.mockControl.createMock(Provider.class);
        this.dispatcher.addHandler("mock", mockProvider);
        EasyMock.expect((Object)mockProvider.get()).andReturn((Object)mockHandler);
        this.mockControl.replay();
        StandardHandlerDispatcherTest.assertSame((Object)mockHandler, (Object)this.dispatcher.getHandler("mock"));
        this.mockControl.verify();
    }
}

