/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.social.ResponseError;
import org.apache.shindig.social.opensocial.service.BeanConverter;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.PersonService;
import org.apache.shindig.social.opensocial.spi.SocialSpiException;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RequestItem {
    public static final String APP_ID = "appId";
    public static final String USER_ID = "userId";
    public static final String GROUP_ID = "groupId";
    public static final String START_INDEX = "startIndex";
    public static final String COUNT = "count";
    public static final String SORT_BY = "sortBy";
    public static final String SORT_ORDER = "sortOrder";
    public static final String FILTER_BY = "filterBy";
    public static final String FILTER_OPERATION = "filterOp";
    public static final String FILTER_VALUE = "filterValue";
    public static final String FIELDS = "fields";
    public static final int DEFAULT_START_INDEX = 0;
    public static final int DEFAULT_COUNT = 20;
    public static final String APP_SUBSTITUTION_TOKEN = "@app";
    private final SecurityToken token;
    protected final BeanConverter converter;
    private final String operation;
    private final String service;

    public RequestItem(String service, String operation, SecurityToken token, BeanConverter converter) {
        this.service = service;
        this.operation = operation;
        this.token = token;
        this.converter = converter;
    }

    public String getAppId() {
        String appId = this.getParameter(APP_ID);
        if (appId != null && appId.equals(APP_SUBSTITUTION_TOKEN)) {
            return this.token.getAppId();
        }
        return appId;
    }

    public Date getUpdatedSince() {
        String updatedSince = this.getParameter("updatedSince");
        if (updatedSince == null) {
            return null;
        }
        DateTime date = new DateTime((Object)updatedSince);
        if (date == null) {
            return null;
        }
        return date.toDate();
    }

    public Set<UserId> getUsers() {
        ArrayList ids = this.getListParameter(USER_ID);
        if (ids.isEmpty()) {
            if (this.token.getViewerId() != null) {
                ids = Lists.newArrayList((Object[])new String[]{"@me"});
            } else {
                throw new IllegalArgumentException("No userId provided and viewer not available");
            }
        }
        LinkedHashSet userIds = Sets.newLinkedHashSet();
        for (String id : ids) {
            userIds.add(UserId.fromJson(id));
        }
        return userIds;
    }

    public GroupId getGroup() {
        return GroupId.fromJson(this.getParameter(GROUP_ID, "@self"));
    }

    public int getStartIndex() {
        String startIndex = this.getParameter(START_INDEX);
        try {
            return startIndex == null ? 0 : Integer.valueOf(startIndex);
        }
        catch (NumberFormatException nfe) {
            throw new SocialSpiException(ResponseError.BAD_REQUEST, "Parameter startIndex (" + startIndex + ") is not a number.");
        }
    }

    public int getCount() {
        String count = this.getParameter(COUNT);
        try {
            return count == null ? 20 : Integer.valueOf(count);
        }
        catch (NumberFormatException nfe) {
            throw new SocialSpiException(ResponseError.BAD_REQUEST, "Parameter count (" + count + ") is not a number.");
        }
    }

    public String getSortBy() {
        String sortBy = this.getParameter(SORT_BY);
        return sortBy == null ? "topFriends" : sortBy;
    }

    public PersonService.SortOrder getSortOrder() {
        String sortOrder = this.getParameter(SORT_ORDER);
        try {
            return sortOrder == null ? PersonService.SortOrder.ascending : PersonService.SortOrder.valueOf(sortOrder);
        }
        catch (IllegalArgumentException iae) {
            throw new SocialSpiException(ResponseError.BAD_REQUEST, "Parameter sortOrder (" + sortOrder + ") is not valid.");
        }
    }

    public String getFilterBy() {
        return this.getParameter(FILTER_BY);
    }

    public PersonService.FilterOperation getFilterOperation() {
        String filterOp = this.getParameter(FILTER_OPERATION);
        try {
            return filterOp == null ? PersonService.FilterOperation.contains : PersonService.FilterOperation.valueOf(filterOp);
        }
        catch (IllegalArgumentException iae) {
            throw new SocialSpiException(ResponseError.BAD_REQUEST, "Parameter filterOp (" + filterOp + ") is not valid.");
        }
    }

    public String getFilterValue() {
        String filterValue = this.getParameter(FILTER_VALUE);
        return filterValue == null ? "" : filterValue;
    }

    public Set<String> getFields() {
        return this.getFields(Collections.<String>emptySet());
    }

    public Set<String> getFields(Set<String> defaultValue) {
        ImmutableSet result = ImmutableSet.copyOf(this.getListParameter(FIELDS));
        if (result.isEmpty()) {
            return defaultValue;
        }
        return result;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getService() {
        return this.service;
    }

    public SecurityToken getToken() {
        return this.token;
    }

    public abstract <T> T getTypedParameter(String var1, Class<T> var2);

    public abstract <T> T getTypedParameters(Class<T> var1);

    public abstract void applyUrlTemplate(String var1);

    public abstract String getParameter(String var1);

    public abstract String getParameter(String var1, String var2);

    public abstract List<String> getListParameter(String var1);
}

