/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.spi;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.auth.SecurityToken;

public class UserId {
    private Type type;
    private String userId;

    public UserId(Type type, String userId) {
        this.type = type;
        this.userId = userId;
    }

    public Type getType() {
        return this.type;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserId(SecurityToken token) {
        switch (this.type) {
            case owner: {
                return token.getOwnerId();
            }
            case viewer: 
            case me: {
                return token.getViewerId();
            }
            case userId: {
                return this.userId;
            }
        }
        throw new IllegalStateException("The type field is not a valid enum: " + (Object)((Object)this.type));
    }

    public static UserId fromJson(String jsonId) {
        Type idSpecEnum = Type.jsonValueOf(jsonId);
        if (idSpecEnum != null) {
            return new UserId(idSpecEnum, null);
        }
        return new UserId(Type.userId, jsonId);
    }

    public boolean equals(Object o) {
        if (!(o instanceof UserId)) {
            return false;
        }
        UserId actual = (UserId)o;
        return this.type == actual.type && StringUtils.equals((String)this.userId, (String)actual.userId);
    }

    public int hashCode() {
        int userHashCode = this.userId == null ? 0 : this.userId.hashCode();
        return this.type.hashCode() + userHashCode;
    }

    public String toString() {
        switch (this.type) {
            case owner: {
                return "OWNER";
            }
            case viewer: 
            case me: {
                return "VIEWER";
            }
            case userId: {
                return "USER(" + this.userId + ")";
            }
        }
        return "UNKNOWN";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        me,
        viewer,
        owner,
        userId;

        private static final Map<String, Type> jsonTypeMap;

        public static Type jsonValueOf(String jsonType) {
            return jsonTypeMap.get(jsonType);
        }

        static {
            jsonTypeMap = Maps.newHashMap();
            for (Type type : Type.values()) {
                jsonTypeMap.put("@" + type.name(), type);
            }
        }
    }
}

