/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.sample.spi;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.protocol.DataCollection;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.protocol.model.FilterOperation;
import org.apache.shindig.protocol.model.SortOrder;
import org.apache.shindig.social.SocialApiTestsGuiceModule;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.apache.shindig.social.sample.spi.JsonDbOpensocialService;

public class JsonDbOpensocialServiceTest
extends TestCase {
    private JsonDbOpensocialService db;
    private static final UserId CANON_USER = new UserId(UserId.Type.userId, "canonical");
    private static final UserId JOHN_DOE = new UserId(UserId.Type.userId, "john.doe");
    private static final UserId JANE_DOE = new UserId(UserId.Type.userId, "jane.doe");
    private static final GroupId SELF_GROUP = new GroupId(GroupId.Type.self, null);
    private static final String APP_ID = "1";
    private static final String CANONICAL_USER_ID = "canonical";
    private SecurityToken token = new FakeGadgetToken();

    protected void setUp() throws Exception {
        super.setUp();
        Injector injector = Guice.createInjector((Module[])new Module[]{new SocialApiTestsGuiceModule()});
        this.db = (JsonDbOpensocialService)injector.getInstance(JsonDbOpensocialService.class);
    }

    public void testGetPersonDefaultFields() throws Exception {
        Person person = (Person)this.db.getPerson(CANON_USER, Person.Field.DEFAULT_FIELDS, this.token).get();
        JsonDbOpensocialServiceTest.assertNotNull((String)"Canonical user not found", (Object)person);
        JsonDbOpensocialServiceTest.assertNotNull((String)"Canonical user has no id", (Object)person.getId());
        JsonDbOpensocialServiceTest.assertNotNull((String)"Canonical user has no name", (Object)person.getName());
        JsonDbOpensocialServiceTest.assertNotNull((String)"Canonical user has no thumbnail", (Object)person.getThumbnailUrl());
    }

    public void testGetPersonAllFields() throws Exception {
        Person person = (Person)this.db.getPerson(CANON_USER, Person.Field.ALL_FIELDS, this.token).get();
        JsonDbOpensocialServiceTest.assertNotNull((String)"Canonical user not found", (Object)person);
    }

    public void testGetPersonAllAppData() throws Exception {
        Person person = (Person)this.db.getPerson(CANON_USER, (Set)ImmutableSet.of((Object[])new String[]{"id", "appData"}), this.token).get();
        JsonDbOpensocialServiceTest.assertNotNull((String)"Canonical user not found", (Object)person);
        JsonDbOpensocialServiceTest.assertEquals((String)"Canonical user has wrong id", (String)CANONICAL_USER_ID, (String)person.getId());
        JsonDbOpensocialServiceTest.assertEquals((String)"Canonical user has wrong app data", (Object)ImmutableMap.of((Object)"count", (Object)"2", (Object)"size", (Object)"100"), (Object)person.getAppData());
    }

    public void testGetPersonOneAppDataField() throws Exception {
        Person person = (Person)this.db.getPerson(CANON_USER, (Set)ImmutableSet.of((Object[])new String[]{"id", "appData.size"}), this.token).get();
        JsonDbOpensocialServiceTest.assertNotNull((String)"Canonical user not found", (Object)person);
        JsonDbOpensocialServiceTest.assertEquals((String)"Canonical user has wrong id", (String)CANONICAL_USER_ID, (String)person.getId());
        JsonDbOpensocialServiceTest.assertEquals((String)"Canonical user has wrong app data", (Object)ImmutableMap.of((Object)"size", (Object)"100"), (Object)person.getAppData());
    }

    public void testGetPersonMultipleAppDataFields() throws Exception {
        Person person = (Person)this.db.getPerson(CANON_USER, (Set)ImmutableSet.of((Object[])new String[]{"id", "appData.size", "appData.count", "appData.bogus"}), this.token).get();
        JsonDbOpensocialServiceTest.assertNotNull((String)"Canonical user not found", (Object)person);
        JsonDbOpensocialServiceTest.assertEquals((String)"Canonical user has wrong id", (String)CANONICAL_USER_ID, (String)person.getId());
        JsonDbOpensocialServiceTest.assertEquals((String)"Canonical user has wrong app data", (Object)ImmutableMap.of((Object)"count", (Object)"2", (Object)"size", (Object)"100"), (Object)person.getAppData());
    }

    public void testGetExpectedFriends() throws Exception {
        CollectionOptions options = new CollectionOptions();
        options.setSortBy("topFriends");
        options.setSortOrder(SortOrder.ascending);
        options.setFilter(null);
        options.setFilterOperation(FilterOperation.contains);
        options.setFilterValue("");
        options.setFirst(0);
        options.setMax(20);
        RestfulCollection responseItem = (RestfulCollection)this.db.getPeople((Set)ImmutableSet.of((Object)CANON_USER), new GroupId(GroupId.Type.friends, null), options, Collections.emptySet(), this.token).get();
        JsonDbOpensocialServiceTest.assertNotNull((Object)responseItem);
        JsonDbOpensocialServiceTest.assertEquals((int)4, (int)responseItem.getTotalResults());
        JsonDbOpensocialServiceTest.assertEquals((String)"john.doe", (String)((Person)responseItem.getEntry().get(0)).getId());
        JsonDbOpensocialServiceTest.assertEquals((String)"jane.doe", (String)((Person)responseItem.getEntry().get(1)).getId());
    }

    public void testGetExpectedUsersForPlural() throws Exception {
        CollectionOptions options = new CollectionOptions();
        options.setSortBy("topFriends");
        options.setSortOrder(SortOrder.ascending);
        options.setFilter(null);
        options.setFilterOperation(FilterOperation.contains);
        options.setFilterValue("");
        options.setFirst(0);
        options.setMax(20);
        RestfulCollection responseItem = (RestfulCollection)this.db.getPeople((Set)ImmutableSet.of((Object[])new UserId[]{JOHN_DOE, JANE_DOE}), new GroupId(GroupId.Type.friends, null), options, Collections.emptySet(), this.token).get();
        JsonDbOpensocialServiceTest.assertNotNull((Object)responseItem);
        JsonDbOpensocialServiceTest.assertEquals((int)4, (int)responseItem.getTotalResults());
        JsonDbOpensocialServiceTest.assertEquals((String)"john.doe", (String)((Person)responseItem.getEntry().get(0)).getId());
        JsonDbOpensocialServiceTest.assertEquals((String)"jane.doe", (String)((Person)responseItem.getEntry().get(1)).getId());
    }

    public void testGetExpectedActivities() throws Exception {
        RestfulCollection responseItem = (RestfulCollection)this.db.getActivities((Set)ImmutableSet.of((Object)CANON_USER), SELF_GROUP, APP_ID, Collections.emptySet(), null, (SecurityToken)new FakeGadgetToken()).get();
        JsonDbOpensocialServiceTest.assertSame((Object)2, (Object)responseItem.getTotalResults());
    }

    public void testGetExpectedActivitiesForPlural() throws Exception {
        RestfulCollection responseItem = (RestfulCollection)this.db.getActivities((Set)ImmutableSet.of((Object[])new UserId[]{CANON_USER, JOHN_DOE}), SELF_GROUP, APP_ID, Collections.emptySet(), null, (SecurityToken)new FakeGadgetToken()).get();
        JsonDbOpensocialServiceTest.assertSame((Object)3, (Object)responseItem.getTotalResults());
    }

    public void testGetExpectedActivity() throws Exception {
        Activity activity = (Activity)this.db.getActivity(CANON_USER, SELF_GROUP, APP_ID, (Set)ImmutableSet.of((Object[])new String[]{"appId", "body", "mediaItems"}), APP_ID, (SecurityToken)new FakeGadgetToken()).get();
        JsonDbOpensocialServiceTest.assertNotNull((Object)activity);
        JsonDbOpensocialServiceTest.assertNotNull((Object)activity.getBody());
        JsonDbOpensocialServiceTest.assertNull((Object)activity.getBodyId());
    }

    public void testDeleteExpectedActivity() throws Exception {
        this.db.deleteActivities(CANON_USER, SELF_GROUP, APP_ID, (Set)ImmutableSet.of((Object)APP_ID), (SecurityToken)new FakeGadgetToken());
        try {
            this.db.getActivity(CANON_USER, SELF_GROUP, APP_ID, (Set)ImmutableSet.of((Object[])new String[]{"appId", "body", "mediaItems"}), APP_ID, (SecurityToken)new FakeGadgetToken()).get();
            JsonDbOpensocialServiceTest.fail();
        }
        catch (ProtocolException sse) {
            JsonDbOpensocialServiceTest.assertEquals((int)400, (int)sse.getCode());
        }
    }

    public void testGetExpectedAppData() throws Exception {
        DataCollection responseItem = (DataCollection)this.db.getPersonData((Set)ImmutableSet.of((Object)CANON_USER), SELF_GROUP, APP_ID, Collections.emptySet(), (SecurityToken)new FakeGadgetToken()).get();
        JsonDbOpensocialServiceTest.assertFalse((boolean)responseItem.getEntry().isEmpty());
        JsonDbOpensocialServiceTest.assertFalse((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).isEmpty());
        JsonDbOpensocialServiceTest.assertSame((Object)2, (Object)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).size());
        JsonDbOpensocialServiceTest.assertTrue((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).containsKey("count"));
        JsonDbOpensocialServiceTest.assertTrue((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).containsKey("size"));
    }

    public void testGetExpectedAppDataForPlural() throws Exception {
        DataCollection responseItem = (DataCollection)this.db.getPersonData((Set)ImmutableSet.of((Object[])new UserId[]{CANON_USER, JOHN_DOE}), SELF_GROUP, APP_ID, Collections.emptySet(), (SecurityToken)new FakeGadgetToken()).get();
        JsonDbOpensocialServiceTest.assertFalse((boolean)responseItem.getEntry().isEmpty());
        JsonDbOpensocialServiceTest.assertFalse((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).isEmpty());
        JsonDbOpensocialServiceTest.assertSame((Object)2, (Object)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).size());
        JsonDbOpensocialServiceTest.assertTrue((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).containsKey("count"));
        JsonDbOpensocialServiceTest.assertTrue((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).containsKey("size"));
        JsonDbOpensocialServiceTest.assertFalse((boolean)((Map)responseItem.getEntry().get(JOHN_DOE.getUserId())).isEmpty());
        JsonDbOpensocialServiceTest.assertSame((Object)1, (Object)((Map)responseItem.getEntry().get(JOHN_DOE.getUserId())).size());
        JsonDbOpensocialServiceTest.assertTrue((boolean)((Map)responseItem.getEntry().get(JOHN_DOE.getUserId())).containsKey("count"));
    }

    public void testDeleteExpectedAppData() throws Exception {
        this.db.deletePersonData(CANON_USER, SELF_GROUP, APP_ID, (Set)ImmutableSet.of((Object)"count"), (SecurityToken)new FakeGadgetToken());
        DataCollection responseItem = (DataCollection)this.db.getPersonData((Set)ImmutableSet.of((Object)CANON_USER), SELF_GROUP, APP_ID, Collections.emptySet(), (SecurityToken)new FakeGadgetToken()).get();
        JsonDbOpensocialServiceTest.assertFalse((boolean)responseItem.getEntry().isEmpty());
        JsonDbOpensocialServiceTest.assertFalse((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).isEmpty());
        JsonDbOpensocialServiceTest.assertSame((Object)1, (Object)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).size());
        JsonDbOpensocialServiceTest.assertFalse((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).containsKey("count"));
        JsonDbOpensocialServiceTest.assertTrue((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).containsKey("size"));
    }

    public void testUpdateExpectedAppData() throws Exception {
        this.db.updatePersonData(CANON_USER, SELF_GROUP, APP_ID, null, (Map)ImmutableMap.of((Object)"count", (Object)"10", (Object)"newvalue", (Object)"20"), (SecurityToken)new FakeGadgetToken());
        DataCollection responseItem = (DataCollection)this.db.getPersonData((Set)ImmutableSet.of((Object)CANON_USER), SELF_GROUP, APP_ID, Collections.emptySet(), (SecurityToken)new FakeGadgetToken()).get();
        JsonDbOpensocialServiceTest.assertFalse((boolean)responseItem.getEntry().isEmpty());
        JsonDbOpensocialServiceTest.assertFalse((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).isEmpty());
        JsonDbOpensocialServiceTest.assertSame((Object)3, (Object)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).size());
        JsonDbOpensocialServiceTest.assertTrue((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).containsKey("count"));
        JsonDbOpensocialServiceTest.assertEquals((String)"10", (String)((String)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).get("count")));
        JsonDbOpensocialServiceTest.assertTrue((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).containsKey("newvalue"));
        JsonDbOpensocialServiceTest.assertEquals((String)"20", (String)((String)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).get("newvalue")));
    }
}

