/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.social.ResponseError;
import org.apache.shindig.social.opensocial.service.RequestItem;
import org.apache.shindig.social.opensocial.spi.SocialSpiException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataRequestHandler {
    private static final Set<String> GET_SYNONYMS = Sets.newHashSet((Object[])new String[]{"get"});
    private static final Set<String> CREATE_SYNONYMS = Sets.newHashSet((Object[])new String[]{"put", "create"});
    private static final Set<String> UPDATE_SYNONYMS = Sets.newHashSet((Object[])new String[]{"post", "update"});
    private static final Set<String> DELETE_SYNONYMS = Sets.newHashSet((Object[])new String[]{"delete"});

    public Future<?> handleItem(RequestItem request) {
        Future<?> responseItem;
        block8: {
            if (request.getOperation() == null) {
                return ImmediateFuture.errorInstance((Throwable)new SocialSpiException(ResponseError.NOT_IMPLEMENTED, "Unserviced operation"));
            }
            String operation = request.getOperation().toLowerCase();
            try {
                if (GET_SYNONYMS.contains(operation)) {
                    responseItem = this.handleGet(request);
                    break block8;
                }
                if (UPDATE_SYNONYMS.contains(operation)) {
                    responseItem = this.handlePost(request);
                    break block8;
                }
                if (CREATE_SYNONYMS.contains(operation)) {
                    responseItem = this.handlePut(request);
                    break block8;
                }
                if (DELETE_SYNONYMS.contains(operation)) {
                    responseItem = this.handleDelete(request);
                    break block8;
                }
                throw new SocialSpiException(ResponseError.NOT_IMPLEMENTED, "Unserviced operation " + operation);
            }
            catch (SocialSpiException spe) {
                return ImmediateFuture.errorInstance((Throwable)spe);
            }
            catch (Throwable t) {
                return ImmediateFuture.errorInstance((Throwable)new SocialSpiException(ResponseError.INTERNAL_ERROR, "Unknown error " + t.getMessage(), t));
            }
        }
        return responseItem;
    }

    protected abstract Future<?> handleDelete(RequestItem var1) throws SocialSpiException;

    protected abstract Future<?> handlePut(RequestItem var1) throws SocialSpiException;

    protected abstract Future<?> handlePost(RequestItem var1) throws SocialSpiException;

    protected abstract Future<?> handleGet(RequestItem var1) throws SocialSpiException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Preconditions {
        public static void requireNotEmpty(Collection<?> coll, String message) throws SocialSpiException {
            if (coll.isEmpty()) {
                throw new SocialSpiException(ResponseError.BAD_REQUEST, message);
            }
        }

        public static void requireEmpty(Collection<?> list, String message) throws SocialSpiException {
            if (!list.isEmpty()) {
                throw new SocialSpiException(ResponseError.BAD_REQUEST, message);
            }
        }

        public static void requireSingular(Collection<?> coll, String message) throws SocialSpiException {
            if (coll.size() != 1) {
                throw new SocialSpiException(ResponseError.BAD_REQUEST, message);
            }
        }

        public static void requirePlural(Collection<?> coll, String message) throws SocialSpiException {
            if (coll.size() <= 1) {
                throw new SocialSpiException(ResponseError.BAD_REQUEST, message);
            }
        }
    }
}

