/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.spi;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class GroupId {
    private Type type;
    private String groupId;

    public GroupId(Type type, String groupId) {
        this.groupId = groupId;
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public static GroupId fromJson(String jsonId) {
        Type idSpecEnum = Type.jsonValueOf(jsonId);
        if (idSpecEnum != null) {
            return new GroupId(idSpecEnum, null);
        }
        return new GroupId(Type.groupId, jsonId);
    }

    public boolean equals(Object o) {
        if (!(o instanceof GroupId)) {
            return false;
        }
        GroupId actual = (GroupId)o;
        return this.type == actual.type && StringUtils.equals((String)this.groupId, (String)actual.groupId);
    }

    public int hashCode() {
        int groupHashCode = 0;
        if (this.groupId != null) {
            groupHashCode = this.groupId.hashCode();
        }
        return this.type.hashCode() + groupHashCode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        all,
        friends,
        self,
        deleted,
        groupId;

        private static final Map<String, Type> jsonTypeMap;

        public static Type jsonValueOf(String jsonType) {
            return jsonTypeMap.get(jsonType);
        }

        static {
            jsonTypeMap = Maps.newHashMap();
            for (Type type : Type.values()) {
                jsonTypeMap.put("@" + type.name(), type);
            }
        }
    }
}

