/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.util;

import com.google.inject.Inject;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XppDriver;
import com.thoughtworks.xstream.mapper.DefaultMapper;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shindig.social.core.util.xstream.ClassFieldMapping;
import org.apache.shindig.social.core.util.xstream.InterfaceClassMapper;
import org.apache.shindig.social.core.util.xstream.MapConverter;
import org.apache.shindig.social.core.util.xstream.StackDriver;
import org.apache.shindig.social.core.util.xstream.ThreadSafeWriterStack;
import org.apache.shindig.social.core.util.xstream.WriterStack;
import org.apache.shindig.social.opensocial.model.Account;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.model.Address;
import org.apache.shindig.social.opensocial.model.BodyType;
import org.apache.shindig.social.opensocial.model.ListField;
import org.apache.shindig.social.opensocial.model.MediaItem;
import org.apache.shindig.social.opensocial.model.Message;
import org.apache.shindig.social.opensocial.model.Name;
import org.apache.shindig.social.opensocial.model.Organization;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.model.Url;
import org.apache.shindig.social.opensocial.service.BeanConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanXStreamConverter
implements BeanConverter {
    private static final List<ClassFieldMapping> listElementMappingList = new ArrayList<ClassFieldMapping>();
    private static final List<ClassFieldMapping> elementMappingList = new ArrayList<ClassFieldMapping>();
    private static final Map<String, Class<?>[]> omitMap = new HashMap<String, Class<?>[]>();
    private static final Map<String, Class<?>> elementClassMap = new HashMap();
    private static Log log;
    private Converter mapConverter;
    private InterfaceClassMapper icmapper;
    private ReflectionProvider rp = new PureJavaReflectionProvider();
    private HierarchicalStreamDriver driver;
    private WriterStack writerStack;

    @Inject
    public BeanXStreamConverter() {
        DefaultMapper dmapper = new DefaultMapper(this.getClass().getClassLoader());
        this.writerStack = new ThreadSafeWriterStack();
        this.driver = new StackDriver((HierarchicalStreamDriver)new XppDriver(), this.writerStack);
        this.icmapper = new InterfaceClassMapper(this.writerStack, (Mapper)dmapper, elementMappingList, listElementMappingList, omitMap, elementClassMap);
        this.mapConverter = new MapConverter((Mapper)this.icmapper);
    }

    @Override
    public String convertToString(Object pojo) {
        return this.convertToXml(pojo);
    }

    public String convertToXml(Object obj) {
        XStream xstream = new XStream(this.rp, (Mapper)this.icmapper, this.driver);
        xstream.registerConverter(this.mapConverter);
        xstream.setMode(1001);
        this.writerStack.reset();
        this.icmapper.setBaseObject(obj);
        String result = xstream.toXML(obj);
        log.debug((Object)("Result is " + result));
        return "<response>" + result + "</response>";
    }

    @Override
    public <T> T convertToObject(String xml, Class<T> className) {
        XStream xstream = new XStream(this.rp, (Mapper)this.icmapper, this.driver);
        xstream.registerConverter(this.mapConverter);
        xstream.setMode(1001);
        return (T)xstream.fromXML(xml);
    }

    static {
        elementMappingList.add(new ClassFieldMapping("Activity", Activity.class));
        elementMappingList.add(new ClassFieldMapping("Account", Account.class));
        elementMappingList.add(new ClassFieldMapping("Address", Address.class));
        elementMappingList.add(new ClassFieldMapping("BodyType", BodyType.class));
        elementMappingList.add(new ClassFieldMapping("Message", Message.class));
        elementMappingList.add(new ClassFieldMapping("MediaItem", MediaItem.class));
        elementMappingList.add(new ClassFieldMapping("Name", Name.class));
        elementMappingList.add(new ClassFieldMapping("Organization", Organization.class));
        elementMappingList.add(new ClassFieldMapping("person", Person.class));
        elementMappingList.add(new ClassFieldMapping("Url", Url.class));
        elementMappingList.add(new ClassFieldMapping("emails", "email", ListField.class));
        elementMappingList.add(new ClassFieldMapping("phoneNumbers", "phone", ListField.class));
        elementMappingList.add(new ClassFieldMapping("ListField", ListField.class));
        elementMappingList.add(new ClassFieldMapping("list", List.class));
        elementMappingList.add(new ClassFieldMapping("map", Map.class));
        omitMap.put("addresses", new Class[]{Person.class});
        omitMap.put("isOwner", new Class[]{Person.class});
        omitMap.put("isViewer", new Class[]{Person.class});
        elementClassMap.put("person", Person.class);
        elementClassMap.put("email", ListField.class);
        elementClassMap.put("phone", ListField.class);
        elementClassMap.put("list", ArrayList.class);
        elementClassMap.put("map", ConcurrentHashMap.class);
        elementClassMap.put("appdata", ConcurrentHashMap.class);
        elementClassMap.put("Activity", Activity.class);
        elementClassMap.put("Account", Account.class);
        elementClassMap.put("Address", Address.class);
        elementClassMap.put("BodyType", BodyType.class);
        elementClassMap.put("Message", Message.class);
        elementClassMap.put("MediaItem", MediaItem.class);
        elementClassMap.put("Name", Name.class);
        elementClassMap.put("Organization", Organization.class);
        elementClassMap.put("person", Person.class);
        elementClassMap.put("Url", Url.class);
        elementClassMap.put("ListField", ListField.class);
        log = LogFactory.getLog(BeanXStreamConverter.class);
    }
}

