/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.util.xstream;

import com.google.inject.ImplementedBy;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shindig.social.core.util.xstream.ClassFieldMapping;
import org.apache.shindig.social.core.util.xstream.WriterStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceClassMapper
extends MapperWrapper {
    private static final Log log = LogFactory.getLog(InterfaceClassMapper.class);
    private Map<String, Class<?>> elementClassMap = new HashMap();
    private ThreadLocal<Class<?>> firstChild = new ThreadLocal();
    private Map<String, Class<?>[]> omitMap;
    private List<ClassFieldMapping> elementMappingList;
    private List<ClassFieldMapping> listElementMappingList;
    private WriterStack writerStack;

    public InterfaceClassMapper(WriterStack writerStack, Mapper wrapped, List<ClassFieldMapping> elementMappingList, List<ClassFieldMapping> listElementMappingList, Map<String, Class<?>[]> omitMap, Map<String, Class<?>> elementClassMap) {
        super(wrapped);
        this.elementClassMap = elementClassMap;
        this.elementMappingList = elementMappingList;
        this.listElementMappingList = listElementMappingList;
        this.omitMap = omitMap;
        this.writerStack = writerStack;
    }

    public void setBaseObject(Object base) {
        this.firstChild.set(null);
        if (Collection.class.isAssignableFrom(base.getClass())) {
            Collection c = (Collection)base;
            Class<?> clazz = null;
            for (Object o : c) {
                if (clazz == null) {
                    clazz = o.getClass();
                    continue;
                }
                if (clazz.equals(o.getClass())) continue;
                clazz = null;
                break;
            }
            this.firstChild.set(clazz);
            if (log.isDebugEnabled()) {
                log.debug((Object)("First Child set to " + clazz));
            }
        }
    }

    public String serializedClass(Class type) {
        String parentElementName = this.writerStack.peek();
        if (Collection.class.isAssignableFrom(type) && this.firstChild.get() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Converting Child to " + this.firstChild.get()));
            }
            type = this.firstChild.get();
            this.firstChild.set(null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("serializedClass(" + type + ") is a collection member " + Collection.class.isAssignableFrom(type)));
            }
            for (ClassFieldMapping cfm : this.listElementMappingList) {
                if (!cfm.matches(parentElementName, type)) continue;
                return cfm.getElementName();
            }
            return "list.container";
        }
        this.firstChild.set(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)("serializedClass(" + type + ")"));
        }
        for (ClassFieldMapping cfm : this.elementMappingList) {
            if (!cfm.matches(parentElementName, type)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("From MAP serializedClass(" + type + ")  ==" + cfm.getElementName()));
            }
            return cfm.getElementName();
        }
        String fieldName = super.serializedClass(type);
        if (log.isDebugEnabled()) {
            log.debug((Object)("--- From Super serializedClass(" + type + ")  ==" + fieldName));
        }
        return fieldName;
    }

    public boolean shouldSerializeMember(Class definedIn, String fieldName) {
        Class<?>[] omitList = this.omitMap.get(fieldName);
        if (omitList != null) {
            for (Class<?> omit : omitList) {
                if (!omit.isAssignableFrom(definedIn)) continue;
                return false;
            }
        }
        return super.shouldSerializeMember(definedIn, fieldName);
    }

    public Class realClass(String elementName) {
        Class<?> clazz = this.elementClassMap.get(elementName);
        if (clazz == null) {
            clazz = super.realClass(elementName);
        }
        clazz = this.getImplementation(clazz);
        return clazz;
    }

    private Class<?> getImplementation(Class<?> clazz) {
        Class cl = clazz;
        ImplementedBy implementedBy = clazz.getAnnotation(ImplementedBy.class);
        if (implementedBy != null) {
            Class c = implementedBy.value();
            if (log.isDebugEnabled()) {
                log.debug((Object)("===================Class " + clazz + " is implemented by " + c));
            }
            cl = c;
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("===================Class " + clazz + " no implementation, assume concrete "));
        }
        return cl;
    }

    public Class defaultImplementationOf(Class type) {
        Class<?> clazz = this.getImplementation(super.defaultImplementationOf(type));
        if (log.isDebugEnabled()) {
            log.debug((Object)("====defaultImplementationOf==Class " + type + " is " + clazz));
        }
        return clazz;
    }
}

