/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.util.xstream;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MapConverter
extends AbstractCollectionConverter {
    private static final Log log = LogFactory.getLog(MapConverter.class);
    private boolean shortform = false;

    public MapConverter(Mapper mapper) {
        super(mapper);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Map map = (Map)source;
        if (this.shortform) {
            for (Map.Entry e : map.entrySet()) {
                writer.startNode(String.valueOf(e.getKey()));
                context.convertAnother(e.getValue());
                writer.endNode();
            }
        } else {
            for (Map.Entry e : map.entrySet()) {
                writer.startNode("entry");
                writer.startNode("key");
                writer.setValue(String.valueOf(e.getKey()));
                writer.endNode();
                writer.startNode("value");
                context.convertAnother(e.getValue());
                writer.endNode();
                writer.endNode();
            }
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ConcurrentHashMap<String, Object> m = new ConcurrentHashMap<String, Object>();
        reader.moveDown();
        while (reader.hasMoreChildren()) {
            String key = reader.getNodeName();
            if ("entry".equals(key)) {
                Object value = null;
                reader.moveDown();
                String type = reader.getNodeName();
                if ("key".equals(type)) {
                    key = reader.getValue();
                } else {
                    value = reader.hasMoreChildren() ? this.readItem(reader, context, m) : reader.getValue();
                }
                reader.moveUp();
                reader.moveDown();
                type = reader.getNodeName();
                if ("key".equals(type)) {
                    key = reader.getValue();
                } else {
                    value = reader.hasMoreChildren() ? this.readItem(reader, context, m) : reader.getValue();
                }
                m.put(key, value);
                reader.moveUp();
                continue;
            }
            reader.moveDown();
            if (reader.hasMoreChildren()) {
                m.put(key, this.readItem(reader, context, m));
            } else {
                m.put(key, reader.getValue());
            }
            reader.moveUp();
        }
        reader.moveUp();
        return m;
    }

    public boolean canConvert(Class clazz) {
        boolean convert = Map.class.isAssignableFrom(clazz);
        if (log.isDebugEnabled()) {
            // empty if block
        }
        return convert;
    }
}

