/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.social.opensocial.service.ApiServlet;
import org.apache.shindig.social.opensocial.service.BeanConverter;
import org.apache.shindig.social.opensocial.service.ResponseItem;
import org.apache.shindig.social.opensocial.service.RestfulRequestItem;
import org.apache.shindig.social.opensocial.spi.DataCollection;
import org.apache.shindig.social.opensocial.spi.RestfulCollection;

public class DataServiceServlet
extends ApiServlet {
    protected static final String FORMAT_PARAM = "format";
    protected static final String ATOM_FORMAT = "atom";
    protected static final String XML_FORMAT = "xml";
    public static final String PEOPLE_ROUTE = "people";
    public static final String ACTIVITY_ROUTE = "activities";
    public static final String APPDATA_ROUTE = "appdata";
    private static final Logger logger = Logger.getLogger("org.apache.shindig.social.opensocial.spi");

    protected void doGet(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        this.doPost(servletRequest, servletResponse);
    }

    protected void doPut(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        this.doPost(servletRequest, servletResponse);
    }

    protected void doDelete(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        this.doPost(servletRequest, servletResponse);
    }

    protected void doPost(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        logger.finest("Handling restful request for " + servletRequest.getPathInfo());
        this.setCharacterEncodings(servletRequest, servletResponse);
        SecurityToken token = this.getSecurityToken(servletRequest);
        if (token == null) {
            this.sendSecurityError(servletResponse);
            return;
        }
        BeanConverter converter = this.getConverterForRequest(servletRequest);
        this.handleSingleRequest(servletRequest, servletResponse, token, converter);
    }

    protected void sendError(HttpServletResponse servletResponse, ResponseItem responseItem) throws IOException {
        servletResponse.sendError(responseItem.getError().getHttpErrorCode(), responseItem.getErrorMessage());
    }

    private void handleSingleRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse, SecurityToken token, BeanConverter converter) throws IOException {
        RestfulRequestItem requestItem = new RestfulRequestItem(servletRequest, token, converter);
        ResponseItem responseItem = this.getResponseItem(this.handleRequestItem(requestItem, servletRequest));
        if (responseItem.getError() == null) {
            PrintWriter writer = servletResponse.getWriter();
            Object response = responseItem.getResponse();
            if (!(response instanceof DataCollection) && !(response instanceof RestfulCollection)) {
                response = Maps.immutableMap((Object)"entry", (Object)response);
            }
            writer.write(converter.convertToString(response));
        } else {
            this.sendError(servletResponse, responseItem);
        }
    }

    BeanConverter getConverterForRequest(HttpServletRequest servletRequest) {
        String formatString = servletRequest.getParameter(FORMAT_PARAM);
        if (ATOM_FORMAT.equals(formatString)) {
            return this.atomConverter;
        }
        if (XML_FORMAT.equals(formatString)) {
            return this.xmlConverter;
        }
        return this.jsonConverter;
    }
}

