/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.shindig.social.ResponseError;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.service.DataRequestHandler;
import org.apache.shindig.social.opensocial.service.RequestItem;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.PersonService;
import org.apache.shindig.social.opensocial.spi.SocialSpiException;
import org.apache.shindig.social.opensocial.spi.UserId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersonHandler
extends DataRequestHandler {
    private final PersonService personService;
    private static final String PEOPLE_PATH = "/people/{userId}+/{groupId}/{personId}+";

    @Inject
    public PersonHandler(PersonService personService) {
        this.personService = personService;
    }

    @Override
    protected Future<?> handleDelete(RequestItem request) throws SocialSpiException {
        throw new SocialSpiException(ResponseError.BAD_REQUEST, "You can't delete people.");
    }

    @Override
    protected Future<?> handlePut(RequestItem request) throws SocialSpiException {
        throw new SocialSpiException(ResponseError.NOT_IMPLEMENTED, "You can't update right now.");
    }

    @Override
    protected Future<?> handlePost(RequestItem request) throws SocialSpiException {
        throw new SocialSpiException(ResponseError.NOT_IMPLEMENTED, "You can't add people right now.");
    }

    @Override
    protected Future<?> handleGet(RequestItem request) throws SocialSpiException {
        request.applyUrlTemplate(PEOPLE_PATH);
        GroupId groupId = request.getGroup();
        LinkedHashSet optionalPersonId = Sets.newLinkedHashSet(request.getListParameter("personId"));
        Set<String> fields = request.getFields(Person.Field.DEFAULT_FIELDS);
        Set<UserId> userIds = request.getUsers();
        DataRequestHandler.Preconditions.requireNotEmpty(userIds, "No userId specified");
        if (userIds.size() > 1 && !optionalPersonId.isEmpty()) {
            throw new IllegalArgumentException("Cannot fetch personIds for multiple userIds");
        }
        CollectionOptions options = new CollectionOptions();
        options.setSortBy(request.getSortBy());
        options.setSortOrder(request.getSortOrder());
        options.setFilter(request.getFilterBy());
        options.setFilterOperation(request.getFilterOperation());
        options.setFilterValue(request.getFilterValue());
        options.setFirst(request.getStartIndex());
        options.setMax(request.getCount());
        if (userIds.size() == 1) {
            if (optionalPersonId.isEmpty()) {
                if (groupId.getType() == GroupId.Type.self) {
                    return this.personService.getPerson(userIds.iterator().next(), fields, request.getToken());
                }
                return this.personService.getPeople(userIds, groupId, options, fields, request.getToken());
            }
            if (optionalPersonId.size() == 1) {
                return this.personService.getPerson(new UserId(UserId.Type.userId, (String)optionalPersonId.iterator().next()), fields, request.getToken());
            }
            LinkedHashSet personIds = Sets.newLinkedHashSet();
            for (String pid : optionalPersonId) {
                personIds.add(new UserId(UserId.Type.userId, pid));
            }
            return this.personService.getPeople(personIds, new GroupId(GroupId.Type.self, null), options, fields, request.getToken());
        }
        return this.personService.getPeople(userIds, groupId, options, fields, request.getToken());
    }
}

