/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.social.ResponseError;
import org.apache.shindig.social.opensocial.service.BeanConverter;
import org.apache.shindig.social.opensocial.service.RequestItem;
import org.apache.shindig.social.opensocial.spi.SocialSpiException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RpcRequestItem
extends RequestItem {
    private JSONObject data;

    static String getService(String rpcMethod) {
        return rpcMethod.substring(0, rpcMethod.indexOf(46));
    }

    static String getOperation(String rpcMethod) {
        return rpcMethod.substring(rpcMethod.indexOf(46) + 1);
    }

    public RpcRequestItem(JSONObject rpc, SecurityToken token, BeanConverter converter) throws JSONException {
        super(RpcRequestItem.getService(rpc.getString("method")), RpcRequestItem.getOperation(rpc.getString("method")), token, converter);
        this.data = rpc.has("params") ? rpc.getJSONObject("params") : new JSONObject();
    }

    @Override
    public String getParameter(String paramName) {
        try {
            if (this.data.has(paramName)) {
                return this.data.getString(paramName);
            }
            return null;
        }
        catch (JSONException je) {
            throw new SocialSpiException(ResponseError.BAD_REQUEST, je.getMessage(), je);
        }
    }

    @Override
    public String getParameter(String paramName, String defaultValue) {
        try {
            if (this.data.has(paramName)) {
                return this.data.getString(paramName);
            }
            return defaultValue;
        }
        catch (JSONException je) {
            throw new SocialSpiException(ResponseError.BAD_REQUEST, je.getMessage(), je);
        }
    }

    @Override
    public List<String> getListParameter(String paramName) {
        try {
            if (this.data.has(paramName)) {
                if (this.data.get(paramName) instanceof JSONArray) {
                    JSONArray jsonArray = this.data.getJSONArray(paramName);
                    ArrayList returnVal = Lists.newArrayListWithExpectedSize((int)jsonArray.length());
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        returnVal.add(jsonArray.getString(i));
                    }
                    return returnVal;
                }
                return Lists.newArrayList((Object[])new String[]{this.data.getString(paramName)});
            }
            return Collections.emptyList();
        }
        catch (JSONException je) {
            throw new SocialSpiException(ResponseError.BAD_REQUEST, je.getMessage(), je);
        }
    }

    @Override
    public <T> T getTypedParameter(String parameterName, Class<T> dataTypeClass) {
        try {
            return this.converter.convertToObject(this.data.get(parameterName).toString(), dataTypeClass);
        }
        catch (JSONException je) {
            throw new SocialSpiException(ResponseError.BAD_REQUEST, je.getMessage(), je);
        }
    }

    @Override
    public <T> T getTypedParameters(Class<T> dataTypeClass) {
        return this.converter.convertToObject(this.data.toString(), dataTypeClass);
    }

    @Override
    public void applyUrlTemplate(String urlTemplate) {
    }

    void setParameter(String paramName, String param) {
        try {
            this.data.put(paramName, (Object)param);
        }
        catch (JSONException je) {
            throw new IllegalArgumentException(je);
        }
    }

    void setJsonParameter(String paramName, JSONObject param) {
        try {
            this.data.put(paramName, (Object)param);
        }
        catch (JSONException je) {
            throw new IllegalArgumentException(je);
        }
    }

    void setListParameter(String paramName, List<String> params) {
        try {
            JSONArray arr = new JSONArray(params);
            this.data.put(paramName, (Object)arr);
        }
        catch (JSONException je) {
            throw new IllegalArgumentException(je);
        }
    }
}

