/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.dataservice.integration;

import org.apache.shindig.social.core.model.ActivityImpl;
import org.apache.shindig.social.dataservice.integration.AbstractLargeRestfulTests;
import org.apache.shindig.social.opensocial.model.Activity;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Test;

public class RestfulJsonActivityTest
extends AbstractLargeRestfulTests {
    Activity johnsActivity;

    protected void setUp() throws Exception {
        super.setUp();
        this.johnsActivity = new ActivityImpl("1", "john.doe");
        this.johnsActivity.setTitle("yellow");
        this.johnsActivity.setBody("what a color!");
    }

    @Test
    public void testGetActivityJson() throws Exception {
        String resp = this.getResponse("/activities/john.doe/@self/@app/1", "GET", null, "application/json");
        JSONObject result = this.getJson(resp);
        this.assertActivitiesEqual(this.johnsActivity, result.getJSONObject("entry"));
    }

    @Test
    public void testGetActivitiesJson() throws Exception {
        String resp = this.getResponse("/activities/john.doe/@self", "GET", null, "application/json");
        JSONObject result = this.getJson(resp);
        RestfulJsonActivityTest.assertEquals((int)1, (int)result.getInt("totalResults"));
        RestfulJsonActivityTest.assertEquals((int)0, (int)result.getInt("startIndex"));
        this.assertActivitiesEqual(this.johnsActivity, result.getJSONArray("entry").getJSONObject(0));
    }

    @Test
    public void testGetFriendsActivitiesJson() throws Exception {
        String resp = this.getResponse("/activities/john.doe/@friends", "GET", null, "application/json");
        JSONObject result = this.getJson(resp);
        RestfulJsonActivityTest.assertEquals((int)2, (int)result.getInt("totalResults"));
        RestfulJsonActivityTest.assertEquals((int)0, (int)result.getInt("startIndex"));
    }

    private void assertActivitiesEqual(Activity activity, JSONObject result) throws JSONException {
        RestfulJsonActivityTest.assertEquals((String)activity.getId(), (String)result.getString("id"));
        RestfulJsonActivityTest.assertEquals((String)activity.getUserId(), (String)result.getString("userId"));
        RestfulJsonActivityTest.assertEquals((String)activity.getTitle(), (String)result.getString("title"));
        RestfulJsonActivityTest.assertEquals((String)activity.getBody(), (String)result.getString("body"));
    }

    @Test
    public void testCreateActivity() throws Exception {
        String postData = "{title : 'hi mom!', body : 'and dad.'}";
        this.getResponse("/activities/john.doe/@self", "POST", postData, null, "application/json");
        String resp = this.getResponse("/activities/john.doe/@self", "GET", null, "application/json");
        JSONObject result = this.getJson(resp);
        RestfulJsonActivityTest.assertEquals((int)2, (int)result.getInt("totalResults"));
        RestfulJsonActivityTest.assertEquals((int)0, (int)result.getInt("startIndex"));
        JSONArray activities = result.getJSONArray("entry");
        int newActivityIndex = 0;
        if (activities.getJSONObject(0).has("id")) {
            newActivityIndex = 1;
        }
        JSONObject jsonActivity = activities.getJSONObject(newActivityIndex);
        RestfulJsonActivityTest.assertEquals((String)"hi mom!", (String)jsonActivity.getString("title"));
        RestfulJsonActivityTest.assertEquals((String)"and dad.", (String)jsonActivity.getString("body"));
    }
}

