/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import junit.framework.TestCase;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.xml.XmlException;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.protocol.conversion.xstream.XStreamConfiguration;
import org.apache.shindig.social.SocialApiTestsGuiceModule;
import org.apache.shindig.social.core.model.ActivityImpl;
import org.apache.shindig.social.core.model.AddressImpl;
import org.apache.shindig.social.core.model.ListFieldImpl;
import org.apache.shindig.social.core.model.MediaItemImpl;
import org.apache.shindig.social.core.model.NameImpl;
import org.apache.shindig.social.core.model.PersonImpl;
import org.apache.shindig.social.core.util.BeanXStreamAtomConverter;
import org.apache.shindig.social.core.util.xstream.XStream081Configuration;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.model.Address;
import org.apache.shindig.social.opensocial.model.ListField;
import org.apache.shindig.social.opensocial.model.MediaItem;
import org.apache.shindig.social.opensocial.model.Name;
import org.apache.shindig.social.opensocial.model.Person;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BeanXStreamAtomConverterTest
extends TestCase {
    private Person johnDoe;
    private Activity activity;
    private BeanXStreamAtomConverter beanXmlConverter;

    public void setUp() throws Exception {
        super.setUp();
        Injector injector = Guice.createInjector((Module[])new Module[]{new SocialApiTestsGuiceModule()});
        this.johnDoe = new PersonImpl("johnDoeId", "Johnny", (Name)new NameImpl("John Doe"));
        this.johnDoe.setPhoneNumbers((List)Lists.newArrayList((Object[])new ListField[]{new ListFieldImpl("home", "+33H000000000"), new ListFieldImpl("mobile", "+33M000000000"), new ListFieldImpl("work", "+33W000000000")}));
        this.johnDoe.setAddresses((List)Lists.newArrayList((Object[])new Address[]{new AddressImpl("My home address")}));
        this.johnDoe.setEmails((List)Lists.newArrayList((Object[])new ListField[]{new ListFieldImpl("work", "john.doe@work.bar"), new ListFieldImpl("home", "john.doe@home.bar")}));
        this.activity = new ActivityImpl("activityId", this.johnDoe.getId());
        this.activity.setMediaItems((List)Lists.newArrayList((Object[])new MediaItem[]{new MediaItemImpl("image/jpg", MediaItem.Type.IMAGE, "http://foo.bar")}));
        this.activity.setUrl("http://foo.com");
        this.beanXmlConverter = new BeanXStreamAtomConverter((XStreamConfiguration)new XStream081Configuration(injector));
    }

    public void testToXmlOnSimpleClass() throws Exception {
        SimplePerson cassie = new SimplePerson("5", "robot");
        String xml = this.beanXmlConverter.convertToString((Object)cassie);
        Element element = XmlUtil.parse((String)xml);
        Node id = element.getElementsByTagName("id").item(0);
        Node name = element.getElementsByTagName("name").item(0);
        BeanXStreamAtomConverterTest.assertEquals((String)"5", (String)id.getTextContent());
        BeanXStreamAtomConverterTest.assertEquals((String)"robot", (String)name.getTextContent());
    }

    public void testPersonToXml() throws Exception {
        String xml = this.beanXmlConverter.convertToString((Object)this.johnDoe);
        Element element = XmlUtil.parse((String)xml);
        Node id = element.getElementsByTagName("id").item(0);
        BeanXStreamAtomConverterTest.assertEquals((String)("urn:guid:" + this.johnDoe.getId()), (String)id.getTextContent());
    }

    public void testActivityToXml() throws Exception {
        String xml = this.beanXmlConverter.convertToString((Object)this.activity);
        Element element = XmlUtil.parse((String)xml);
        Node id = element.getElementsByTagName("id").item(0);
        BeanXStreamAtomConverterTest.assertEquals((String)this.activity.getId(), (String)id.getTextContent());
    }

    public void testMapsToXml() throws Exception {
        TreeMap map = Maps.newTreeMap();
        HashMap item1Map = Maps.newHashMap();
        item1Map.put("value", "1");
        map.put("item1", item1Map);
        HashMap item2Map = Maps.newHashMap();
        item2Map.put("value", "2");
        map.put("item2", item2Map);
        String xml = this.beanXmlConverter.convertToString((Object)map);
        XmlUtil.parse((String)xml);
        String expectedXml = "<feed xmlns=\"http://www.w3.org/2005/Atom\" xmlns:osearch=\"http://a9.com/-/spec/opensearch/1.1\" >  <entry><id>item1</id>    <content type=\"application/xml\" ><entry><key>value</key><value>1</value></entry></content> </entry>  <entry><id>item2</id>     <content type=\"application/xml\" ><entry><key>value</key><value>2</value></entry></content> </entry>  <osearch:startIndex>0</osearch:startIndex>  <osearch:totalResults>2</osearch:totalResults>  <osearch:itemsPerPage>2</osearch:itemsPerPage></feed> ";
        BeanXStreamAtomConverterTest.assertEquals((String)StringUtils.deleteWhitespace((String)expectedXml), (String)StringUtils.deleteWhitespace((String)xml));
    }

    public void testMapToXml() throws XmlException {
        LinkedHashMap m = Maps.newLinkedHashMap();
        m.put("key1", "value1");
        m.put("key2", "value2");
        String xml = this.beanXmlConverter.convertToString((Object)m);
        XmlUtil.parse((String)xml);
        String expectedXml = "<feed xmlns=\"http://www.w3.org/2005/Atom\"  xmlns:osearch=\"http://a9.com/-/spec/opensearch/1.1\">  <entry><id>key1</id><content type=\"application/xml\" >    <value>value1</value></content>  </entry>  <entry><id>key2</id>     <content type=\"application/xml\" ><value>value2</value></content>  </entry>  <osearch:startIndex>0</osearch:startIndex>  <osearch:totalResults>2</osearch:totalResults>  <osearch:itemsPerPage>2</osearch:itemsPerPage></feed>";
        BeanXStreamAtomConverterTest.assertEquals((String)StringUtils.deleteWhitespace((String)expectedXml), (String)StringUtils.deleteWhitespace((String)xml));
    }

    public void testEmptyList() throws XmlException {
        ArrayList empty = Lists.newArrayList();
        String xml = this.beanXmlConverter.convertToString((Object)empty);
        XmlUtil.parse((String)xml);
        String expectedXml = "<feed xmlns=\"http://www.w3.org/2005/Atom\" xmlns:osearch=\"http://a9.com/-/spec/opensearch/1.1\" ><entry><content/></entry><osearch:startIndex>0</osearch:startIndex><osearch:totalResults>1</osearch:totalResults><osearch:itemsPerPage>1</osearch:itemsPerPage></feed>";
        BeanXStreamAtomConverterTest.assertEquals((String)StringUtils.deleteWhitespace((String)expectedXml), (String)StringUtils.deleteWhitespace((String)xml));
        ArrayList emptyLists = Lists.newArrayList();
        ArrayList emptyList = Lists.newArrayList();
        emptyLists.add(emptyList);
        emptyLists.add(emptyList);
        emptyLists.add(emptyList);
        xml = this.beanXmlConverter.convertToString((Object)emptyLists);
        XmlUtil.parse((String)xml);
        expectedXml = "<feed xmlns=\"http://www.w3.org/2005/Atom\" xmlns:osearch=\"http://a9.com/-/spec/opensearch/1.1\" ><entry><content><list/><list/><list/></content></entry><osearch:startIndex>0</osearch:startIndex><osearch:totalResults>1</osearch:totalResults><osearch:itemsPerPage>1</osearch:itemsPerPage></feed>";
        BeanXStreamAtomConverterTest.assertEquals((String)StringUtils.deleteWhitespace((String)expectedXml), (String)StringUtils.deleteWhitespace((String)xml));
    }

    public void testElementNamesInList() throws XmlException {
        ArrayList activities = Lists.newArrayList();
        activities.add(this.activity);
        activities.add(this.activity);
        activities.add(this.activity);
        String xml = this.beanXmlConverter.convertToString((Object)activities);
        XmlUtil.parse((String)xml);
        String expectedXml = "<feed xmlns=\"http://www.w3.org/2005/Atom\"    xmlns:osearch=\"http://a9.com/-/spec/opensearch/1.1\"><entry><content>  <activity xmlns=\"http://ns.opensocial.org/2008/opensocial\">    <id>activityId</id>    <mediaItems>        <mimeType>image/jpg</mimeType>        <type>IMAGE</type>        <url>http://foo.bar</url>    </mediaItems>    <url>http://foo.com</url>    <userId>johnDoeId</userId>  </activity>  <activity xmlns=\"http://ns.opensocial.org/2008/opensocial\">    <id>activityId</id>    <mediaItems>        <mimeType>image/jpg</mimeType>        <type>IMAGE</type>        <url>http://foo.bar</url>    </mediaItems>    <url>http://foo.com</url>    <userId>johnDoeId</userId>  </activity>  <activity xmlns=\"http://ns.opensocial.org/2008/opensocial\">    <id>activityId</id>    <mediaItems>        <mimeType>image/jpg</mimeType>        <type>IMAGE</type>        <url>http://foo.bar</url>    </mediaItems>    <url>http://foo.com</url>    <userId>johnDoeId</userId>  </activity></content></entry><osearch:startIndex>0</osearch:startIndex><osearch:totalResults>1</osearch:totalResults><osearch:itemsPerPage>1</osearch:itemsPerPage></feed>";
        BeanXStreamAtomConverterTest.assertEquals((String)StringUtils.deleteWhitespace((String)expectedXml), (String)StringUtils.deleteWhitespace((String)xml));
    }

    public static class SimplePerson {
        private String id;
        private String name;

        public SimplePerson(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

