/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.reporting.web.gauge;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.codec.binary.Base64;
import org.apache.sirona.Role;
import org.apache.sirona.reporting.web.gauge.GaugeInfo;
import org.apache.sirona.reporting.web.gauge.GaugeResult;
import org.apache.sirona.reporting.web.gauge.GaugeValue;
import org.apache.sirona.repositories.Repository;

@Path(value="/gauges")
public class GaugeService {
    private static final String UTF8 = "UTF-8";

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Collection<GaugeInfo> all() {
        return GaugeService.sortNames(Repository.INSTANCE.gauges());
    }

    @GET
    @Path(value="/{gaugeName}/{start}/{end}")
    @Produces(value={"application/json", "application/xml"})
    public GaugeResult find(@PathParam(value="gaugeName") String encodedGaugeName, @PathParam(value="start") long start, @PathParam(value="end") long end) {
        String gaugeName = GaugeService.decode(encodedGaugeName);
        Role role = Repository.INSTANCE.findGaugeRole(gaugeName);
        if (role == null) {
            return null;
        }
        SortedMap values = Repository.INSTANCE.getGaugeValues(start, end, role);
        ArrayList<GaugeValue> gaugeValues = new ArrayList<GaugeValue>(values.size());
        for (Map.Entry entry : values.entrySet()) {
            gaugeValues.add(new GaugeValue((Long)entry.getKey(), (Double)entry.getValue()));
        }
        return new GaugeResult(gaugeName, gaugeValues);
    }

    private static Collection<GaugeInfo> sortNames(Collection<Role> gauges) {
        TreeMap<String, String> names = new TreeMap<String, String>();
        for (Role gauge : gauges) {
            String name = gauge.getName();
            names.put(name, GaugeService.encode(name));
        }
        ArrayList<GaugeInfo> out = new ArrayList<GaugeInfo>(names.size());
        for (Map.Entry entry : names.entrySet()) {
            out.add(new GaugeInfo((String)entry.getKey(), (String)entry.getValue()));
        }
        return out;
    }

    private static String encode(String role) {
        String base64 = Base64.encodeBase64URLSafeString((byte[])role.getBytes());
        try {
            return URLEncoder.encode(base64, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            return role;
        }
    }

    private static String decode(String base64Role) {
        try {
            return new String(Base64.decodeBase64((String)URLDecoder.decode(base64Role, UTF8)));
        }
        catch (UnsupportedEncodingException e) {
            return base64Role;
        }
    }
}

