/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.reporting.web.jmx;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringEscapeUtils;

public class JMXNode
implements Serializable {
    private final String name;
    private final String label;
    private final Map<Key, JMXNode> children = new TreeMap<Key, JMXNode>();
    private String base64 = null;

    public JMXNode(String name) {
        this.name = name;
        this.label = name;
    }

    public static void addNode(JMXNode rootNode, String domain, String props) {
        TreeMap<String, String> properties = new TreeMap<String, String>(new JMXPropertiesComparator(props));
        for (String k : props.split(",")) {
            String[] kv = k.split("=");
            if (kv.length < 2) {
                properties.put(StringEscapeUtils.escapeHtml4((String)kv[0]), "");
                continue;
            }
            properties.put(StringEscapeUtils.escapeHtml4((String)kv[0]), StringEscapeUtils.escapeHtml4((String)kv[1]));
        }
        Key rootKey = new Key("domain", domain);
        JMXNode node = rootNode.children.get(rootKey);
        if (node == null) {
            node = new JMXNode(domain);
            rootNode.children.put(rootKey, node);
        }
        for (Map.Entry entry : properties.entrySet()) {
            Key key = new Key((String)entry.getKey(), (String)entry.getValue());
            String value = (String)entry.getValue();
            JMXNode child = node.children.get(key);
            if (child == null) {
                child = new JMXNode(value);
                node.children.put(key, child);
            }
            node = child;
        }
        node.base64 = Base64.encodeBase64URLSafeString((byte[])(domain + ":" + props).getBytes());
    }

    public String getName() {
        return this.name;
    }

    public boolean isLeaf() {
        return this.base64 != null;
    }

    public String getBase64() {
        return this.base64;
    }

    public String getLabel() {
        return this.label;
    }

    public Collection<JMXNode> getChildren() {
        return Collections.unmodifiableCollection(this.children.values());
    }

    protected static class JMXPropertiesComparator
    implements Comparator<String> {
        private final String properties;

        protected JMXPropertiesComparator(String props) {
            this.properties = props;
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            if ("type".equals(o1)) {
                return -1;
            }
            if ("type".equals(o2)) {
                return 1;
            }
            if ("j2eeType".equals(o1)) {
                return -1;
            }
            if ("j2eeType".equals(o2)) {
                return 1;
            }
            return this.properties.indexOf(o1 + "=") - this.properties.indexOf(o2 + "=");
        }
    }

    protected static class Key
    implements Comparable<Key>,
    Serializable {
        private final String key;
        private final String value;

        public Key(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || Key.class != o.getClass()) {
                return false;
            }
            Key key1 = (Key)Key.class.cast(o);
            return this.key.equals(key1.key) && this.value.equals(key1.value);
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }

        @Override
        public int compareTo(Key o) {
            if (this.equals(o)) {
                return 0;
            }
            int keys = this.key.compareTo(o.key);
            if (keys != 0) {
                return keys;
            }
            return this.value.compareTo(o.value);
        }

        public String toString() {
            return "{" + this.key + " = " + this.value + '}';
        }
    }
}

