/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.reporting.web.jta;

import java.util.SortedMap;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.sirona.Role;
import org.apache.sirona.counters.Unit;
import org.apache.sirona.reporting.web.Graph;
import org.apache.sirona.repositories.Repository;

@Path(value="/jtareports")
public class JTAReports {
    private static final Role COMMITED = new Role("jta-commited", Unit.UNARY);
    private static final Role ROLLBACKED = new Role("jta-rollbacked", Unit.UNARY);
    private static final Role ACTIVE = new Role("jta-active", Unit.UNARY);

    @GET
    @Path(value="/commits/{start}/{end}")
    @Produces(value={"application/json", "application/xml"})
    public Graph commit(@PathParam(value="start") long start, @PathParam(value="end") long end) {
        SortedMap gaugeValues = Repository.INSTANCE.getGaugeValues(start, end, COMMITED);
        return new Graph("Commits", "#317eac", gaugeValues);
    }

    @GET
    @Path(value="/rollbacks/{start}/{end}")
    @Produces(value={"application/json", "application/xml"})
    public Graph rollback(@PathParam(value="start") long start, @PathParam(value="end") long end) {
        SortedMap gaugeValues = Repository.INSTANCE.getGaugeValues(start, end, ROLLBACKED);
        return new Graph("Rollbacks", "#317eac", gaugeValues);
    }

    @GET
    @Path(value="/actives/{start}/{end}")
    @Produces(value={"application/json", "application/xml"})
    public Graph active(@PathParam(value="start") long start, @PathParam(value="end") long end) {
        SortedMap gaugeValues = Repository.INSTANCE.getGaugeValues(start, end, ACTIVE);
        return new Graph("Actives", "#317eac", gaugeValues);
    }
}

