/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.reporting.web.status;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.sirona.reporting.web.status.StatusHelper;
import org.apache.sirona.reporting.web.status.ValidationResultInfo;
import org.apache.sirona.status.NodeStatus;
import org.apache.sirona.status.ValidationResult;

public class NodeStatusInfo
implements Serializable {
    private final String name;
    private final List<ValidationResultInfo> results;
    private final Date date;
    private final String status;
    private final String statusLabel;

    public NodeStatusInfo(String name, NodeStatus nodeStatus) {
        this.name = name;
        this.date = nodeStatus.getDate();
        this.status = nodeStatus.getStatus().toString();
        this.statusLabel = StatusHelper.map(nodeStatus.getStatus());
        if (nodeStatus.getResults() != null) {
            this.results = new ArrayList<ValidationResultInfo>(nodeStatus.getResults().length);
            for (ValidationResult validationResult : nodeStatus.getResults()) {
                this.results.add(new ValidationResultInfo(validationResult.getStatus().toString(), StatusHelper.map(validationResult.getStatus()), validationResult.getMessage(), validationResult.getName()));
            }
        } else {
            this.results = new ArrayList<ValidationResultInfo>(0);
        }
    }

    public List<ValidationResultInfo> getResults() {
        return this.results;
    }

    public Date getDate() {
        return this.date;
    }

    public String getStatus() {
        return this.status;
    }

    public String getStatusLabel() {
        return this.statusLabel;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "NodeStatusInfo{name='" + this.name + '\'' + ", results=" + this.results + ", date=" + this.date + ", status='" + this.status + '\'' + '}';
    }
}

