/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport;

import java.io.File;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.sling.maven.bundlesupport.AbstractBundlePostMojo;

abstract class AbstractFsMountMojo
extends AbstractBundlePostMojo {
    @Parameter(property="sling.file", defaultValue="${project.build.directory}/${project.build.finalName}.jar", required=true)
    private String bundleFileName;
    @Parameter(property="sling.filevault.jcr_root.file")
    private File fileVaultJcrRootFile;
    @Parameter(property="sling.filevault.filterxml.file")
    private File fileVaultFilterXmlFile;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;

    AbstractFsMountMojo() {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        String targetUrl = this.getConsoleTargetURL();
        this.ensureBundlesInstalled(targetUrl);
        File bundleFile = new File(this.bundleFileName);
        if (bundleFile.exists()) {
            this.configureSlingInitialContent(targetUrl, bundleFile);
            return;
        }
        File jcrRootFile = this.fileVaultJcrRootFile != null ? this.fileVaultJcrRootFile : this.detectJcrRootFile();
        File filterXmlFile = this.fileVaultFilterXmlFile != null ? this.fileVaultFilterXmlFile : this.detectFilterXmlFile();
        if (jcrRootFile != null && jcrRootFile.exists() && filterXmlFile != null && filterXmlFile.exists()) {
            this.configureFileVaultXml(targetUrl, jcrRootFile, filterXmlFile);
            return;
        }
        this.getLog().info((CharSequence)"No Bundle with initial content or FileVault content package found - skipping.");
    }

    private File detectJcrRootFile() {
        List resources = this.project.getResources();
        if (resources != null) {
            for (Resource resource : resources) {
                File dir = new File(resource.getDirectory());
                if (!dir.exists() || !dir.isDirectory() || !StringUtils.equals((CharSequence)dir.getName(), (CharSequence)"jcr_root")) continue;
                return dir;
            }
        }
        return null;
    }

    private File detectFilterXmlFile() {
        List resources = this.project.getResources();
        if (resources != null) {
            for (Resource resource : resources) {
                File filterXml;
                File dir = new File(resource.getDirectory());
                if (!dir.exists() || !dir.isDirectory() || !(StringUtils.equals((CharSequence)dir.getName(), (CharSequence)"META-INF") ? (filterXml = new File(dir, "vault/filter.xml")).exists() : (StringUtils.equals((CharSequence)dir.getName(), (CharSequence)"vault") ? (filterXml = new File(dir, "filter.xml")).exists() : StringUtils.equals((CharSequence)dir.getName(), (CharSequence)"jcr_root") && (filterXml = new File(dir.getParentFile(), "META-INF/vault/filter.xml")).exists()))) continue;
                return filterXml;
            }
        }
        return null;
    }

    protected abstract void configureSlingInitialContent(String var1, File var2) throws MojoExecutionException;

    protected abstract void configureFileVaultXml(String var1, File var2, File var3) throws MojoExecutionException;

    protected abstract void ensureBundlesInstalled(String var1) throws MojoExecutionException;
}

