/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class BundlePrerequisite {
    private final List<Bundle> bundles = new ArrayList<Bundle>();
    private final List<Bundle> preconditions = new ArrayList<Bundle>();

    public void addBundle(Bundle bundle) {
        this.bundles.add(bundle);
    }

    public void addPrecondition(Bundle bundle) {
        this.preconditions.add(bundle);
    }

    public List<Bundle> getBundles() {
        return this.bundles;
    }

    public List<Bundle> getPreconditions() {
        return this.preconditions;
    }

    public static final class Bundle {
        private String groupId;
        private String artifactId;
        private String version;
        private String symbolicName;

        public Bundle() {
        }

        public Bundle(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getSymbolicName() {
            return StringUtils.defaultString((String)this.symbolicName, (String)this.artifactId);
        }

        public void setSymbolicName(String symbolicName) {
            this.symbolicName = symbolicName;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }
    }
}

