/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resource.path;

public final class PathBuilder {
    private StringBuilder sb = new StringBuilder();

    public PathBuilder(String path) {
        if (path == null || path.isEmpty() || path.charAt(0) != '/') {
            throw new IllegalArgumentException("Path '" + path + "' is not absolute");
        }
        this.sb.append(path);
    }

    public PathBuilder append(String path) {
        boolean leadingSlash;
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("Path '" + path + "' is null or empty");
        }
        boolean trailingSlash = this.sb.charAt(this.sb.length() - 1) == '/';
        boolean bl = leadingSlash = path.charAt(0) == '/';
        if (trailingSlash && leadingSlash) {
            this.sb.append(path.substring(1));
        } else if (!trailingSlash && !leadingSlash) {
            this.sb.append('/').append(path);
        } else {
            this.sb.append(path);
        }
        return this;
    }

    public String toString() {
        return this.sb.toString();
    }
}

