/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.wrappers;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.sling.api.resource.ValueMap;

public class ValueMapDecorator
implements ValueMap {
    private final Map<String, Object> base;

    public ValueMapDecorator(Map<String, Object> base) {
        this.base = base;
    }

    @Override
    public <T> T get(String name, Class<T> type) {
        return this.convert(this.get(name), type);
    }

    private <T> T convert(Object obj, Class<T> type) {
        try {
            if (obj == null) {
                return null;
            }
            if (type.isAssignableFrom(obj.getClass())) {
                return (T)obj;
            }
            if (type.isArray()) {
                return (T)this.convertToArray(obj, type.getComponentType());
            }
            if (type == String.class) {
                return (T)String.valueOf(this.getSingleValue(obj));
            }
            if (type == Integer.class) {
                return (T)Integer.valueOf(Integer.parseInt(this.getSingleValue(obj)));
            }
            if (type == Long.class) {
                return (T)Long.valueOf(Long.parseLong(this.getSingleValue(obj)));
            }
            if (type == Double.class) {
                return (T)Double.valueOf(Double.parseDouble(this.getSingleValue(obj)));
            }
            if (type == Boolean.class) {
                return (T)Boolean.valueOf(Boolean.parseBoolean(this.getSingleValue(obj)));
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private String getSingleValue(Object obj) {
        Object[] values;
        String result = obj == null ? null : (obj.getClass().isArray() ? ((values = (Object[])obj)[0] != null ? values[0].toString() : null) : obj.toString());
        return result;
    }

    private <T> T[] convertToArray(Object obj, Class<T> type) {
        if (obj.getClass().isArray()) {
            Object[] array = (Object[])obj;
            ArrayList<T> resultList = new ArrayList<T>();
            for (int i = 0; i < array.length; ++i) {
                T singleValueResult = this.convert(array[i], type);
                if (singleValueResult == null) continue;
                resultList.add(singleValueResult);
            }
            if (resultList.isEmpty()) {
                return null;
            }
            return resultList.toArray((Object[])Array.newInstance(type, resultList.size()));
        }
        T singleValueResult = this.convert(obj, type);
        if (singleValueResult == null) {
            return null;
        }
        Object[] arrayResult = (Object[])Array.newInstance(type, 1);
        arrayResult[0] = singleValueResult;
        return arrayResult;
    }

    @Override
    public <T> T get(String name, T defaultValue) {
        if (defaultValue == null) {
            return (T)this.get(name);
        }
        Class<?> value = this.get(name, (T)defaultValue.getClass());
        return (T)(value == null ? defaultValue : value);
    }

    @Override
    public int size() {
        return this.base.size();
    }

    @Override
    public boolean isEmpty() {
        return this.base.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.base.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.base.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.base.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.base.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.base.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> t) {
        this.base.putAll(t);
    }

    @Override
    public void clear() {
        this.base.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.base.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.base.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.base.entrySet();
    }

    public String toString() {
        return super.toString() + " : " + this.base.toString();
    }

    @Override
    public int hashCode() {
        return this.base.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.base.equals(obj);
    }
}

