/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.classloader.impl;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.sling.commons.classloader.impl.DynamicClassLoaderManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderFacade
extends ClassLoader {
    private final DynamicClassLoaderManagerImpl manager;

    public ClassLoaderFacade(DynamicClassLoaderManagerImpl manager) {
        this.manager = manager;
    }

    @Override
    public URL getResource(String name) {
        ClassLoader[] loaders;
        if (!this.manager.isActive()) {
            throw new RuntimeException("Dynamic class loader has already been deactivated.");
        }
        for (ClassLoader cl : loaders = this.manager.getDynamicClassLoaders()) {
            URL u;
            if (cl == null || (u = cl.getResource(name)) == null) continue;
            return u;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ClassLoader[] loaders;
        if (!this.manager.isActive()) {
            throw new RuntimeException("Dynamic class loader has already been deactivated.");
        }
        for (ClassLoader cl : loaders = this.manager.getDynamicClassLoaders()) {
            Enumeration<URL> e;
            if (cl == null || (e = cl.getResources(name)) == null || !e.hasMoreElements()) continue;
            return e;
        }
        return null;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        ClassLoader[] loaders;
        if (!this.manager.isActive()) {
            throw new RuntimeException("Dynamic class loader has already been deactivated.");
        }
        for (ClassLoader cl : loaders = this.manager.getDynamicClassLoaders()) {
            if (cl == null) continue;
            try {
                Class<?> c = cl.loadClass(name);
                return c;
            }
            catch (Exception cnfe) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException("Class not found: " + name);
    }
}

