/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.gaffer.GafferUtil;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.jul.LevelChangePropagator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggerContextAwareBase;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.classic.util.EnvUtil;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.GenericConfigurator;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.status.StatusListenerAsList;
import ch.qos.logback.core.status.StatusUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.LogManager;
import org.apache.sling.commons.log.logback.internal.AppenderTracker;
import org.apache.sling.commons.log.logback.internal.ConfigResetRequestHandler;
import org.apache.sling.commons.log.logback.internal.ConfigSourceTracker;
import org.apache.sling.commons.log.logback.internal.FilterTracker;
import org.apache.sling.commons.log.logback.internal.LogConfig;
import org.apache.sling.commons.log.logback.internal.LogConfigManager;
import org.apache.sling.commons.log.logback.internal.LogbackResetListener;
import org.apache.sling.commons.log.logback.internal.SlingConfigurationPrinter;
import org.apache.sling.commons.log.logback.internal.SlingLogPanel;
import org.apache.sling.commons.log.logback.internal.TurboFilterTracker;
import org.apache.sling.commons.log.logback.internal.util.SlingRollingFileAppender;
import org.apache.sling.commons.log.logback.internal.util.SlingStatusPrinter;
import org.apache.sling.commons.log.logback.webconsole.LogPanel;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class LogbackManager
extends LoggerContextAwareBase {
    private static final String JUL_SUPPORT = "org.apache.sling.commons.log.julenabled";
    private static final String PREFIX = "org.apache.sling.commons.log";
    private static final String DEBUG = "org.apache.sling.commons.log.debug";
    private static final String PRINTER_URL = "slinglogs";
    private static final String RESET_EVENT_TOPIC = "org/apache/sling/commons/log/RESET";
    private static final String SLING_LOG_ROOT = "sling.log.root";
    private final BundleContext bundleContext;
    private final String rootDir;
    private final String contextName = "sling";
    private final LogConfigManager logConfigManager;
    private final List<LogbackResetListener> resetListeners = new ArrayList<LogbackResetListener>();
    private final Logger log;
    private final LoggerContextListener osgiIntegrationListener = new OsgiIntegrationListener();
    private final boolean debug;
    private final boolean started;
    private final Semaphore resetLock = new Semaphore(1);
    private final Object configChangedFlagLock = new Object();
    private boolean configChanged = false;
    private final AppenderTracker appenderTracker;
    private final ConfigSourceTracker configSourceTracker;
    private final FilterTracker filterTracker;
    private final TurboFilterTracker turboFilterTracker;
    private final List<ServiceRegistration> registrations = new ArrayList<ServiceRegistration>();
    private final List<ServiceTracker> serviceTrackers = new ArrayList<ServiceTracker>();
    private final boolean bridgeHandlerInstalled;
    private volatile long resetStartTime;

    public LogbackManager(BundleContext bundleContext) throws InvalidSyntaxException {
        this.bundleContext = bundleContext;
        this.setLoggerContext((LoggerContext)LoggerFactory.getILoggerFactory());
        this.log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        this.rootDir = this.getRootDir(bundleContext);
        this.debug = Boolean.parseBoolean(bundleContext.getProperty(DEBUG));
        this.bridgeHandlerInstalled = LogbackManager.installSlf4jBridgeHandler(bundleContext);
        this.appenderTracker = new AppenderTracker(bundleContext, this.getLoggerContext());
        this.configSourceTracker = new ConfigSourceTracker(bundleContext, this);
        this.filterTracker = new FilterTracker(bundleContext, this);
        this.turboFilterTracker = new TurboFilterTracker(bundleContext, this.getLoggerContext());
        this.getLoggerContext().setName("sling");
        this.logConfigManager = new LogConfigManager(this.getLoggerContext(), bundleContext, this.rootDir, this);
        this.resetListeners.add(new LevelChangePropagatorChecker());
        this.resetListeners.add(this.logConfigManager);
        this.resetListeners.add(this.appenderTracker);
        this.resetListeners.add(this.configSourceTracker);
        this.resetListeners.add(this.filterTracker);
        this.resetListeners.add(this.turboFilterTracker);
        this.resetListeners.add(new RootLoggerListener());
        this.serviceTrackers.add(this.appenderTracker);
        this.serviceTrackers.add(this.configSourceTracker);
        this.serviceTrackers.add(this.filterTracker);
        this.serviceTrackers.add(this.turboFilterTracker);
        this.getLoggerContext().addListener(this.osgiIntegrationListener);
        this.registerWebConsoleSupport();
        this.registerEventHandler();
        this.addInfo("LogbackManager: BEGIN initial configuration");
        this.failSafeConfigure();
        this.addInfo("LogbackManager: END initialconfiguration");
        this.started = true;
    }

    public void shutdown() {
        if (this.bridgeHandlerInstalled) {
            SLF4JBridgeHandler.uninstall();
        }
        this.logConfigManager.close();
        for (ServiceTracker tracker : this.serviceTrackers) {
            tracker.close();
        }
        for (ServiceRegistration reg : this.registrations) {
            reg.unregister();
        }
        this.getLoggerContext().removeListener(this.osgiIntegrationListener);
        this.getLoggerContext().stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configChanged() {
        if (!this.started) {
            return;
        }
        Object object = this.configChangedFlagLock;
        synchronized (object) {
            if (this.resetLock.tryAcquire()) {
                this.configChanged = false;
                this.scheduleConfigReload();
            } else {
                this.configChanged = true;
                this.addInfo("LoggerContext reset in progress. Marking config changed to true");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescheduleIfConfigChanged() {
        Object object = this.configChangedFlagLock;
        synchronized (object) {
            if (this.configChanged && this.resetLock.tryAcquire()) {
                this.configChanged = false;
                this.scheduleConfigReload();
            }
        }
    }

    private void scheduleConfigReload() {
        this.getLoggerContext().getExecutorService().submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    LogbackManager.this.failSafeConfigure();
                }
                finally {
                    LogbackManager.this.resetLock.release();
                    LogbackManager.this.addInfo("Re configuration done");
                    LogbackManager.this.rescheduleIfConfigChanged();
                }
            }
        });
    }

    private void failSafeConfigure() {
        try {
            this.addInfo("Performing configuration");
            this.configure();
        }
        catch (Exception e) {
            this.log.warn("Error occurred while re-configuring logger", (Throwable)e);
            this.addError("Error occurred while re-configuring logger", e);
        }
    }

    public void fireResetCompleteListeners() {
        for (LogbackResetListener listener : this.resetListeners) {
            this.addInfo("Firing reset listener - onResetComplete " + listener.getClass());
            listener.onResetComplete(this.getLoggerContext());
        }
    }

    public LogConfigManager getLogConfigManager() {
        return this.logConfigManager;
    }

    public AppenderTracker getAppenderTracker() {
        return this.appenderTracker;
    }

    public ConfigSourceTracker getConfigSourceTracker() {
        return this.configSourceTracker;
    }

    public void addSubsitutionProperties(InterpretationContext ic) {
        ic.addSubstitutionProperty("sling.home", this.rootDir);
    }

    public URL getDefaultConfig() {
        return ((Object)((Object)this)).getClass().getClassLoader().getResource("logback-empty.xml");
    }

    public String getRootDir() {
        return this.rootDir;
    }

    private void configure() {
        ConfiguratorCallback cb = new DefaultCallback();
        File configFile = this.logConfigManager.getLogbackConfigFile();
        if (configFile != null) {
            cb = new FilenameConfiguratorCallback(configFile);
        }
        this.configure(cb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configure(ConfiguratorCallback cb) {
        long startTime = System.currentTimeMillis();
        StatusListenerAsList statusListener = new StatusListenerAsList();
        if (this.debug) {
            statusListener = new OnConsoleStatusListener();
        }
        this.getStatusManager().add((StatusListener)statusListener);
        this.addInfo("Resetting context: " + this.getLoggerContext().getName());
        this.resetContext((StatusListener)statusListener);
        StatusUtil statusUtil = new StatusUtil((Context)this.getLoggerContext());
        JoranConfigurator configurator = this.createConfigurator();
        List eventList = configurator.recallSafeConfiguration();
        long threshold = System.currentTimeMillis();
        boolean success = false;
        try {
            cb.perform(configurator);
            if (statusUtil.hasXMLParsingErrors(threshold)) {
                cb.fallbackConfiguration(eventList, this.createConfigurator(), (StatusListener)statusListener);
            }
            this.addInfo("Context: " + this.getLoggerContext().getName() + " reloaded.");
            success = true;
        }
        catch (Throwable t) {
            this.addError("Error occurred while configuring Logback", t);
        }
        finally {
            if (!success) {
                cb.fallbackConfiguration(eventList, this.createConfigurator(), (StatusListener)statusListener);
            }
            this.getStatusManager().remove((StatusListener)statusListener);
            SlingStatusPrinter.printInCaseOfErrorsOrWarnings((Context)this.getLoggerContext(), this.resetStartTime, startTime, success);
        }
    }

    private JoranConfigurator createConfigurator() {
        SlingConfigurator configurator = new SlingConfigurator();
        configurator.setContext((Context)this.getLoggerContext());
        return configurator;
    }

    private void resetContext(StatusListener statusListener) {
        this.getLoggerContext().reset();
        if (statusListener != null && !this.getStatusManager().getCopyOfStatusListenerList().contains(statusListener)) {
            this.getStatusManager().add(statusListener);
        }
    }

    private String getRootDir(BundleContext bundleContext) {
        String rootDir = bundleContext.getProperty(SLING_LOG_ROOT);
        if (rootDir == null && (rootDir = bundleContext.getProperty("sling.home")) == null) {
            rootDir = new File(".").getAbsolutePath();
        }
        this.addInfo("Using rootDir as " + rootDir);
        return rootDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean installSlf4jBridgeHandler(BundleContext bundleContext) {
        if (Boolean.parseBoolean(bundleContext.getProperty(JUL_SUPPORT))) {
            if (System.getProperty("java.util.logging.config.file") == null && System.getProperty("java.util.logging.config.class") == null) {
                Thread ct = Thread.currentThread();
                ClassLoader old = ct.getContextClassLoader();
                try {
                    ct.setContextClassLoader(LogbackManager.class.getClassLoader());
                    System.setProperty("java.util.logging.config.class", DummyLogManagerConfiguration.class.getName());
                    LogManager.getLogManager().reset();
                }
                finally {
                    ct.setContextClassLoader(old);
                    System.clearProperty("java.util.logging.config.class");
                }
            }
            SLF4JBridgeHandler.install();
            return true;
        }
        return false;
    }

    public LoggerStateContext determineLoggerState() {
        List loggers = this.getLoggerContext().getLoggerList();
        LoggerStateContext ctx = new LoggerStateContext(loggers);
        for (LogConfig lc : this.logConfigManager.getLogConfigs()) {
            for (String category : lc.getCategories()) {
                ctx.osgiConfiguredLoggers.put(category, lc);
            }
        }
        for (ch.qos.logback.classic.Logger logger : loggers) {
            boolean configuredViaOSGiConfig;
            boolean hasOnlySlingRollingAppenders = true;
            Iterator itr = logger.iteratorForAppenders();
            while (itr.hasNext()) {
                Appender a = (Appender)itr.next();
                if (a.getName() != null && !ctx.appenders.containsKey(a.getName())) {
                    ctx.appenders.put(a.getName(), (Appender<ILoggingEvent>)a);
                }
                if (a instanceof SlingRollingFileAppender) continue;
                hasOnlySlingRollingAppenders = false;
            }
            if (logger.getLevel() == null || (configuredViaOSGiConfig = ctx.osgiConfiguredLoggers.containsKey(logger.getName())) && (!configuredViaOSGiConfig || hasOnlySlingRollingAppenders)) continue;
            ctx.nonOSgiConfiguredLoggers.add(logger);
        }
        return ctx;
    }

    private void registerWebConsoleSupport() {
        Properties panelProps = new Properties();
        panelProps.put("service.vendor", "Apache Software Foundation");
        panelProps.put("service.description", "Sling Log Panel Support");
        this.registrations.add(this.bundleContext.registerService(LogPanel.class.getName(), (Object)new SlingLogPanel(this, this.bundleContext), (Dictionary)panelProps));
        Properties printerProps = new Properties();
        printerProps.put("service.vendor", "Apache Software Foundation");
        printerProps.put("service.description", "Sling Log Configuration Printer");
        printerProps.put("felix.webconsole.label", PRINTER_URL);
        printerProps.put("felix.webconsole.title", "Log Files");
        printerProps.put("felix.webconsole.configprinter.modes", "always");
        this.registrations.add(this.bundleContext.registerService(SlingConfigurationPrinter.class.getName(), (Object)new SlingConfigurationPrinter(this), (Dictionary)printerProps));
    }

    private void registerEventHandler() {
        Properties props = new Properties();
        props.put("service.vendor", "Apache Software Foundation");
        props.put("service.description", "Sling Log Reset Event Handler");
        props.put("event.topics", new String[]{RESET_EVENT_TOPIC});
        this.registrations.add(this.bundleContext.registerService("org.osgi.service.event.EventHandler", (Object)new ServiceFactory(){
            private Object instance;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object getService(Bundle bundle, ServiceRegistration serviceRegistration) {
                2 var3_3 = this;
                synchronized (var3_3) {
                    if (this.instance == null) {
                        this.instance = new ConfigResetRequestHandler(LogbackManager.this);
                    }
                    return this.instance;
                }
            }

            public void ungetService(Bundle bundle, ServiceRegistration serviceRegistration, Object o) {
            }
        }, (Dictionary)props));
    }

    public class LoggerStateContext {
        final LoggerContext loggerContext;
        final List<ch.qos.logback.classic.Logger> allLoggers;
        final List<ch.qos.logback.classic.Logger> nonOSgiConfiguredLoggers;
        final Map<String, LogConfig> osgiConfiguredLoggers;
        final Map<String, Appender<ILoggingEvent>> appenders;
        final Map<Appender<ILoggingEvent>, AppenderTracker.AppenderInfo> dynamicAppenders;
        final Map<ServiceReference, TurboFilter> turboFilters;

        LoggerStateContext(List<ch.qos.logback.classic.Logger> allLoggers) {
            this.loggerContext = LogbackManager.this.getLoggerContext();
            this.nonOSgiConfiguredLoggers = new ArrayList<ch.qos.logback.classic.Logger>();
            this.osgiConfiguredLoggers = new HashMap<String, LogConfig>();
            this.appenders = new HashMap<String, Appender<ILoggingEvent>>();
            this.dynamicAppenders = new HashMap<Appender<ILoggingEvent>, AppenderTracker.AppenderInfo>();
            this.allLoggers = allLoggers;
            for (AppenderTracker.AppenderInfo ai : LogbackManager.this.getAppenderTracker().getAppenderInfos()) {
                this.dynamicAppenders.put(ai.appender, ai);
            }
            this.turboFilters = LogbackManager.this.turboFilterTracker.getFilters();
        }

        int getNumberOfLoggers() {
            return this.allLoggers.size();
        }

        int getNumOfDynamicAppenders() {
            return LogbackManager.this.getAppenderTracker().getAppenderInfos().size();
        }

        int getNumOfAppenders() {
            return this.appenders.size();
        }

        boolean isDynamicAppender(Appender<ILoggingEvent> a) {
            return this.dynamicAppenders.containsKey(a);
        }

        ServiceReference getTurboFilterRef(TurboFilter tf) {
            for (Map.Entry<ServiceReference, TurboFilter> e : this.turboFilters.entrySet()) {
                if (!e.getValue().equals(tf)) continue;
                return e.getKey();
            }
            return null;
        }

        Collection<Appender<ILoggingEvent>> getAllAppenders() {
            return this.appenders.values();
        }

        Map<String, Appender<ILoggingEvent>> getAppenderMap() {
            return Collections.unmodifiableMap(this.appenders);
        }
    }

    private class DefaultCallback
    extends ConfiguratorCallback {
        private DefaultCallback() {
        }

        @Override
        public void perform(JoranConfigurator configurator) throws JoranException {
            configurator.doConfigure(this.getMainUrl());
        }

        @Override
        protected URL getMainUrl() {
            return LogbackManager.this.getDefaultConfig();
        }
    }

    private class FilenameConfiguratorCallback
    extends ConfiguratorCallback {
        private final File configFile;

        public FilenameConfiguratorCallback(File configFile) {
            this.configFile = configFile;
        }

        @Override
        public void perform(JoranConfigurator configurator) throws JoranException {
            String path = this.configFile.getAbsolutePath();
            LogbackManager.this.addInfo("Configuring from " + path);
            if (this.configFile.getName().endsWith("xml")) {
                configurator.doConfigure(this.configFile);
            } else if (this.configFile.getName().endsWith("groovy")) {
                if (EnvUtil.isGroovyAvailable()) {
                    GafferUtil.runGafferConfiguratorOn((LoggerContext)LogbackManager.this.getLoggerContext(), (Object)this, (File)this.configFile);
                } else {
                    LogbackManager.this.addError("Groovy classes are not available on the class path. ABORTING INITIALIZATION.");
                }
            }
        }

        @Override
        protected URL getMainUrl() {
            try {
                return this.configFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                LogbackManager.this.addWarn("Cannot convert file to url " + this.configFile.getAbsolutePath(), e);
                return null;
            }
        }
    }

    private abstract class ConfiguratorCallback {
        private ConfiguratorCallback() {
        }

        abstract void perform(JoranConfigurator var1) throws JoranException;

        public void fallbackConfiguration(List<SaxEvent> eventList, JoranConfigurator configurator, StatusListener statusListener) {
            URL mainURL = this.getMainUrl();
            if (mainURL != null) {
                if (eventList != null) {
                    LogbackManager.this.addWarn("Falling back to previously registered safe configuration.");
                    try {
                        LogbackManager.this.resetContext(statusListener);
                        GenericConfigurator.informContextOfURLUsedForConfiguration((Context)LogbackManager.this.context, (URL)mainURL);
                        configurator.doConfigure(eventList);
                        LogbackManager.this.addInfo("Re-registering previous fallback configuration once more as a fallback configuration point");
                        configurator.registerSafeConfiguration(eventList);
                    }
                    catch (JoranException e) {
                        LogbackManager.this.addError("Unexpected exception thrown by a configuration considered safe.", e);
                    }
                } else {
                    LogbackManager.this.addWarn("No previous configuration to fall back on.");
                }
            }
        }

        protected URL getMainUrl() {
            return null;
        }
    }

    private class SlingConfigurator
    extends JoranConfigurator {
        private SlingConfigurator() {
        }

        protected void buildInterpreter() {
            super.buildInterpreter();
            LogbackManager.this.addSubsitutionProperties(this.interpreter.getInterpretationContext());
        }
    }

    private class RootLoggerListener
    implements LogbackResetListener {
        private RootLoggerListener() {
        }

        @Override
        public void onResetStart(LoggerContext context) {
        }

        @Override
        public void onResetComplete(LoggerContext context) {
            ch.qos.logback.classic.Logger root = context.getLogger("ROOT");
            Iterator appenderItr = root.iteratorForAppenders();
            if (appenderItr.hasNext()) {
                root.detachAppender("org.apache.sling.commons.log.CONSOLE");
                LogbackManager.this.addInfo("Found appender attached with root logger. Detaching the default console based logger");
            } else {
                LogbackManager.this.addInfo("No appender was found to be associated with root logger. Registering a Console based logger");
            }
        }
    }

    private class OsgiIntegrationListener
    implements LoggerContextListener {
        private OsgiIntegrationListener() {
        }

        public boolean isResetResistant() {
            return true;
        }

        public void onStart(LoggerContext context) {
        }

        public void onReset(LoggerContext context) {
            LogbackManager.this.addInfo("OsgiIntegrationListener : context reset detected. Adding LogManager to context map and firing listeners");
            context.setPackagingDataEnabled(LogbackManager.this.logConfigManager.isPackagingDataEnabled());
            context.setMaxCallerDataDepth(LogbackManager.this.logConfigManager.getMaxCallerDataDepth());
            ch.qos.logback.classic.Logger rootLogger = LogbackManager.this.getLoggerContext().getLogger("ROOT");
            rootLogger.setLevel(Level.INFO);
            rootLogger.addAppender(LogbackManager.this.logConfigManager.getDefaultAppender());
            LogbackManager.this.resetStartTime = System.currentTimeMillis() + TimeUnit.MILLISECONDS.toMillis(1L);
            LogbackManager.this.addInfo("Registered a default console based logger");
            context.putObject(LogbackManager.class.getName(), (Object)LogbackManager.this);
            for (LogbackResetListener l : LogbackManager.this.resetListeners) {
                LogbackManager.this.addInfo("Firing reset listener - onResetStart " + l.getClass());
                l.onResetStart(context);
            }
        }

        public void onStop(LoggerContext context) {
        }

        public void onLevelChange(ch.qos.logback.classic.Logger logger, Level level) {
        }
    }

    public static class DummyLogManagerConfiguration {
    }

    private class LevelChangePropagatorChecker
    implements LogbackResetListener {
        private LevelChangePropagatorChecker() {
        }

        @Override
        public void onResetStart(LoggerContext context) {
        }

        @Override
        public void onResetComplete(LoggerContext context) {
            List listenerList = context.getCopyOfListenerList();
            boolean levelChangePropagatorInstalled = false;
            for (LoggerContextListener listener : listenerList) {
                if (!(listener instanceof LevelChangePropagator)) continue;
                levelChangePropagatorInstalled = true;
                break;
            }
            if (!levelChangePropagatorInstalled && LogbackManager.this.bridgeHandlerInstalled) {
                LevelChangePropagator propagator = new LevelChangePropagator();
                propagator.setContext((Context)context);
                propagator.start();
                context.addListener((LoggerContextListener)propagator);
                LogbackManager.this.addInfo("Slf4j bridge handler found to be enabled. Installing the LevelChangePropagator");
            }
        }
    }
}

