/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.util.CachingDateFormatter;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.sling.commons.log.logback.internal.LogbackManager;
import org.apache.sling.commons.log.logback.internal.Tailer;

public class SlingConfigurationPrinter {
    private static final CachingDateFormatter SDF = new CachingDateFormatter("yyyy-MM-dd HH:mm:ss");
    private static final String MODE_ZIP = "zip";
    private final LogbackManager logbackManager;

    public SlingConfigurationPrinter(LogbackManager logbackManager) {
        this.logbackManager = logbackManager;
    }

    public void printConfiguration(PrintWriter printWriter, String mode) {
        LogbackManager.LoggerStateContext ctx = this.logbackManager.determineLoggerState();
        int numOfLines = this.getNumOfLines();
        Tailer tailer = new Tailer(printWriter, numOfLines);
        this.dumpLogFileSummary(printWriter, ctx.getAllAppenders());
        if (!MODE_ZIP.equals(mode)) {
            for (Appender<ILoggingEvent> appender : ctx.getAllAppenders()) {
                File file;
                if (!(appender instanceof FileAppender) || !(file = new File(((FileAppender)appender).getFile())).exists()) continue;
                printWriter.print("Log file ");
                printWriter.println(file.getAbsolutePath());
                printWriter.println("--------------------------------------------------");
                if (numOfLines < 0) {
                    SlingConfigurationPrinter.includeWholeFile(printWriter, file);
                } else {
                    try {
                        tailer.tail(file);
                    }
                    catch (IOException e) {
                        this.logbackManager.getLogConfigManager().internalFailure("Error occurred while processing log file " + file, e);
                    }
                }
                printWriter.println();
            }
        }
        SlingConfigurationPrinter.dumpLogbackStatus(this.logbackManager, printWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void includeWholeFile(PrintWriter printWriter, File file) {
        FileReader fr = null;
        try {
            int len;
            fr = new FileReader(file);
            char[] buffer = new char[512];
            while ((len = fr.read(buffer)) != -1) {
                printWriter.write(buffer, 0, len);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void dumpLogFileSummary(PrintWriter pw, Collection<Appender<ILoggingEvent>> appenders) {
        pw.println("Summary");
        pw.println("=======");
        pw.println();
        int counter = 0;
        String rootDir = this.logbackManager.getRootDir();
        for (Appender<ILoggingEvent> appender : appenders) {
            File[] files;
            if (!(appender instanceof FileAppender)) continue;
            File file = new File(((FileAppender)appender).getFile());
            File dir = file.getParentFile();
            String baseName = file.getName();
            String absolutePath = dir.getAbsolutePath();
            String displayName = ((FileAppender)appender).getFile();
            if (absolutePath.startsWith(rootDir)) {
                displayName = baseName;
            }
            pw.printf("%d. %s %n", ++counter, displayName);
            for (File f : files = this.getRotatedFiles((FileAppender)appender, -1)) {
                pw.printf("  - %s, %s, %s %n", f.getName(), SlingConfigurationPrinter.humanReadableByteCount(f.length()), SlingConfigurationPrinter.getModifiedDate(f));
            }
        }
        pw.println();
    }

    public URL[] getAttachments(String mode) {
        if (MODE_ZIP.equals(mode)) {
            ArrayList<URL> urls = new ArrayList<URL>();
            LogbackManager.LoggerStateContext ctx = this.logbackManager.determineLoggerState();
            for (Appender<ILoggingEvent> appender : ctx.getAllAppenders()) {
                File[] files;
                if (!(appender instanceof FileAppender)) continue;
                for (File f : files = this.getRotatedFiles((FileAppender)appender, this.getMaxOldFileCount())) {
                    try {
                        urls.add(f.toURI().toURL());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
            if (urls.size() > 0) {
                return urls.toArray(new URL[urls.size()]);
            }
        }
        return null;
    }

    private File[] getRotatedFiles(FileAppender app, int maxOldFileCount) {
        File file = new File(app.getFile());
        if (app instanceof RollingFileAppender) {
            int maxCount;
            File dir = file.getParentFile();
            final String baseName = file.getName();
            File[] result = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(baseName);
                }
            });
            Arrays.sort(result, Collections.reverseOrder(new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    long o2t;
                    long o1t = o1.lastModified();
                    return o1t < (o2t = o2.lastModified()) ? -1 : (o1t == o2t ? 0 : 1);
                }
            }));
            if (maxOldFileCount > 0 && (maxCount = Math.min(this.getMaxOldFileCount(), result.length)) < result.length) {
                File[] resultCopy = new File[maxCount];
                System.arraycopy(result, 0, resultCopy, 0, maxCount);
                return resultCopy;
            }
            return result;
        }
        return new File[]{file};
    }

    private int getNumOfLines() {
        return this.logbackManager.getLogConfigManager().getNumOfLines();
    }

    private int getMaxOldFileCount() {
        return this.logbackManager.getLogConfigManager().getMaxOldFileCount();
    }

    private static void dumpLogbackStatus(LogbackManager logbackManager, PrintWriter pw) {
        List statusList = logbackManager.getStatusManager().getCopyOfStatusList();
        pw.println("Logback Status");
        pw.println("--------------------------------------------------");
        for (Status s : statusList) {
            pw.printf("%s *%s* %s - %s %n", SDF.format(s.getDate().longValue()), SlingConfigurationPrinter.statusLevelAsString(s), SlingConfigurationPrinter.abbreviatedOrigin(s), s.getMessage());
            if (s.getThrowable() == null) continue;
            s.getThrowable().printStackTrace(pw);
        }
        pw.println();
    }

    static String abbreviatedOrigin(Status s) {
        Object o = s.getOrigin();
        if (o == null) {
            return null;
        }
        String fqClassName = o.getClass().getName();
        int lastIndex = fqClassName.lastIndexOf(46);
        if (lastIndex != -1) {
            return fqClassName.substring(lastIndex + 1, fqClassName.length());
        }
        return fqClassName;
    }

    private static String statusLevelAsString(Status s) {
        switch (s.getEffectiveLevel()) {
            case 0: {
                return "INFO";
            }
            case 1: {
                return "WARN";
            }
            case 2: {
                return "ERROR";
            }
        }
        return null;
    }

    private static String humanReadableByteCount(long bytes) {
        if (bytes < 0L) {
            return "0";
        }
        int unit = 1000;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        char pre = "kMGTPE".charAt(exp - 1);
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), Character.valueOf(pre));
    }

    private static String getModifiedDate(File f) {
        long modified = f.lastModified();
        if (modified == 0L) {
            return "UNKNOWN";
        }
        return SDF.format(modified);
    }
}

