/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.xml.sax.InputSource;

public class Util {
    public static List<String> toList(Object values) {
        if (values == null) {
            return Collections.emptyList();
        }
        Object[] valueArray = values.getClass().isArray() ? (Object[])values : (values instanceof Collection ? ((Collection)values).toArray() : new Object[]{values});
        ArrayList<String> valuesList = new ArrayList<String>(valueArray.length);
        for (Object valueObject : valueArray) {
            String[] splitValues;
            if (valueObject == null) continue;
            for (String value : splitValues = valueObject.toString().split(",")) {
                if ((value = value.trim()).length() <= 0) continue;
                valuesList.add(value);
            }
        }
        return valuesList;
    }

    public static void close(InputSource is) {
        Closeable c = is.getByteStream();
        if (c == null) {
            c = is.getCharacterStream();
        }
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean toBoolean(Object propValue, boolean defaultValue) {
        if ((propValue = Util.toObject(propValue)) instanceof Boolean) {
            return (Boolean)propValue;
        }
        if (propValue != null) {
            return Boolean.valueOf(String.valueOf(propValue));
        }
        return defaultValue;
    }

    public static int toInteger(Object propValue, int defaultValue) {
        if ((propValue = Util.toObject(propValue)) instanceof Integer) {
            return (Integer)propValue;
        }
        if (propValue != null) {
            try {
                return Integer.valueOf(String.valueOf(propValue));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static Object toObject(Object propValue) {
        if (propValue == null) {
            return null;
        }
        if (propValue.getClass().isArray()) {
            Object[] prop = (Object[])propValue;
            return prop.length > 0 ? prop[0] : null;
        }
        if (propValue instanceof Collection) {
            Collection prop = (Collection)propValue;
            return prop.isEmpty() ? null : prop.iterator().next();
        }
        return propValue;
    }
}

