/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.provisioning.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.sling.provisioning.model.Commentable;

public class Artifact
extends Commentable
implements Comparable {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String classifier;
    private final String type;
    private final Map<String, String> metadata = new HashMap<String, String>();

    public Artifact(String gId, String aId, String version, String classifier, String type) {
        this.groupId = gId != null ? gId.trim() : null;
        this.artifactId = aId != null ? aId.trim() : null;
        this.version = version != null ? version.trim() : null;
        String trimmedType = type != null ? type.trim() : null;
        this.type = "bundle".equals(trimmedType) || trimmedType == null || trimmedType.isEmpty() ? "jar" : trimmedType;
        String trimmedClassifier = classifier != null ? classifier.trim() : null;
        this.classifier = trimmedClassifier != null && trimmedClassifier.isEmpty() ? null : trimmedClassifier;
    }

    public static Artifact fromMvnUrl(String url) {
        if (url == null || !url.startsWith("mvn:")) {
            throw new IllegalArgumentException("Invalid mvn url: " + url);
        }
        String content = url.substring(4);
        int pos = content.indexOf(33);
        if (pos != -1) {
            throw new IllegalArgumentException("Repository url is not supported for Maven artifacts at the moment.");
        }
        String coordinates = pos == -1 ? content : content.substring(pos + 1);
        String gId = null;
        String aId = null;
        String version = null;
        String type = null;
        String classifier = null;
        int part = 0;
        String value = coordinates;
        while (value != null) {
            String current;
            pos = value.indexOf(47);
            if (pos == -1) {
                current = value;
                value = null;
            } else {
                current = pos == 0 ? null : value.substring(0, pos);
                value = value.substring(pos + 1);
            }
            if (current != null) {
                if (part == 0) {
                    gId = current;
                } else if (part == 1) {
                    aId = current;
                } else if (part == 2) {
                    version = current;
                } else if (part == 3) {
                    type = current;
                } else if (part == 4) {
                    classifier = current;
                }
            }
            ++part;
        }
        if (version == null) {
            version = "LATEST";
        }
        return new Artifact(gId, aId, version, classifier, type);
    }

    public int hashCode() {
        return this.toMvnUrl().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Artifact)) {
            return false;
        }
        return this.toMvnUrl().equals(((Artifact)o).toMvnUrl());
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        if (!(o instanceof Artifact)) {
            return 1;
        }
        return this.toMvnUrl().compareTo(((Artifact)o).toMvnUrl());
    }

    public String toMvnUrl() {
        StringBuilder sb = new StringBuilder("mvn:");
        sb.append(this.groupId);
        sb.append('/');
        sb.append(this.artifactId);
        sb.append('/');
        sb.append(this.version);
        if (this.classifier != null || !"jar".equals(this.type)) {
            sb.append('/');
            sb.append(this.type);
            if (this.classifier != null) {
                sb.append('/');
                sb.append(this.classifier);
            }
        }
        return sb.toString();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String getRepositoryPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupId.replace('.', '/'));
        sb.append('/');
        sb.append(this.artifactId);
        sb.append('/');
        sb.append(this.version);
        sb.append('/');
        sb.append(this.artifactId);
        sb.append('-');
        sb.append(this.version);
        if (this.classifier != null) {
            sb.append('-');
            sb.append(this.classifier);
        }
        sb.append('.');
        sb.append(this.type);
        return sb.toString();
    }

    @Override
    public String toString() {
        return "Artifact [groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + ", classifier=" + this.classifier + ", type=" + this.type + (this.getLocation() != null ? ", location=" + this.getLocation() : "") + "]";
    }
}

