/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.provisioning.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.cm.file.ConfigurationHandler;
import org.apache.sling.provisioning.model.Artifact;
import org.apache.sling.provisioning.model.ArtifactGroup;
import org.apache.sling.provisioning.model.Configuration;
import org.apache.sling.provisioning.model.Feature;
import org.apache.sling.provisioning.model.Model;
import org.apache.sling.provisioning.model.RunMode;
import org.apache.sling.provisioning.model.Traceable;

public abstract class ModelUtility {
    public static void merge(Model base, Model additional) {
        ModelUtility.merge(base, additional, true);
    }

    /*
     * WARNING - void declaration
     */
    public static void merge(Model base, Model additional, boolean handleRemove) {
        for (Feature feature : additional.getFeatures()) {
            Feature baseFeature = base.getOrCreateFeature(feature.getName());
            baseFeature.getVariables().putAll(feature.getVariables());
            for (RunMode runMode : feature.getRunModes()) {
                String[] names = runMode.getNames();
                if (handleRemove && names != null) {
                    int removeIndex = -1;
                    int index = 0;
                    for (String string : names) {
                        if (string.equals(":remove")) {
                            removeIndex = index;
                            break;
                        }
                        ++index;
                    }
                    if (removeIndex != -1) {
                        void var11_17;
                        RunMode baseRunMode;
                        Object var11_15 = null;
                        if (names.length > 1) {
                            void var14_32;
                            String[] stringArray = new String[names.length - 1];
                            index = 0;
                            String[] arr$ = names;
                            int len$ = arr$.length;
                            boolean bl = false;
                            while (var14_32 < len$) {
                                String name = arr$[var14_32];
                                if (!name.equals(":remove")) {
                                    stringArray[index++] = name;
                                }
                                ++var14_32;
                            }
                        }
                        if ((baseRunMode = baseFeature.getRunMode(names = var11_17)) == null) continue;
                        for (ArtifactGroup artifactGroup : runMode.getArtifactGroups()) {
                            for (Artifact artifact : artifactGroup) {
                                for (ArtifactGroup searchGroup : baseRunMode.getArtifactGroups()) {
                                    Artifact found = searchGroup.search(artifact);
                                    if (found == null) continue;
                                    searchGroup.remove(found);
                                }
                            }
                        }
                        for (Configuration configuration : runMode.getConfigurations()) {
                            Configuration found = baseRunMode.getConfiguration(configuration.getPid(), configuration.getFactoryPid());
                            if (found == null) continue;
                            baseRunMode.getConfigurations().remove(found);
                        }
                        for (Map.Entry entry : runMode.getSettings()) {
                            baseRunMode.getSettings().remove((String)entry.getKey());
                        }
                        continue;
                    }
                }
                RunMode baseRunMode = baseFeature.getOrCreateRunMode(names);
                for (ArtifactGroup artifactGroup : runMode.getArtifactGroups()) {
                    ArtifactGroup baseGroup = baseRunMode.getOrCreateArtifactGroup(artifactGroup.getStartLevel());
                    for (Artifact artifact : artifactGroup) {
                        for (ArtifactGroup searchGroup : baseRunMode.getArtifactGroups()) {
                            Artifact found = searchGroup.search(artifact);
                            if (found == null) continue;
                            searchGroup.remove(found);
                        }
                        baseGroup.add(artifact);
                    }
                }
                for (Configuration configuration : runMode.getConfigurations()) {
                    Configuration found = baseRunMode.getOrCreateConfiguration(configuration.getPid(), configuration.getFactoryPid());
                    ModelUtility.mergeConfiguration(found, configuration);
                }
                for (Map.Entry entry : runMode.getSettings()) {
                    baseRunMode.getSettings().put((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
    }

    private static void mergeConfiguration(Configuration baseConfig, Configuration mergeConfig) {
        boolean isNew = baseConfig.getProperties().isEmpty();
        if (isNew) {
            ModelUtility.copyConfigurationProperties(baseConfig, mergeConfig);
            Object mode = mergeConfig.getProperties().get(":rawconfig.mode");
            if (mode != null) {
                baseConfig.getProperties().put(":rawconfig.mode", mode);
            }
        } else {
            boolean mergeIsRaw;
            boolean baseIsRaw = baseConfig.getProperties().get(":rawconfig") != null;
            boolean bl = mergeIsRaw = mergeConfig.getProperties().get(":rawconfig") != null;
            if (baseIsRaw && mergeIsRaw) {
                String cfgMode = (String)mergeConfig.getProperties().get(":rawconfig.mode");
                if (cfgMode == null || "overwrite".equals(cfgMode)) {
                    ModelUtility.copyConfigurationProperties(baseConfig, mergeConfig);
                } else {
                    Configuration newConfig = new Configuration(baseConfig.getPid(), baseConfig.getFactoryPid());
                    ModelUtility.getProcessedConfiguration(newConfig, baseConfig);
                    ModelUtility.clearConfiguration(baseConfig);
                    ModelUtility.copyConfigurationProperties(baseConfig, newConfig);
                    ModelUtility.clearConfiguration(newConfig);
                    ModelUtility.getProcessedConfiguration(newConfig, mergeConfig);
                    if (baseConfig.isSpecial()) {
                        String baseValue = baseConfig.getProperties().get(baseConfig.getPid()).toString();
                        String mergeValue = newConfig.getProperties().get(baseConfig.getPid()).toString();
                        baseConfig.getProperties().put(baseConfig.getPid(), baseValue + "\n" + mergeValue);
                    } else {
                        ModelUtility.copyConfigurationProperties(baseConfig, newConfig);
                    }
                }
            } else if (!baseIsRaw && !mergeIsRaw) {
                ModelUtility.clearConfiguration(baseConfig);
                ModelUtility.copyConfigurationProperties(baseConfig, mergeConfig);
            } else if (!baseIsRaw && mergeIsRaw) {
                String cfgMode = (String)mergeConfig.getProperties().get(":rawconfig.mode");
                if (cfgMode == null || "overwrite".equals(cfgMode)) {
                    ModelUtility.clearConfiguration(baseConfig);
                    ModelUtility.copyConfigurationProperties(baseConfig, mergeConfig);
                } else {
                    Configuration newMergeConfig = new Configuration(mergeConfig.getPid(), mergeConfig.getFactoryPid());
                    ModelUtility.getProcessedConfiguration(newMergeConfig, mergeConfig);
                    if (baseConfig.isSpecial()) {
                        String baseValue = baseConfig.getProperties().get(baseConfig.getPid()).toString();
                        String mergeValue = newMergeConfig.getProperties().get(baseConfig.getPid()).toString();
                        baseConfig.getProperties().put(baseConfig.getPid(), baseValue + "\n" + mergeValue);
                    } else {
                        ModelUtility.copyConfigurationProperties(baseConfig, newMergeConfig);
                    }
                }
            } else {
                ModelUtility.clearConfiguration(baseConfig);
                ModelUtility.copyConfigurationProperties(baseConfig, mergeConfig);
            }
        }
    }

    private static void clearConfiguration(Configuration cfg) {
        HashSet<String> keys = new HashSet<String>();
        Enumeration<String> e = cfg.getProperties().keys();
        while (e.hasMoreElements()) {
            keys.add(e.nextElement());
        }
        for (String key : keys) {
            cfg.getProperties().remove(key);
        }
    }

    private static void copyConfigurationProperties(Configuration baseConfig, Configuration mergeConfig) {
        Enumeration<String> e = mergeConfig.getProperties().keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            if (key.equals(":rawconfig.mode")) continue;
            baseConfig.getProperties().put(key, mergeConfig.getProperties().get(key));
        }
    }

    public static Model getEffectiveModel(Model model, final VariableResolver resolver) {
        Model result = new Model();
        result.setLocation(model.getLocation());
        for (Feature feature : model.getFeatures()) {
            Feature newFeature = result.getOrCreateFeature(feature.getName());
            newFeature.setComment(feature.getComment());
            newFeature.setLocation(feature.getLocation());
            newFeature.getVariables().setComment(feature.getVariables().getComment());
            newFeature.getVariables().setLocation(feature.getVariables().getLocation());
            newFeature.getVariables().putAll(feature.getVariables());
            for (RunMode runMode : feature.getRunModes()) {
                RunMode newRunMode = newFeature.getOrCreateRunMode(runMode.getNames());
                newRunMode.setLocation(runMode.getLocation());
                for (ArtifactGroup artifactGroup : runMode.getArtifactGroups()) {
                    ArtifactGroup newGroup = newRunMode.getOrCreateArtifactGroup(artifactGroup.getStartLevel());
                    newGroup.setComment(artifactGroup.getComment());
                    newGroup.setLocation(artifactGroup.getLocation());
                    for (Artifact artifact : artifactGroup) {
                        Artifact newArtifact = new Artifact(ModelUtility.replace(feature, artifact.getGroupId(), resolver), ModelUtility.replace(feature, artifact.getArtifactId(), resolver), ModelUtility.replace(feature, artifact.getVersion(), resolver), ModelUtility.replace(feature, artifact.getClassifier(), resolver), ModelUtility.replace(feature, artifact.getType(), resolver));
                        newArtifact.setComment(artifact.getComment());
                        newArtifact.setLocation(artifact.getLocation());
                        newGroup.add(newArtifact);
                    }
                }
                newRunMode.getConfigurations().setComment(runMode.getConfigurations().getComment());
                newRunMode.getConfigurations().setLocation(runMode.getConfigurations().getLocation());
                for (Configuration configuration : runMode.getConfigurations()) {
                    Configuration newConfig = newRunMode.getOrCreateConfiguration(configuration.getPid(), configuration.getFactoryPid());
                    ModelUtility.getProcessedConfiguration(newConfig, configuration);
                }
                newRunMode.getSettings().setComment(runMode.getSettings().getComment());
                newRunMode.getSettings().setLocation(runMode.getSettings().getLocation());
                for (Map.Entry entry : runMode.getSettings()) {
                    newRunMode.getSettings().put((String)entry.getKey(), ModelUtility.replace(feature, (String)entry.getValue(), new VariableResolver(){

                        @Override
                        public String resolve(Feature feature, String name) {
                            if ("sling.home".equals(name)) {
                                return "${sling.home}";
                            }
                            if (resolver != null) {
                                return resolver.resolve(feature, name);
                            }
                            return feature.getVariables().get(name);
                        }
                    }));
                }
            }
        }
        return result;
    }

    static String replace(Feature feature, String v, VariableResolver resolver) {
        if (v == null) {
            return null;
        }
        String msg = v;
        int pos = -1;
        int start = 0;
        while ((pos = msg.indexOf(36, start)) != -1) {
            int endPos;
            boolean escapedVariable;
            boolean bl = escapedVariable = pos > 0 && msg.charAt(pos - 1) == '\\';
            if (msg.length() > pos && msg.charAt(pos + 1) == '{' && (pos == 0 || msg.charAt(pos - 1) != '$') && (endPos = msg.indexOf(125, pos)) != -1) {
                String name = msg.substring(pos + 2, endPos);
                String value = escapedVariable ? "\\${" + name + "}" : (resolver != null ? resolver.resolve(feature, name) : feature.getVariables().get(name));
                if (value == null) {
                    throw new IllegalArgumentException("Unknown variable: " + name);
                }
                int startPos = escapedVariable ? pos - 1 : pos;
                msg = msg.substring(0, startPos) + value + msg.substring(endPos + 1);
            }
            start = pos + 1;
        }
        return msg;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<Traceable, String> validate(Model model) {
        HashMap<Traceable, String> errors = new HashMap<Traceable, String>();
        for (Feature feature : model.getFeatures()) {
            if (feature.getName() == null || feature.getName().isEmpty()) {
                errors.put(feature, "Name is required for a feature.");
            }
            for (RunMode runMode : feature.getRunModes()) {
                Object[] rm = runMode.getNames();
                if (rm != null) {
                    boolean hasSpecial = false;
                    for (String string : rm) {
                        if (!string.startsWith(":")) continue;
                        if (hasSpecial) {
                            errors.put(runMode, "Invalid modes " + Arrays.toString(rm));
                            break;
                        }
                        hasSpecial = true;
                    }
                }
                for (ArtifactGroup sl : runMode.getArtifactGroups()) {
                    if (sl.getStartLevel() < 0) {
                        errors.put(sl, "Invalid start level " + sl.getStartLevel());
                    }
                    for (Artifact a : sl) {
                        void var11_25;
                        Object var11_17 = null;
                        if (a.getGroupId() == null || a.getGroupId().isEmpty()) {
                            String string = "groupId missing";
                        }
                        if (a.getArtifactId() == null || a.getArtifactId().isEmpty()) {
                            void var11_19;
                            String string = (var11_19 != null ? (String)var11_19 + ", " : "") + "artifactId missing";
                        }
                        if (a.getVersion() == null || a.getVersion().isEmpty()) {
                            void var11_21;
                            String string = (var11_21 != null ? (String)var11_21 + ", " : "") + "version missing";
                        }
                        if (a.getType() == null || a.getType().isEmpty()) {
                            void var11_23;
                            String string = (var11_23 != null ? (String)var11_23 + ", " : "") + "type missing";
                        }
                        if (var11_25 == null) continue;
                        errors.put(a, (String)var11_25);
                    }
                }
                for (Configuration c : runMode.getConfigurations()) {
                    String error = null;
                    if (c.getPid() == null || c.getPid().isEmpty()) {
                        error = "pid missing";
                    }
                    if (c.isSpecial() && c.getFactoryPid() != null) {
                        error = (error != null ? error + ", " : "") + "factory pid not allowed for special configuration";
                    }
                    if (c.getProperties().isEmpty()) {
                        error = (error != null ? error + ", " : "") + "configuration properties missing";
                    }
                    if (error == null) continue;
                    errors.put(c, error);
                }
            }
        }
        if (errors.size() == 0) {
            return null;
        }
        return errors;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void getProcessedConfiguration(Configuration newConfig, Configuration config) {
        newConfig.setComment(config.getComment());
        newConfig.setLocation(config.getLocation());
        String rawConfig = (String)config.getProperties().get(":rawconfig");
        if (rawConfig != null) {
            if (config.isSpecial()) {
                newConfig.getProperties().put(config.getPid(), rawConfig);
                return;
            }
            String format = (String)config.getProperties().get(":rawconfig.format");
            if ("properties".equals(format)) {
                Properties props = new Properties();
                try {
                    props.load(new StringReader(rawConfig));
                }
                catch (IOException ioe) {
                    throw new IllegalArgumentException("Unable to read configuration properties.", ioe);
                }
                Enumeration<Object> i = props.keys();
                while (i.hasMoreElements()) {
                    String key = (String)i.nextElement();
                    newConfig.getProperties().put(key, props.get(key));
                }
                return;
            }
            StringBuilder sb = new StringBuilder();
            try {
                LineNumberReader lnr = new LineNumberReader(new StringReader(rawConfig));
                String line = null;
                while ((line = lnr.readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                    sb.append(line);
                    sb.append('\n');
                }
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("Unable to read configuration properties: " + config, ioe);
            }
            ByteArrayInputStream bais = null;
            try {
                bais = new ByteArrayInputStream(sb.toString().getBytes("UTF-8"));
                Dictionary props = ConfigurationHandler.read(bais);
                Enumeration i = props.keys();
                while (i.hasMoreElements()) {
                    String key = (String)i.nextElement();
                    newConfig.getProperties().put(key, props.get(key));
                }
                return;
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("Unable to read configuration properties: " + config, ioe);
            }
            finally {
                if (bais != null) {
                    try {
                        bais.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        Enumeration<String> i = config.getProperties().keys();
        while (i.hasMoreElements()) {
            String key = i.nextElement();
            newConfig.getProperties().put(key, config.getProperties().get(key));
        }
    }

    public static interface VariableResolver {
        public String resolve(Feature var1, String var2);
    }
}

