/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackReader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class ConfigurationHandler {
    protected static final String ENCODING = "UTF-8";
    protected static final int TOKEN_NAME = 78;
    protected static final int TOKEN_EQ = 61;
    protected static final int TOKEN_ARR_OPEN = 91;
    protected static final int TOKEN_ARR_CLOS = 93;
    protected static final int TOKEN_VEC_OPEN = 40;
    protected static final int TOKEN_VEC_CLOS = 41;
    protected static final int TOKEN_COMMA = 44;
    protected static final int TOKEN_VAL_OPEN = 34;
    protected static final int TOKEN_VAL_CLOS = 34;
    protected static final int TOKEN_SIMPLE_STRING = 84;
    protected static final int TOKEN_SIMPLE_INTEGER = 73;
    protected static final int TOKEN_SIMPLE_LONG = 76;
    protected static final int TOKEN_SIMPLE_FLOAT = 70;
    protected static final int TOKEN_SIMPLE_DOUBLE = 68;
    protected static final int TOKEN_SIMPLE_BYTE = 88;
    protected static final int TOKEN_SIMPLE_SHORT = 83;
    protected static final int TOKEN_SIMPLE_CHARACTER = 67;
    protected static final int TOKEN_SIMPLE_BOOLEAN = 66;
    protected static final int TOKEN_PRIMITIVE_INT = 105;
    protected static final int TOKEN_PRIMITIVE_LONG = 108;
    protected static final int TOKEN_PRIMITIVE_FLOAT = 102;
    protected static final int TOKEN_PRIMITIVE_DOUBLE = 100;
    protected static final int TOKEN_PRIMITIVE_BYTE = 120;
    protected static final int TOKEN_PRIMITIVE_SHORT = 115;
    protected static final int TOKEN_PRIMITIVE_CHAR = 99;
    protected static final int TOKEN_PRIMITIVE_BOOLEAN = 98;
    protected static final String CRLF = "\r\n";
    protected static final String INDENT = "  ";
    protected static final String COLLECTION_LINE_BREAK = " \\\r\n";
    protected static final Map code2Type;
    protected static final Map type2Code;
    private static final BitSet NAME_CHARS;
    private static final BitSet TOKEN_CHARS;
    private int token;
    private String tokenValue;
    private int line;
    private int pos;

    public static void write(OutputStream out, Dictionary properties) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out, ENCODING));
        Enumeration ce = ConfigurationHandler.orderedKeys(properties);
        while (ce.hasMoreElements()) {
            String key = (String)ce.nextElement();
            ConfigurationHandler.writeQuoted(bw, key);
            bw.write(61);
            ConfigurationHandler.writeValue(bw, properties.get(key));
            bw.write(CRLF);
        }
        bw.flush();
    }

    private static Enumeration orderedKeys(Dictionary properties) {
        Object[] keyArray = new String[properties.size()];
        int i = 0;
        Enumeration ce = properties.keys();
        while (ce.hasMoreElements()) {
            keyArray[i] = (String)ce.nextElement();
            ++i;
        }
        Arrays.sort(keyArray);
        return Collections.enumeration(Arrays.asList(keyArray));
    }

    public static Dictionary read(InputStream ins) throws IOException {
        return new ConfigurationHandler().readInternal(ins);
    }

    private ConfigurationHandler() {
    }

    private Dictionary readInternal(InputStream ins) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(ins, ENCODING));
        PushbackReader pr = new PushbackReader(br, 1);
        this.token = 0;
        this.tokenValue = null;
        this.line = 0;
        this.pos = 0;
        Hashtable<String, Object> configuration = new Hashtable<String, Object>();
        this.token = 0;
        while (this.nextToken(pr) == 78) {
            String key = this.tokenValue;
            if (this.nextToken(pr) != 61) {
                throw this.readFailure(this.token, 61);
            }
            Object value = this.readValue(pr);
            if (value == null) continue;
            configuration.put(key, value);
        }
        return configuration;
    }

    private Object readValue(PushbackReader pr) throws IOException {
        int code;
        int type = this.read(pr);
        if (code2Type.containsKey(new Integer(type))) {
            code = this.read(pr);
        } else {
            code = type;
            type = 84;
        }
        switch (code) {
            case 91: {
                return this.readArray(type, pr);
            }
            case 40: {
                return this.readCollection(type, pr);
            }
            case 34: {
                Object value = this.readSimple(type, pr);
                this.ensureNext(pr, 34);
                return value;
            }
        }
        return null;
    }

    private Object readArray(int typeCode, PushbackReader pr) throws IOException {
        int c;
        ArrayList<Object> list = new ArrayList<Object>();
        do {
            if ((c = this.ignorablePageBreakAndWhiteSpace(pr)) == 34) {
                Object value = this.readSimple(typeCode, pr);
                if (value == null) {
                    return null;
                }
                this.ensureNext(pr, 34);
                list.add(value);
                c = this.ignorablePageBreakAndWhiteSpace(pr);
            }
            if (c == 93) {
                Class type = (Class)code2Type.get(new Integer(typeCode));
                Object array = Array.newInstance(type, list.size());
                for (int i = 0; i < list.size(); ++i) {
                    Array.set(array, i, list.get(i));
                }
                return array;
            }
            if (c >= 0) continue;
            return null;
        } while (c == 44);
        return null;
    }

    private Collection readCollection(int typeCode, PushbackReader pr) throws IOException {
        int c;
        ArrayList<Object> collection = new ArrayList<Object>();
        do {
            if ((c = this.ignorablePageBreakAndWhiteSpace(pr)) == 34) {
                Object value = this.readSimple(typeCode, pr);
                if (value == null) {
                    return null;
                }
                this.ensureNext(pr, 34);
                collection.add(value);
                c = this.ignorablePageBreakAndWhiteSpace(pr);
            }
            if (c == 41) {
                return collection;
            }
            if (c >= 0) continue;
            return null;
        } while (c == 44);
        return null;
    }

    private Object readSimple(int code, PushbackReader pr) throws IOException {
        switch (code) {
            case -1: {
                return null;
            }
            case 84: {
                return this.readQuoted(pr);
            }
            case 73: 
            case 105: {
                return Integer.valueOf(this.readQuoted(pr));
            }
            case 76: 
            case 108: {
                return Long.valueOf(this.readQuoted(pr));
            }
            case 70: 
            case 102: {
                int fBits = Integer.parseInt(this.readQuoted(pr));
                return new Float(Float.intBitsToFloat(fBits));
            }
            case 68: 
            case 100: {
                long dBits = Long.parseLong(this.readQuoted(pr));
                return new Double(Double.longBitsToDouble(dBits));
            }
            case 88: 
            case 120: {
                return Byte.valueOf(this.readQuoted(pr));
            }
            case 83: 
            case 115: {
                return Short.valueOf(this.readQuoted(pr));
            }
            case 67: 
            case 99: {
                String cString = this.readQuoted(pr);
                if (cString != null && cString.length() > 0) {
                    return new Character(cString.charAt(0));
                }
                return null;
            }
            case 66: 
            case 98: {
                return Boolean.valueOf(this.readQuoted(pr));
            }
        }
        return null;
    }

    private void ensureNext(PushbackReader pr, int expected) throws IOException {
        int next = this.read(pr);
        if (next != expected) {
            this.readFailure(next, expected);
        }
    }

    private String readQuoted(PushbackReader pr) throws IOException {
        StringBuffer buf = new StringBuffer();
        block12: while (true) {
            int c = this.read(pr);
            switch (c) {
                case 92: {
                    c = this.read(pr);
                    switch (c) {
                        case 98: {
                            buf.append('\b');
                            break;
                        }
                        case 116: {
                            buf.append('\t');
                            break;
                        }
                        case 110: {
                            buf.append('\n');
                            break;
                        }
                        case 102: {
                            buf.append('\f');
                            break;
                        }
                        case 114: {
                            buf.append('\r');
                            break;
                        }
                        case 117: {
                            char[] cbuf = new char[4];
                            if (this.read(pr, cbuf) != 4) continue block12;
                            c = Integer.parseInt(new String(cbuf), 16);
                            buf.append((char)c);
                            break;
                        }
                        default: {
                            buf.append((char)c);
                            break;
                        }
                    }
                    continue block12;
                }
                case -1: 
                case 34: 
                case 61: {
                    pr.unread(c);
                    return buf.toString();
                }
                default: {
                    buf.append((char)c);
                }
            }
        }
    }

    private int nextToken(PushbackReader pr) throws IOException {
        int c = this.ignorableWhiteSpace(pr);
        if (c < 0) {
            this.token = c;
            return this.token;
        }
        if (NAME_CHARS.get(c) || !TOKEN_CHARS.get(c)) {
            pr.unread(c);
            this.tokenValue = this.readQuoted(pr);
            this.token = 78;
            return 78;
        }
        if (TOKEN_CHARS.get(c)) {
            this.token = c;
            return this.token;
        }
        this.token = -1;
        return -1;
    }

    private int ignorableWhiteSpace(PushbackReader pr) throws IOException {
        int c = this.read(pr);
        while (c >= 0 && Character.isWhitespace((char)c)) {
            c = this.read(pr);
        }
        return c;
    }

    private int ignorablePageBreakAndWhiteSpace(PushbackReader pr) throws IOException {
        int c = this.ignorableWhiteSpace(pr);
        while (c == 92) {
            int c1 = pr.read();
            if (c1 == 13 || c1 == 10) {
                c = this.ignorableWhiteSpace(pr);
                continue;
            }
            pr.unread(c1);
            break;
        }
        return c;
    }

    private int read(PushbackReader pr) throws IOException {
        int c = pr.read();
        if (c == 13) {
            int c1 = pr.read();
            if (c1 != 10) {
                pr.unread(c1);
            }
            c = 10;
        }
        if (c == 10) {
            ++this.line;
            this.pos = 0;
        } else {
            ++this.pos;
        }
        return c;
    }

    private int read(PushbackReader pr, char[] buf) throws IOException {
        for (int i = 0; i < buf.length; ++i) {
            int c = this.read(pr);
            if (c < 0) {
                return i;
            }
            buf[i] = (char)c;
        }
        return buf.length;
    }

    private IOException readFailure(int current, int expected) {
        return new IOException("Unexpected token " + current + "; expected: " + expected + " (line=" + this.line + ", pos=" + this.pos + ")");
    }

    private static void writeValue(Writer out, Object value) throws IOException {
        Class<?> clazz = value.getClass();
        if (clazz.isArray()) {
            ConfigurationHandler.writeArray(out, value);
        } else if (value instanceof Collection) {
            ConfigurationHandler.writeCollection(out, (Collection)value);
        } else {
            ConfigurationHandler.writeType(out, clazz);
            ConfigurationHandler.writeSimple(out, value);
        }
    }

    private static void writeArray(Writer out, Object arrayValue) throws IOException {
        int size = Array.getLength(arrayValue);
        ConfigurationHandler.writeType(out, arrayValue.getClass().getComponentType());
        out.write(91);
        out.write(COLLECTION_LINE_BREAK);
        for (int i = 0; i < size; ++i) {
            ConfigurationHandler.writeCollectionElement(out, Array.get(arrayValue, i));
        }
        out.write(INDENT);
        out.write(93);
    }

    private static void writeCollection(Writer out, Collection collection) throws IOException {
        if (collection.isEmpty()) {
            out.write(40);
            out.write(COLLECTION_LINE_BREAK);
            out.write(41);
        } else {
            Iterator ci = collection.iterator();
            Object firstElement = ci.next();
            ConfigurationHandler.writeType(out, firstElement.getClass());
            out.write(40);
            out.write(COLLECTION_LINE_BREAK);
            ConfigurationHandler.writeCollectionElement(out, firstElement);
            while (ci.hasNext()) {
                ConfigurationHandler.writeCollectionElement(out, ci.next());
            }
            out.write(41);
        }
    }

    private static void writeCollectionElement(Writer out, Object element) throws IOException {
        out.write(INDENT);
        ConfigurationHandler.writeSimple(out, element);
        out.write(44);
        out.write(COLLECTION_LINE_BREAK);
    }

    private static void writeType(Writer out, Class valueType) throws IOException {
        Integer code = (Integer)type2Code.get(valueType);
        if (code != null) {
            out.write((char)code.intValue());
        }
    }

    private static void writeSimple(Writer out, Object value) throws IOException {
        if (value instanceof Double) {
            double dVal = (Double)value;
            value = new Long(Double.doubleToRawLongBits(dVal));
        } else if (value instanceof Float) {
            float fVal = ((Float)value).floatValue();
            value = new Integer(Float.floatToRawIntBits(fVal));
        }
        out.write(34);
        ConfigurationHandler.writeQuoted(out, String.valueOf(value));
        out.write(34);
    }

    private static void writeQuoted(Writer out, String simple) throws IOException {
        if (simple == null || simple.length() == 0) {
            return;
        }
        char c = '\u0000';
        int len = simple.length();
        block8: for (int i = 0; i < len; ++i) {
            c = simple.charAt(i);
            switch (c) {
                case ' ': 
                case '\"': 
                case '=': 
                case '\\': {
                    out.write(92);
                    out.write(c);
                    continue block8;
                }
                case '\b': {
                    out.write("\\b");
                    continue block8;
                }
                case '\t': {
                    out.write("\\t");
                    continue block8;
                }
                case '\n': {
                    out.write("\\n");
                    continue block8;
                }
                case '\f': {
                    out.write("\\f");
                    continue block8;
                }
                case '\r': {
                    out.write("\\r");
                    continue block8;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        out.write("\\u" + t.substring(t.length() - 4));
                        continue block8;
                    }
                    out.write(c);
                }
            }
        }
    }

    static {
        int i;
        type2Code = new HashMap();
        type2Code.put(Integer.class, new Integer(73));
        type2Code.put(Long.class, new Integer(76));
        type2Code.put(Float.class, new Integer(70));
        type2Code.put(Double.class, new Integer(68));
        type2Code.put(Byte.class, new Integer(88));
        type2Code.put(Short.class, new Integer(83));
        type2Code.put(Character.class, new Integer(67));
        type2Code.put(Boolean.class, new Integer(66));
        type2Code.put(Integer.TYPE, new Integer(105));
        type2Code.put(Long.TYPE, new Integer(108));
        type2Code.put(Float.TYPE, new Integer(102));
        type2Code.put(Double.TYPE, new Integer(100));
        type2Code.put(Byte.TYPE, new Integer(120));
        type2Code.put(Short.TYPE, new Integer(115));
        type2Code.put(Character.TYPE, new Integer(99));
        type2Code.put(Boolean.TYPE, new Integer(98));
        code2Type = new HashMap();
        for (Map.Entry entry : type2Code.entrySet()) {
            code2Type.put(entry.getValue(), entry.getKey());
        }
        code2Type.put(new Integer(84), String.class);
        NAME_CHARS = new BitSet();
        for (i = 48; i <= 57; ++i) {
            NAME_CHARS.set(i);
        }
        for (i = 97; i <= 122; ++i) {
            NAME_CHARS.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            NAME_CHARS.set(i);
        }
        NAME_CHARS.set(95);
        NAME_CHARS.set(45);
        NAME_CHARS.set(46);
        NAME_CHARS.set(92);
        TOKEN_CHARS = new BitSet();
        TOKEN_CHARS.set(61);
        TOKEN_CHARS.set(91);
        TOKEN_CHARS.set(93);
        TOKEN_CHARS.set(40);
        TOKEN_CHARS.set(41);
        TOKEN_CHARS.set(44);
        TOKEN_CHARS.set(34);
        TOKEN_CHARS.set(34);
        TOKEN_CHARS.set(84);
        TOKEN_CHARS.set(73);
        TOKEN_CHARS.set(76);
        TOKEN_CHARS.set(70);
        TOKEN_CHARS.set(68);
        TOKEN_CHARS.set(88);
        TOKEN_CHARS.set(83);
        TOKEN_CHARS.set(67);
        TOKEN_CHARS.set(66);
        TOKEN_CHARS.set(105);
        TOKEN_CHARS.set(108);
        TOKEN_CHARS.set(102);
        TOKEN_CHARS.set(100);
        TOKEN_CHARS.set(120);
        TOKEN_CHARS.set(115);
        TOKEN_CHARS.set(99);
        TOKEN_CHARS.set(98);
    }
}

