/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.helper;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.resourceresolver.impl.helper.ResourceResolverContext;
import org.apache.sling.resourceresolver.impl.tree.ProviderHandler;
import org.apache.sling.resourceresolver.impl.tree.ResourceProviderEntry;
import org.apache.sling.resourceresolver.impl.tree.RootResourceProviderEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceIterator
implements Iterator<Resource> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Resource parentResource;
    private final RootResourceProviderEntry rootProviderEntry;
    private final Iterator<ProviderHandler> providers;
    private Iterator<ResourceProviderEntry> baseEntryValues;
    private Iterator<Resource> resources;
    private Resource nextResource;
    private final Map<String, Resource> delayed;
    private final Set<String> visited;
    private final String iteratorPath;
    private Iterator<Resource> delayedIter;
    private final ResourceResolverContext resourceResolverContext;

    public ResourceIterator(ResourceResolverContext ctx, Resource parentResource, RootResourceProviderEntry rootProviderEntry) {
        this.resourceResolverContext = ctx;
        this.parentResource = parentResource;
        this.rootProviderEntry = rootProviderEntry;
        this.log.debug("Child Iterator for {}", (Object)parentResource.getPath());
        String path = parentResource.getPath();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        LinkedHashSet<ProviderHandler> providersSet = new LinkedHashSet<ProviderHandler>();
        ResourceProviderEntry atPath = this.getResourceProviders(path, providersSet);
        if (this.log.isDebugEnabled()) {
            this.log.debug(" Provider Set for path {} {} ", (Object)path, (Object)Arrays.toString(providersSet.toArray(new ProviderHandler[providersSet.size()])));
        }
        this.iteratorPath = path;
        this.providers = providersSet.iterator();
        this.baseEntryValues = atPath != null ? atPath.values().iterator() : null;
        this.delayed = new LinkedHashMap<String, Resource>();
        this.visited = new HashSet<String>();
        this.nextResource = this.seek();
    }

    @Override
    public boolean hasNext() {
        return this.nextResource != null;
    }

    @Override
    public Resource next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Resource result = this.nextResource;
        this.nextResource = this.seek();
        this.log.debug("  Child resource [{}] [{}] ", (Object)this.iteratorPath, (Object)result.getPath());
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    private Resource seek() {
        Resource res;
        while (this.delayedIter == null) {
            String resPath;
            while ((this.resources == null || !this.resources.hasNext()) && this.providers.hasNext()) {
                ProviderHandler provider = this.providers.next();
                this.resources = provider.listChildren(this.resourceResolverContext, this.parentResource);
                this.log.debug("     Checking Provider {} ", (Object)provider);
            }
            if (this.resources != null && this.resources.hasNext()) {
                res = this.resources.next();
                resPath = res.getPath();
                if (this.visited.contains(resPath)) {
                    this.delayed.remove(resPath);
                    continue;
                }
                if (res instanceof SyntheticResource) {
                    this.delayed.put(resPath, res);
                    continue;
                }
                this.visited.add(resPath);
                this.delayed.remove(resPath);
                this.log.debug("      resource {} {}", (Object)resPath, res.getClass());
                res.getResourceMetadata().setResolutionPath(res.getPath());
                return res;
            }
            if (this.baseEntryValues != null) {
                while (this.baseEntryValues.hasNext()) {
                    ResourceProviderEntry rpw = this.baseEntryValues.next();
                    resPath = this.iteratorPath + rpw.getPath();
                    if (this.visited.contains(resPath)) continue;
                    ResourceResolver rr = this.parentResource.getResourceResolver();
                    Resource res2 = rpw.getResourceFromProviders(this.resourceResolverContext, rr, resPath);
                    if (res2 == null) {
                        if (this.delayed.containsKey(resPath)) continue;
                        this.delayed.put(resPath, (Resource)new SyntheticResource(rr, resPath, "sling:syntheticResourceProviderResource"));
                        continue;
                    }
                    this.delayed.remove(resPath);
                    this.visited.add(resPath);
                    this.log.debug("   B  resource {} {}", (Object)resPath, res2.getClass());
                    res2.getResourceMetadata().setResolutionPath(res2.getPath());
                    return res2;
                }
                this.baseEntryValues = null;
                continue;
            }
            this.delayedIter = this.delayed.values().iterator();
        }
        Resource resource = res = this.delayedIter.hasNext() ? this.delayedIter.next() : null;
        if (res != null) {
            this.log.debug("   D  resource {} {}", (Object)res.getPath(), res.getClass());
            res.getResourceMetadata().setResolutionPath(res.getPath());
        }
        return res;
    }

    private ResourceProviderEntry getResourceProviders(String path, Set<ProviderHandler> providers) {
        String[] elements = ResourceProviderEntry.split(path);
        ResourceProviderEntry base = this.rootProviderEntry;
        for (String element : elements) {
            if (base.containsKey(element)) {
                base = base.get(element);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Loading from {}  {} ", (Object)element, (Object)base.getResourceProviders().length);
                }
                for (ProviderHandler rp : base.getResourceProviders()) {
                    this.log.debug("Adding {} for {} ", (Object)rp, (Object)path);
                    providers.add(rp);
                }
                continue;
            }
            this.log.debug("No container for {} ", (Object)element);
            base = null;
            break;
        }
        for (ProviderHandler rp : this.rootProviderEntry.getResourceProviders()) {
            this.log.debug("Loading All at {} ", (Object)path);
            providers.add(rp);
        }
        return base;
    }
}

