/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.mapping;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Mapping {
    public static final int INBOUND = 1;
    public static final int OUTBOUND = 2;
    public static final int BOTH = 3;
    public static final Mapping DIRECT = new Mapping("", "", 3){

        public String mapHandle(String handle) {
            return handle;
        }

        public boolean mapsInbound() {
            return true;
        }

        public boolean mapsOutbound() {
            return true;
        }

        public String mapUri(String uriPath) {
            return uriPath;
        }
    };
    private static final Pattern CONFIG_SPLITTER = Pattern.compile("(.+)([:<>])(.+)");
    private final String from;
    private final String to;
    private final int fromLength;
    private final int toLength;
    private final int direction;

    public Mapping(String config) {
        this(Mapping.split(config));
    }

    public Mapping(String[] parts) {
        this.from = parts[0];
        this.to = parts[2];
        this.fromLength = this.from.length();
        this.toLength = this.to.length();
        this.direction = ">".equals(parts[1]) ? 1 : ("<".equals(parts[1]) ? 2 : 3);
    }

    public String toString() {
        return "Mapping (from=" + this.from + ", to=" + this.to + ", direction=" + this.direction + ", lengths=" + this.fromLength + "/" + this.toLength;
    }

    public String mapUri(String uriPath) {
        return this.mapsInbound() && uriPath.startsWith(this.to) ? this.from + uriPath.substring(this.toLength) : null;
    }

    public String mapHandle(String handle) {
        return this.mapsOutbound() && handle.startsWith(this.from) ? this.to + handle.substring(this.fromLength) : null;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public boolean mapsInbound() {
        return (this.direction & 1) > 0;
    }

    public boolean mapsOutbound() {
        return (this.direction & 2) > 0;
    }

    private Mapping(String from, String to, int dir) {
        this.from = from;
        this.to = to;
        this.fromLength = from.length();
        this.toLength = to.length();
        this.direction = dir;
    }

    public static String[] split(String map) {
        Matcher mapMatch = CONFIG_SPLITTER.matcher(map);
        if (mapMatch.matches()) {
            return new String[]{mapMatch.group(1), mapMatch.group(2), mapMatch.group(3)};
        }
        int dash = map.indexOf(45);
        if (dash > 0) {
            return new String[]{map.substring(0, dash), map.substring(dash, dash + 1), map.substring(dash + 1, map.length())};
        }
        return new String[]{map, "-", map};
    }
}

