/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.tree;

import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.AttributableResourceProvider;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.QueriableResourceProvider;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceProviderFactory;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.resourceresolver.impl.helper.ResourceResolverContext;
import org.apache.sling.resourceresolver.impl.helper.SortedProviderList;
import org.apache.sling.resourceresolver.impl.tree.ProviderHandler;
import org.apache.sling.resourceresolver.impl.tree.ResourceProviderEntry;
import org.apache.sling.resourceresolver.impl.tree.ResourceProviderFactoryHandler;
import org.apache.sling.resourceresolver.impl.tree.ResourceProviderHandler;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootResourceProviderEntry
extends ResourceProviderEntry {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private EventAdmin eventAdmin;
    private ResourceProviderFactoryHandler[] requiredFactories = new ResourceProviderFactoryHandler[0];
    private final SortedProviderList<Adaptable> adaptableProviders = new SortedProviderList<Adaptable>(Adaptable.class);
    private final SortedProviderList<QueriableResourceProvider> queriableProviders = new SortedProviderList<QueriableResourceProvider>(QueriableResourceProvider.class);
    private final SortedProviderList<AttributableResourceProvider> attributableProviders = new SortedProviderList<AttributableResourceProvider>(AttributableResourceProvider.class);
    private static final String FORBIDDEN_ATTRIBUTE = "user.password";

    public RootResourceProviderEntry() {
        super("/", null);
    }

    public void setEventAdmin(EventAdmin ea) {
        this.eventAdmin = ea;
    }

    public void loginToRequiredFactories(ResourceResolverContext ctx) throws LoginException {
        try {
            ResourceProviderFactoryHandler[] factories;
            for (ResourceProviderFactoryHandler wrapper : factories = this.requiredFactories) {
                wrapper.login(ctx);
            }
        }
        catch (LoginException le) {
            ctx.close();
            throw le;
        }
    }

    public <AdapterType> AdapterType adaptTo(ResourceResolverContext ctx, Class<AdapterType> type) {
        Iterator<Adaptable> i = this.adaptableProviders.getProviders(ctx, null);
        Object result = null;
        while (result == null && i.hasNext()) {
            Adaptable adap = i.next();
            result = adap.adaptTo(type);
        }
        return (AdapterType)result;
    }

    public Iterator<Resource> findResources(final ResourceResolverContext ctx, final ResourceResolver resolver, final String query, final String language) {
        final Iterator<QueriableResourceProvider> i = this.queriableProviders.getProviders(ctx, new SortedProviderList.Filter<QueriableResourceProvider>(){

            @Override
            public boolean select(ProviderHandler handler, QueriableResourceProvider provider) {
                return handler.supportsQueryLanguages(language);
            }
        });
        return new Iterator<Resource>(){
            private Resource nextObject = this.seek();
            private Iterator<Resource> nextResourceIter;
            private ProviderHandler actProviderHandler;

            private Resource seek() {
                Resource result = null;
                if (this.nextResourceIter == null || !this.nextResourceIter.hasNext()) {
                    this.nextResourceIter = null;
                    while (i.hasNext() && this.nextResourceIter == null) {
                        QueriableResourceProvider adap = (QueriableResourceProvider)i.next();
                        this.actProviderHandler = RootResourceProviderEntry.this.queriableProviders.getProviderHandler(ctx, (ResourceProvider)adap);
                        String transformedQuery = this.actProviderHandler.transformQuery(ctx, resolver, query, language);
                        this.nextResourceIter = adap.findResources(resolver, transformedQuery, language);
                    }
                }
                if (this.nextResourceIter != null) {
                    while (this.nextResourceIter.hasNext() && result == null) {
                        result = this.nextResourceIter.next();
                        if (this.actProviderHandler == null) continue;
                        result = this.actProviderHandler.getReadableResource(ctx, result);
                    }
                    if (result == null) {
                        result = this.seek();
                    }
                }
                return result;
            }

            @Override
            public boolean hasNext() {
                return this.nextObject != null;
            }

            @Override
            public Resource next() {
                if (this.nextObject == null) {
                    throw new NoSuchElementException();
                }
                Resource result = this.nextObject;
                this.nextObject = this.seek();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<Map<String, Object>> queryResources(ResourceResolverContext ctx, final ResourceResolver resolver, final String query, final String language) {
        final Iterator<QueriableResourceProvider> i = this.queriableProviders.getProviders(ctx, new SortedProviderList.Filter<QueriableResourceProvider>(){

            @Override
            public boolean select(ProviderHandler handler, QueriableResourceProvider provider) {
                return handler.supportsQueryLanguages(language);
            }
        });
        return new Iterator<Map<String, Object>>(){
            private ValueMap nextObject = this.seek();
            private Iterator<ValueMap> nextResourceIter;

            private ValueMap seek() {
                ValueMap result = null;
                if (this.nextResourceIter == null || !this.nextResourceIter.hasNext()) {
                    this.nextResourceIter = null;
                    while (i.hasNext() && this.nextResourceIter == null) {
                        QueriableResourceProvider adap = (QueriableResourceProvider)i.next();
                        this.nextResourceIter = adap.queryResources(resolver, query, language);
                    }
                }
                if (this.nextResourceIter != null) {
                    while (this.nextResourceIter.hasNext() && result == null) {
                        result = this.nextResourceIter.next();
                    }
                    if (result == null) {
                        result = this.seek();
                    }
                }
                return result;
            }

            @Override
            public boolean hasNext() {
                return this.nextObject != null;
            }

            @Override
            public ValueMap next() {
                if (this.nextObject == null) {
                    throw new NoSuchElementException();
                }
                ValueMap result = this.nextObject;
                this.nextObject = this.seek();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<String> getAttributeNames(ResourceResolverContext ctx, ResourceResolver resolver) {
        HashSet<String> names = new HashSet<String>();
        if (ctx.getAuthenticationInfo() != null) {
            names.addAll(ctx.getAuthenticationInfo().keySet());
        }
        Iterator<AttributableResourceProvider> i = this.attributableProviders.getProviders(ctx, null);
        while (i.hasNext()) {
            AttributableResourceProvider adap = i.next();
            Collection newNames = adap.getAttributeNames(resolver);
            if (newNames == null) continue;
            names.addAll(newNames);
        }
        names.remove(FORBIDDEN_ATTRIBUTE);
        return names.iterator();
    }

    public Object getAttribute(ResourceResolverContext ctx, ResourceResolver resolver, String name) {
        Object result = null;
        if (!FORBIDDEN_ATTRIBUTE.equals(name)) {
            if (ctx.getAuthenticationInfo() != null) {
                result = ctx.getAuthenticationInfo().get(name);
            }
            if (result == null) {
                Iterator<AttributableResourceProvider> i = this.attributableProviders.getProviders(ctx, null);
                while (result == null && i.hasNext()) {
                    AttributableResourceProvider adap = i.next();
                    result = adap.getAttribute(resolver, name);
                }
            }
        }
        return result;
    }

    public void bindResourceProvider(ResourceProvider provider, Map<String, Object> props) {
        ResourceProviderHandler handler = new ResourceProviderHandler(provider, props);
        this.bindHandler(handler);
        this.adaptableProviders.add(handler);
        this.queriableProviders.add(handler);
        this.attributableProviders.add(handler);
    }

    public void unbindResourceProvider(ResourceProvider provider, Map<String, Object> props) {
        ResourceProviderHandler handler = new ResourceProviderHandler(provider, props);
        this.unbindHandler(handler);
        this.adaptableProviders.remove(handler);
        this.queriableProviders.remove(handler);
        this.attributableProviders.remove(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindResourceProviderFactory(ResourceProviderFactory factory, Map<String, Object> props) {
        ResourceProviderFactoryHandler handler = new ResourceProviderFactoryHandler(factory, props);
        this.bindHandler(handler);
        this.adaptableProviders.add(handler);
        this.queriableProviders.add(handler);
        this.attributableProviders.add(handler);
        boolean required = PropertiesUtil.toBoolean((Object)props.get("required"), (boolean)false);
        if (required) {
            RootResourceProviderEntry rootResourceProviderEntry = this;
            synchronized (rootResourceProviderEntry) {
                LinkedList<ResourceProviderFactoryHandler> factories = new LinkedList<ResourceProviderFactoryHandler>();
                factories.addAll(Arrays.asList(this.requiredFactories));
                factories.add(handler);
                this.requiredFactories = factories.toArray(new ResourceProviderFactoryHandler[factories.size()]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindResourceProviderFactory(ResourceProviderFactory factory, Map<String, Object> props) {
        ResourceProviderFactoryHandler handler = new ResourceProviderFactoryHandler(factory, props);
        this.unbindHandler(handler);
        this.adaptableProviders.remove(handler);
        this.queriableProviders.remove(handler);
        this.attributableProviders.remove(handler);
        boolean required = PropertiesUtil.toBoolean((Object)props.get("required"), (boolean)false);
        if (required) {
            RootResourceProviderEntry rootResourceProviderEntry = this;
            synchronized (rootResourceProviderEntry) {
                LinkedList<ResourceProviderFactoryHandler> factories = new LinkedList<ResourceProviderFactoryHandler>();
                factories.addAll(Arrays.asList(this.requiredFactories));
                factories.remove(handler);
                this.requiredFactories = factories.toArray(new ResourceProviderFactoryHandler[factories.size()]);
            }
        }
    }

    private void bindHandler(ProviderHandler provider) {
        String debugServiceName = this.getDebugServiceName(provider);
        this.logger.debug("bindResourceProvider: Binding {}", (Object)debugServiceName);
        String[] roots = provider.getRoots();
        boolean foundRoot = false;
        if (roots != null) {
            EventAdmin localEA = this.eventAdmin;
            for (String root : roots) {
                foundRoot = true;
                this.addResourceProvider(root, provider);
                this.logger.debug("bindResourceProvider: {}={} ({})", new Object[]{root, provider, debugServiceName});
                if (localEA == null) continue;
                Hashtable<String, String> eventProps = new Hashtable<String, String>();
                ((Dictionary)eventProps).put("path", root);
                localEA.postEvent(new Event("org/apache/sling/api/resource/ResourceProvider/ADDED", eventProps));
            }
        }
        if (!foundRoot) {
            this.logger.info("Ignoring ResourceProvider(Factory) {} : no configured roots.", (Object)provider.getName());
        }
        this.logger.debug("bindResourceProvider: Bound {}, current providers={}", (Object)debugServiceName, Arrays.asList(this.getResourceProviders()));
    }

    private void unbindHandler(ProviderHandler provider) {
        String debugServiceName = this.getDebugServiceName(provider);
        this.logger.debug("unbindResourceProvider: Unbinding {}", (Object)debugServiceName);
        String[] roots = provider.getRoots();
        if (roots != null) {
            EventAdmin localEA = this.eventAdmin;
            for (String root : roots) {
                this.removeResourceProvider(root, provider);
                this.logger.debug("unbindResourceProvider: root={} ({})", (Object)root, (Object)debugServiceName);
                if (localEA == null) continue;
                Hashtable<String, String> eventProps = new Hashtable<String, String>();
                ((Dictionary)eventProps).put("path", root);
                localEA.postEvent(new Event("org/apache/sling/api/resource/ResourceProvider/REMOVED", eventProps));
            }
        }
        this.logger.debug("unbindResourceProvider: Unbound {}, current providers={}", (Object)debugServiceName, Arrays.asList(this.getResourceProviders()));
    }

    private String getDebugServiceName(ProviderHandler provider) {
        if (this.logger.isDebugEnabled()) {
            return provider.getName();
        }
        return null;
    }
}

