/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapEntry
implements Comparable<MapEntry> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Pattern[] URL_WITH_PORT_MATCH = new Pattern[]{Pattern.compile("http/([^/]+)(\\.[^\\d/]+)(/.*)?$"), Pattern.compile("https/([^/]+)(\\.[^\\d/]+)(/.*)?$")};
    private static final String[] URL_WITH_PORT_REPLACEMENT = new String[]{"http/$1$2.80$3", "https/$1$2.443$3"};
    private static final Pattern[] PATH_TO_URL_MATCH = new Pattern[]{Pattern.compile("http/([^/]+)\\.80(/.*)?$"), Pattern.compile("https/([^/]+)\\.443(/.*)?$"), Pattern.compile("([^/]+)/([^/]+)\\.(\\d+)(/.*)?$"), Pattern.compile("([^/]+)/([^/]+)(/.*)?$")};
    private static final String[] PATH_TO_URL_REPLACEMENT = new String[]{"http://$1$2", "https://$1$2", "$1://$2:$3$4", "$1://$2$3"};
    private final Pattern urlPattern;
    private final String[] redirect;
    private final int status;
    private long order;

    public static String appendSlash(String path) {
        if (!path.endsWith("/")) {
            path = path.concat("/");
        }
        return path;
    }

    public static String getURI(String scheme, String host, int port, String path) {
        StringBuilder sb = new StringBuilder();
        sb.append(scheme).append("://").append(host);
        if (!(port <= 0 || port == 80 && "http".equals(scheme) || port == 443 && "https".equals(scheme))) {
            sb.append(':').append(port);
        }
        sb.append(path);
        return sb.toString();
    }

    public static String fixUriPath(String uriPath) {
        for (int i = 0; i < URL_WITH_PORT_MATCH.length; ++i) {
            Matcher m = URL_WITH_PORT_MATCH[i].matcher(uriPath);
            if (!m.find()) continue;
            return m.replaceAll(URL_WITH_PORT_REPLACEMENT[i]);
        }
        return uriPath;
    }

    public static String toURI(String uriPath) {
        for (int i = 0; i < PATH_TO_URL_MATCH.length; ++i) {
            Matcher m = PATH_TO_URL_MATCH[i].matcher(uriPath);
            if (!m.find()) continue;
            return m.replaceAll(PATH_TO_URL_REPLACEMENT[i]);
        }
        return null;
    }

    public static MapEntry createResolveEntry(String url, Resource resource, boolean trailingSlash) {
        ValueMap props = (ValueMap)resource.adaptTo(ValueMap.class);
        if (props != null) {
            url = MapEntry.fixUriPath(url);
            String redirect = (String)props.get("sling:redirect", String.class);
            if (redirect != null) {
                int status = (Integer)props.get("sling:status", (Object)302);
                return new MapEntry(url, status, trailingSlash, 0L, redirect);
            }
            String[] internalRedirectProps = (String[])props.get("sling:internalRedirect", String[].class);
            String[] internalRedirect = MapEntry.filterRegExp(internalRedirectProps);
            if (internalRedirect != null) {
                return new MapEntry(url, -1, trailingSlash, 0L, internalRedirect);
            }
        }
        return null;
    }

    public static List<MapEntry> createMapEntry(String url, Resource resource, boolean trailingSlash) {
        ValueMap props = (ValueMap)resource.adaptTo(ValueMap.class);
        if (props != null) {
            String[] internalRedirect;
            String redirect = (String)props.get("sling:redirect", String.class);
            if (redirect != null) {
                LoggerFactory.getLogger(MapEntry.class).info("createMapEntry: Configuration has external redirect to {}; not creating mapping for configuration in {}", (Object)redirect, (Object)resource.getPath());
                return null;
            }
            if (MapEntry.isRegExp(url)) {
                LoggerFactory.getLogger(MapEntry.class).info("createMapEntry: URL {} contains a regular expression; not creating mapping for configuration in {}", (Object)url, (Object)resource.getPath());
                return null;
            }
            String endHook = "";
            if (url.endsWith("$")) {
                endHook = "$";
                url = url.substring(0, url.length() - 1);
            }
            if (url.startsWith("[^/]+/[^/]+")) {
                url = url.substring("[^/]+/[^/]+".length());
            }
            if ((internalRedirect = (String[])props.get("sling:internalRedirect", String[].class)) != null) {
                int status = -1;
                String pathUri = MapEntry.toURI(url);
                if (pathUri != null) {
                    url = pathUri;
                    status = 302;
                }
                ArrayList<MapEntry> prepEntries = new ArrayList<MapEntry>(internalRedirect.length);
                for (String redir : internalRedirect) {
                    if (redir.contains("$")) continue;
                    MapEntry mapEntry = null;
                    try {
                        mapEntry = new MapEntry(redir.concat(endHook), status, trailingSlash, 0L, url);
                    }
                    catch (IllegalArgumentException iae) {
                        LoggerFactory.getLogger(MapEntry.class).debug("Ignoring mapping due to exception: " + iae.getMessage(), (Throwable)iae);
                    }
                    if (mapEntry == null) continue;
                    prepEntries.add(mapEntry);
                }
                if (prepEntries.size() > 0) {
                    return prepEntries;
                }
            }
        }
        return null;
    }

    public MapEntry(String url, int status, boolean trailingSlash, long order, String ... redirect) {
        if (trailingSlash) {
            url = MapEntry.appendSlash(url);
            for (int i = 0; i < redirect.length; ++i) {
                redirect[i] = MapEntry.appendSlash(redirect[i]);
            }
        }
        if (!url.startsWith("^")) {
            url = "^".concat(url);
        }
        try {
            this.urlPattern = Pattern.compile(url);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Bad url pattern: " + url, e);
        }
        this.redirect = redirect;
        this.status = status;
        this.order = order;
    }

    public String[] replace(String value) {
        Matcher m = this.urlPattern.matcher(value);
        if (m.find()) {
            String[] redirects = this.getRedirect();
            String[] results = new String[redirects.length];
            for (int i = 0; i < redirects.length; ++i) {
                try {
                    results[i] = m.replaceFirst(redirects[i]);
                    continue;
                }
                catch (StringIndexOutOfBoundsException siob) {
                    this.log.debug("Exception while replacing, ignoring entry {} ", (Object)redirects[i], (Object)siob);
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    this.log.debug("Exception while replacing, ignoring entry {} ", (Object)redirects[i], (Object)iae);
                }
            }
            return results;
        }
        return null;
    }

    public String getPattern() {
        return this.urlPattern.toString();
    }

    public String[] getRedirect() {
        return this.redirect;
    }

    public boolean isInternal() {
        return this.getStatus() < 0;
    }

    public int getStatus() {
        return this.status;
    }

    @Override
    public int compareTo(MapEntry m) {
        int mlen;
        if (this == m) {
            return 0;
        }
        String ownPatternString = this.urlPattern.toString();
        String mPatternString = m.urlPattern.toString();
        int tlen = ownPatternString.length();
        if (tlen < (mlen = mPatternString.length())) {
            return 1;
        }
        if (tlen > mlen) {
            return -1;
        }
        int stringComparison = ownPatternString.toString().compareTo(mPatternString);
        if (stringComparison == 0 && this.order != m.order) {
            if (m.order > this.order) {
                return 1;
            }
            return -1;
        }
        return stringComparison;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("MapEntry: match:").append(this.urlPattern);
        buf.append(", replacement:");
        if (this.getRedirect().length == 1) {
            buf.append(this.getRedirect()[0]);
        } else {
            buf.append(Arrays.asList(this.getRedirect()));
        }
        if (this.isInternal()) {
            buf.append(", internal");
        } else {
            buf.append(", status:").append(this.getStatus());
        }
        return buf.toString();
    }

    private static boolean isRegExp(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                ++i;
                continue;
            }
            if ("+*?|()[]".indexOf(c) < 0) continue;
            return true;
        }
        return false;
    }

    private static String[] filterRegExp(String ... strings) {
        if (strings == null || strings.length == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(strings.length);
        for (String string : strings) {
            if (MapEntry.isRegExp(string)) continue;
            list.add(string);
        }
        return list.isEmpty() ? null : list.toArray(new String[list.size()]);
    }

    void setOrder(long order) {
        this.order = order;
    }
}

